(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



BeginPackage["MathKFD`"];


KernelMatrix::usage="KernelMatrix[K,X] computes the (full) matrix with elements K[x\[LeftDoubleBracket]i\[RightDoubleBracket],x\[LeftDoubleBracket]j\[RightDoubleBracket]].";
IdentityKernel::usage="IdentityKernel[x,y] is the function x.y.";
RBFKernel::usage="RBFKernel[x,y] is the function Exp[-\[Gamma](x-y).(x-y)].";
PolynomialKernel::usage="PolynomialKernel[x,y,d], where d is an integer, is the function (x.y+1\!\(\*SuperscriptBox[\()\), \(d\)]\).";
StringKernel::usage="StringKernel[{x},{y},d], where d is an integer, is the function (n-EditDistance[x,y]\!\(\*SuperscriptBox[\()\), \(d\)]\).";
LocalStringKernel::usage="LocalStringKernel[{x},{y},d,w], where d and w are integers, is the function \!\(\*UnderscriptBox[\(\[Sum]\), \(p\)]\)(1-EditDistance[x[[p-w,p+w]],y[[p-w,p+w]]]/(2w+1)\!\(\*SuperscriptBox[\()\), \(d\)]\).";
ProjectKFD::usage="ProjectKFD[K,X,\[Alpha],\[Beta],x] predicts a label for a new case x using the trained Fisher discriminant model {kernel K, data X, multipliers \[Alpha], bias b}.";
TrainKFD::usage="{\[Alpha],\[Beta]}=TrainKFD[K,X,y] trains a Fisher discriminant in feature space (kernel K, training data X, training labels y). The multiplier vector \[Alpha] is computed by maximizing the ratio (\!\(\*SuperscriptBox[\(\[Alpha]\), \(T\)]\)B \[Alpha])/(\!\(\*SuperscriptBox[\(\[Alpha]\), \(T\)]\)W \[Alpha]) where B is the between-class scatter and W is the within-class scatter in the feature space induced by the kernel K. A Mahalonobis bias \!\(\*FormBox[\(\[Beta] = \((\*SubscriptBox[\(\[Mu]\), \(+\)]\)\),
TraditionalForm]\)\!\(\*FormBox[\(\(\(\*SubscriptBox[\(\[Sigma]\), \(-\)] + \*SubscriptBox[\(\[Mu]\), \(-\)] \*SubscriptBox[\(\[Sigma]\), \(+\)]\)\()\)\)/\((\*SubscriptBox[\(\[Sigma]\), \(+\)] + \*SubscriptBox[\(\[Sigma]\), \(-\)])\)\),
TraditionalForm]\) is also calculated. Returns the multiplier vector and the bias as {\[Alpha],\[Beta]} so that subsequent classification of a single data point x can be achieved through \[Alpha].x - \[Beta].";
ReducedKFD::usage=
"ReducedKFD[K,X,y,\[Alpha],\[Beta]] returns a reduced size training set {Xr,yr} from an already trained Fisher discriminant. Points selected for the reduced training set have projections that lie between 0 and \[Mu]\!\(\*OverscriptBox[\(-\), \(+\)]\)\[Sigma] for each class.";
ScoreKFD::usage=
"ScoreKFD[K,X,y,\[Alpha],\[Beta]] returns the accuracy with which the Fisher discriminant classifies its own training data, X.";
KernelDistance::usage="KernelDistance[x,y,K] gives the euclidean (\!\(\*SubscriptBox[\(L\), \(2\)]\)) distance between x and y in the feature space induced by the kernel K.";
DataPlotKFD::usage=
"DataPlotKFD[X,y,Xt,yt] uses ListPlot to produce (X,y) Training and (Xt,yt) Testing dataplots in a graphics grid.";
ContourPlotKFD::usage="ContourPlotKFD[K,X,y,\[Alpha],\[Beta],Xt,yt] uses a trained projection \[Alpha] and bias b, to produce 2D plots showing the Fisher discriminating contour for 2D training and testing data.";
ContourPlot3DKFD::usage =
" ContourPlot3DKFD[K,X,y,\[Alpha],\[Beta],Xt,yt] uses a trained projetion \[Alpha] and bias b, to produce a 3D plot showing the Fisher discriminating surface for 3D test data {Xt,yt}."; 
BarChartKFD::usage =
"BarChartKFD[K,X,y,\[Alpha],\[Beta],Xt,yt,title] uses a trained Fisher discriminant K,X,y,\[Alpha],\[Beta] to produce a histogram plot of the Fisher projection onto the primary discriminating eigenvector of the test data Xt,yt"; 


Begin["MathKFD`Private`"];


KernelMatrix[K_,X_]:=Outer[K,X,X,1]


IdentityKernel[x_,y_]:=x.y


RBFKernel[x_,y_,\[Gamma]_]:=Exp[-\[Gamma](x-y).(x-y)]


PolynomialKernel[x_,y_,d_Integer]:=(x.y+1)^d


StringKernel[{x_},{y_},d_Integer]:=N[(StringLength[x]-EditDistance[x,y])^d]


LocalStringKernel[{x_},{y_},d_Integer,w_Integer]:=Module[{n,m},
n=StringLength[x];
m=n/2;N[Sum[(m-Abs[m-p])(1-EditDistance[StringTake[x,{p-w,p+w}],StringTake[y,{p-w,p+w}]]/(2w+1))^d,{p,w+1,n-w-1}]]
]


ProjectKFD[K_,X_,\[Alpha]_,\[Beta]_,x_]:=
Total[(\[Alpha]*Map[K[#,x]&,X])]-\[Beta]


TrainKFD[K_,X_,y_]:=
Module[{L,X1,X2,L1,L2,M1,M2,MT,K1,K2,I1,I2,U1,U2,NB,muI,A,\[Alpha],Pf,P1,P2,\[Beta],min1,max2},
L=Length[X];
X1=Extract[X,Position[y,1]];
X2=Extract[X,Position[y,-1]];
L1=Length[X1];
L2=Length[X2];
M1=Table[Total[Map[K[X[[j]],#]&,X1]]/L1,{j,1,L}];
M2=Table[Total[Map[K[X[[j]],#]&,X2]]/L1,{j,1,L}];
MT=Outer[Times,M1-M2,M1-M2];
K1=Outer[K,X,X1,1];
K2=Outer[K,X,X2,1];
I1=IdentityMatrix[L1];
I2=IdentityMatrix[L2];
U1=(1/L1)Table[Table[1,{L1}],{L1}];
U2=(1/L2)Table[Table[1,{L2}],{L2}];
NB=(K1.(I1-U1).Transpose[K1])+(K2.(I2-U2).Transpose[K2]);
muI=L IdentityMatrix[L];
A=Inverse[NB + muI] . MT;
\[Alpha]=First[Eigenvectors[A,1]];
Pf=ProjectKFD[K,X,\[Alpha],0,#]&;
P1=Map[Pf,X1];
P2=Map[Pf,X2];
\[Beta]=(Mean[P1]StandardDeviation[P2]+Mean[P2]StandardDeviation[P1])/
  (StandardDeviation[P2]+StandardDeviation[P1]);
If[Mean[P2]>Mean[P1],
P1=-P1;
P2=-P2;
{\[Alpha],\[Beta]}=-{\[Alpha],\[Beta]}
];
max2=Max[P2];
min1=Min[P1];
If[max2<min1,\[Beta]=(max2+min1)/2];
{\[Alpha],\[Beta]}
]


ScoreKFD[K_,X_,y_,\[Alpha]_,\[Beta]_]:=
Module[{X1,X2,Pf,P1,P2,s},
X1=Extract[X,Position[y,1]];
X2=Extract[X,Position[y,-1]];
Pf=ProjectKFD[K,X,\[Alpha],\[Beta],#]&;
P1=Map[Pf,X1];
P2=Map[Pf,X2];
s=N[(Length[Select[P1,# > 0 &]]+Length[Select[P2,#< 0 &]])/(Length[P1]+Length[P2])];
s
]


ReducedKFD[K_,X_,y_,\[Alpha]_,\[Beta]_]:=
Module[{X1,X2,Pf,P1,P2,\[Mu]1,\[Mu]2,\[Sigma]1,\[Sigma]2,X1r,X2r},
X1=Extract[X,Position[y,1]];
X2=Extract[X,Position[y,-1]];
Pf=ProjectKFD[K,X,\[Alpha],\[Beta],#]&;
P1=Map[Pf,X1];
P2=Map[Pf,X2];
\[Mu]1=Mean[P1];
\[Mu]2=Mean[P2];
\[Sigma]1=StandardDeviation[P1];
\[Sigma]2=StandardDeviation[P2];
X1r=Select[X1,ProjectKFD[K,X,\[Alpha],\[Beta],#]<\[Mu]1-\[Sigma]1/2&];
X2r=Select[X2,\[Mu]2+\[Sigma]2/2< ProjectKFD[K,X,\[Alpha],\[Beta],#]&];
{Join[X1r,X2r],Join[Table[1,{Length[X1r]}],Table[-1,{Length[X2r]}]]}
] 


KernelDistance[x_,y_,K_]:=Sqrt[K[x,x]+K[y,y]-2K[x,y]]


DataPlotKFD[X_,y_,Xt_,yt_]:=
Module[{Xa,Xp,Xn,Xpt,Xnt,plotRange,gTrain,gTest},
Xa=Join[X,Xt];
plotRange ={{Min[Xa[[All,1]]],Max[Xa[[All,1]]]},{Min[Xa[[All,2]]],Max[Xa[[All,2]]]}};
Xp=Extract[X,Position[y,1]];
Xn=Extract[X,Position[y,-1]];
Xpt=Extract[Xt,Position[yt,1]];
Xnt=Extract[Xt,Position[yt,-1]];gTrain=ListPlot[{Xp,Xn},PlotRange->All,AspectRatio->1,PlotRange->plotRange,PlotLabel->"Training Data"];
gTest=ListPlot[{Xpt,Xnt},PlotRange->All,AspectRatio->1,PlotRange->plotRange,PlotLabel->"Testing Data"];
GraphicsGrid[{{gTrain,gTest}}]]


ContourPlotKFD[K_,X_,y_,\[Alpha]_,\[Beta]_,Xt_,yt_]:=
Module[{Xa,X1,X2,X1t,X2t,Pf,gTrain,gTest},
Xa=Join[X,Xt];
X1=Extract[X,Position[y,1]];
X2=Extract[X,Position[y,-1]];
X1t=Extract[Xt,Position[yt,1]];
X2t=Extract[Xt,Position[yt,-1]];
Pf=ProjectKFD[K,X,\[Alpha],\[Beta],#]&;
gTrain=Show[
ContourPlot[Pf[{x1,x2}]==0,{x1,Min[Xa[[All,1]]],Max[Xa[[All,1]]]},{x2,Min[Xa[[All,2]]],Max[Xa[[All,2]]]}],
ListPlot[X1,
PlotStyle->{Hue[0.7],PointSize[0.015]}],
ListPlot[X2,
PlotStyle->{Hue[0.85],PointSize[0.015]}] ,PlotLabel->"Training Set"];
gTest=Show[
ContourPlot[Pf[{x1,x2}]== 0,{x1,Min[Xa[[All,1]]],Max[Xa[[All,1]]]},{x2,Min[Xa[[All,2]]],Max[Xa[[All,2]]]}],
ListPlot[X1t,
PlotStyle->{Hue[0.7],PointSize[0.015]}],
ListPlot[X2t,
PlotStyle->{Hue[0.85],PointSize[0.015]}],PlotLabel->"Testing Set" ];
GraphicsGrid[{{gTrain,gTest}}]
]


ContourPlot3DKFD[K_,X_,y_,\[Alpha]_,\[Beta]_,Xt_,yt_]:=
Module[{Xa,X1,X2,X1t,X2t,Pf},
Xa=Join[X,Xt];
X1=Extract[X,Position[y,1]];
X2=Extract[X,Position[y,-1]];
X1t=Extract[Xt,Position[yt,1]];
X2t=Extract[Xt,Position[yt,-1]];
Pf=ProjectKFD[K,X,\[Alpha],\[Beta],#]&;
Show[
ContourPlot3D[Pf[{x1,x2,x3}]==0,{x1,Min[Xa[[All,1]]],Max[Xa[[All,1]]]},{x2,Min[Xa[[All,2]]],Max[Xa[[All,2]]]},{x3,Min[Xa[[All,3]]],Max[Xa[[All,3]]]},
PerformanceGoal->"Speed"],
ListPointPlot3D[X1t,
PlotStyle->{Hue[0.7],PointSize[0.015]}],
ListPointPlot3D[X2t,
PlotStyle->{Hue[0.85],PointSize[0.015]}]]
]


BarChartKFD[K_,X_,y_,\[Alpha]_,\[Beta]_,Xt_,yt_,title_:"KFD Classifier"]:=Module[{X1,X2,X1t,X2t,Pf,P1,P2,P1t,P2t,PA,min,max,sensitivity,specificity,accuracy,bins,classBin,plotLabel,H1,H2,H1t,H2t,newdata},X1=Extract[X,Position[y,1]];
X2=Extract[X,Position[y,-1]];
X1t=Extract[Xt,Position[yt,1]];
X2t=Extract[Xt,Position[yt,-1]];
Pf=ProjectKFD[K,X,\[Alpha],\[Beta],#]&;
P1t=Map[Pf,X1t];
P2t=Map[Pf,X2t];
PA=Join[P1t,P2t];
{min,max}={Min[PA],Max[PA]};
sensitivity=N[Length[Select[P1t,#>0&]]/Length[P1t],2];specificity=N[Length[Select[P2t,#<0&]]/Length[P2t],2];
accuracy=N[(Length[Select[P1t,#>0&]]+Length[Select[P2t,#<0&]])/(Length[P1t]+Length[P2t]),2];
bins=40;
classBin=Floor[1+bins (0-min)/(max-min)];
plotLabel=Column[{
title,
Row[{"features = ",Length[X[[1]]]}],
Row[{Style["K",Italic],"(",Subscript[Style["x",Italic], Style["i",Italic]],", ", Subscript[Style["x",Italic], Style["j",Italic]],") = ",StringReplace[ ToString[InputForm[K["x","y"]]],{"\""->"","x"->"\!\(\*SubscriptBox[\(x\), \(i\)]\)","y"->"\!\(\*SubscriptBox[\(x\), \(j\)]\)"}]}],
Row[{"training set: ",Style["p",Italic]," = ",Length[X1], ", ", Style["n",Italic]," = ",Length[X2]}],
Row[{"testing set: ",Style["p",Italic]," = ",Length[P1t],", ",Style["n",Italic]," = ",Length[P2t]}],
Row[{"sensitivity = ",sensitivity,", specificity = " ,specificity,", accuracy = ",accuracy}]
},Alignment->Center];
H1t=BinCounts[P1t,{min,max,(max-min)/bins}];
H2t=BinCounts[P2t,{min,max,(max-min)/bins}];
newdata=MapAt[Labeled[#,"^",Below]&,Transpose[{H1t,H2t}],classBin];
BarChart[newdata,PlotLabel->Style[plotLabel,Small],Ticks->{None,Automatic}]]


End[];


EndPackage[];



