(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    195007,       4581]
NotebookOptionsPosition[     92029,       2245]
NotebookOutlinePosition[    190197,       4415]
CellTagsIndexPosition[    190125,       4410]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["MathKFD",
  FontSlant->"Italic"],
 " Package"
}], "Title",
 InitializationCell->True,
 CellChangeTimes->{{3.4179005158865004`*^9, 3.4179005179255004`*^9}, {
   3.417923366851304*^9, 3.417923370071304*^9}, 3.518988564565331*^9}],

Cell["Hugh Murrell", "Author",
 CellChangeTimes->{{3.45874509787572*^9, 3.458745100804435*^9}, 
   3.497284407908271*^9, 3.518988405968418*^9, {3.518988493290699*^9, 
   3.518988495185988*^9}, 3.5195703741392307`*^9}],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellChangeTimes->{{3.458730030544246*^9, 3.45873005038454*^9}, {
   3.458730090455993*^9, 3.458730092356075*^9}, 3.497284478760283*^9}],

Cell[TextData[{
 "This package provides support for Fisher discriminant analysis with \
kernels, and various learning theory-related statistics. This package was \
tested with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 8."
}], "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.4179919745548916`*^9, 3.4179920335418916`*^9}, {
  3.4197301808296003`*^9, 3.4197301832936*^9}, {3.50532182684475*^9, 
  3.505321835266625*^9}, {3.5189884526912537`*^9, 3.518988462151688*^9}}],

Cell["\<\
You are welcome to freely use this software for academic and other \
noncommercial applications.\
\>", "Text",
 InitializationCell->True,
 CellChangeTimes->{{3.417992130234892*^9, 3.417992136979892*^9}, {
   3.4197301998486*^9, 3.4197302027586*^9}, 3.50532184315725*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Definition", "Section",
 InitializationGroup->True,
 CellChangeTimes->{
  3.5189885075924788`*^9, {3.519064904805731*^9, 3.519064906017271*^9}}],

Cell["Introduce global names and perform general setup.", "Text",
 InitializationGroup->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<MathKFD`\>\"", "]"}], ";"}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{{3.4179004200325003`*^9, 3.4179004225565004`*^9}, {
  3.4179004886735*^9, 3.4179004897895*^9}, {3.417923374261304*^9, 
  3.417923376980304*^9}, {3.4180039186606913`*^9, 3.4180039226706915`*^9}, {
  3.4180040022496915`*^9, 3.4180040049456916`*^9}, {3.4180051713096914`*^9, 
  3.4180051743096914`*^9}, {3.4180052454336915`*^9, 3.4180052470636916`*^9}, {
  3.418189234151131*^9, 3.418189259558131*^9}, {3.505079430161875*^9, 
  3.505079430630625*^9}}],

Cell[CellGroupData[{

Cell["Public Symbols with Usage Messages", "Subsection",
 InitializationGroup->True,
 CellChangeTimes->{{3.518988514001935*^9, 3.518988525226001*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"KernelMatrix", "::", "usage"}], "=", 
   "\"\<KernelMatrix[K,X] computes the (full) matrix with elements K[x\
\[LeftDoubleBracket]i\[RightDoubleBracket],x\[LeftDoubleBracket]j\
\[RightDoubleBracket]].\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"IdentityKernel", "::", "usage"}], "=", 
   "\"\<IdentityKernel[x,y] is the function x.y.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RBFKernel", "::", "usage"}], "=", 
   "\"\<RBFKernel[x,y] is the function Exp[-\[Gamma](x-y).(x-y)].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolynomialKernel", "::", "usage"}], "=", 
   "\"\<PolynomialKernel[x,y,d], where d is an integer, is the function \
(x.y+1\!\(\*SuperscriptBox[\()\), \(d\)]\).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"StringKernel", "::", "usage"}], "=", 
   "\"\<StringKernel[{x},{y},d], where d is an integer, is the function \
(n-EditDistance[x,y]\!\(\*SuperscriptBox[\()\), \(d\)]\).\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LocalStringKernel", "::", "usage"}], "=", 
   "\"\<LocalStringKernel[{x},{y},d,w], where d and w are integers, is the \
function \!\(\*UnderscriptBox[\(\[Sum]\), \
\(p\)]\)(1-EditDistance[x[[p-w,p+w]],y[[p-w,p+w]]]/(2w+1)\!\(\*SuperscriptBox[\
\()\), \(d\)]\).\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProjectKFD", "::", "usage"}], "=", 
   "\"\<ProjectKFD[K,X,\[Alpha],\[Beta],x] predicts a label for a new case x \
using the trained Fisher discriminant model {kernel K, data X, multipliers \
\[Alpha], bias b}.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TrainKFD", "::", "usage"}], "=", 
   "\"\<{\[Alpha],\[Beta]}=TrainKFD[K,X,y] trains a Fisher discriminant in \
feature space (kernel K, training data X, training labels y). The multiplier \
vector \[Alpha] is computed by maximizing the ratio (\!\(\*SuperscriptBox[\(\
\[Alpha]\), \(T\)]\)B \[Alpha])/(\!\(\*SuperscriptBox[\(\[Alpha]\), \(T\)]\)W \
\[Alpha]) where B is the between-class scatter and W is the within-class \
scatter in the feature space induced by the kernel K. A Mahalonobis bias \
\!\(TraditionalForm\`\[Beta] = \((\*SubscriptBox[\(\[Mu]\), \
\(+\)]\)\)\!\(TraditionalForm\`\(\(\*SubscriptBox[\(\[Sigma]\), \(-\)] + \
\*SubscriptBox[\(\[Mu]\), \(-\)] \*SubscriptBox[\(\[Sigma]\), \
\(+\)]\)\()\)\)/\((\*SubscriptBox[\(\[Sigma]\), \(+\)] + \*SubscriptBox[\(\
\[Sigma]\), \(-\)])\)\) is also calculated. Returns the multiplier vector and \
the bias as {\[Alpha],\[Beta]} so that subsequent classification of a single \
data point x can be achieved through \[Alpha].x - \[Beta].\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ReducedKFD", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<ReducedKFD[K,X,y,\[Alpha],\[Beta]] returns a reduced size training \
set {Xr,yr} from an already trained Fisher discriminant. Points selected for \
the reduced training set have projections that lie between 0 and \
\[Mu]\!\(\*OverscriptBox[\(-\), \(+\)]\)\[Sigma] for each class.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScoreKFD", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<ScoreKFD[K,X,y,\[Alpha],\[Beta]] returns the accuracy with which the \
Fisher discriminant classifies its own training data, X.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"KernelDistance", "::", "usage"}], "=", 
   "\"\<KernelDistance[x,y,K] gives the euclidean (\!\(\*SubscriptBox[\(L\), \
\(2\)]\)) distance between x and y in the feature space induced by the kernel \
K.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DataPlotKFD", "::", "usage"}], "=", "\[IndentingNewLine]", 
   "\"\<DataPlotKFD[X,y,Xt,yt] uses ListPlot to produce (X,y) Training and \
(Xt,yt) Testing dataplots in a graphics grid.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ContourPlotKFD", "::", "usage"}], "=", 
   "\"\<ContourPlotKFD[K,X,y,\[Alpha],\[Beta],Xt,yt] uses a trained \
projection \[Alpha] and bias b, to produce 2D plots showing the Fisher \
discriminating contour for 2D training and testing data.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ContourPlot3DKFD", "::", "usage"}], " ", "=", 
    "\[IndentingNewLine]", 
    "\"\< ContourPlot3DKFD[K,X,y,\[Alpha],\[Beta],Xt,yt] uses a trained \
projetion \[Alpha] and bias b, to produce a 3D plot showing the Fisher \
discriminating surface for 3D test data {Xt,yt}.\>\""}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"BarChartKFD", "::", "usage"}], " ", "=", "\[IndentingNewLine]", 
    "\"\<BarChartKFD[K,X,y,\[Alpha],\[Beta],Xt,yt,title] uses a trained \
Fisher discriminant K,X,y,\[Alpha],\[Beta] to produce a histogram plot of the \
Fisher projection onto the primary discriminating eigenvector of the test \
data Xt,yt\>\""}], ";"}], " "}]}], "Input",
 InitializationGroup->True,
 CellChangeTimes->{{3.4179006810871005`*^9, 3.4179007894451003`*^9}, {
   3.4179008450311003`*^9, 3.4179009080321007`*^9}, {3.4179009404251003`*^9, 
   3.4179009730501003`*^9}, {3.4179013013141003`*^9, 3.4179013255711*^9}, {
   3.4179013831801004`*^9, 3.4179013901611004`*^9}, {3.4179014321601005`*^9, 
   3.4179015090411005`*^9}, 3.4179015580421004`*^9, 3.4179015956001005`*^9, {
   3.4179017029421005`*^9, 3.4179017282941003`*^9}, {3.4179017619661007`*^9, 
   3.4179017866901007`*^9}, {3.4179018572531004`*^9, 
   3.4179018742671003`*^9}, {3.4179019256741004`*^9, 
   3.4179020288061004`*^9}, {3.4179021023431005`*^9, 3.4179021610261*^9}, {
   3.417920286632904*^9, 3.4179202968559036`*^9}, {3.417920742062904*^9, 
   3.417920839408904*^9}, 3.417920872797904*^9, {3.4179209054199038`*^9, 
   3.417920925813904*^9}, {3.4179209590819035`*^9, 3.417921063712904*^9}, {
   3.4179234111123037`*^9, 3.417923419863304*^9}, {3.4179875638164916`*^9, 
   3.4179876272194915`*^9}, {3.4180836891841183`*^9, 
   3.4180839361821184`*^9}, {3.418086027195119*^9, 3.4180860898441186`*^9}, {
   3.4180862373431187`*^9, 3.4180862545681186`*^9}, {3.4181868077971315`*^9, 
   3.4181869726031313`*^9}, {3.4182042692500925`*^9, 
   3.4182043060170927`*^9}, {3.4182043394550924`*^9, 3.418204531018092*^9}, {
   3.4182830681835146`*^9, 3.4182830709285145`*^9}, {3.4183353635858707`*^9, 
   3.4183354138426123`*^9}, {3.4183354486890965`*^9, 3.418335519219149*^9}, {
   3.4183360430435266`*^9, 3.4183360439356155`*^9}, {3.4183361931925397`*^9, 
   3.4183362169489155`*^9}, {3.418336546410858*^9, 3.418336644612677*^9}, {
   3.418345452208722*^9, 3.4183454935648575`*^9}, {3.418345537720272*^9, 
   3.418345555658066*^9}, {3.4183466551500044`*^9, 3.4183466963401227`*^9}, {
   3.418346742626751*^9, 3.4183469233398204`*^9}, {3.418346980412527*^9, 
   3.4183470393464203`*^9}, {3.418347679742453*^9, 3.418347692787758*^9}, {
   3.4183477591133895`*^9, 3.418347764426921*^9}, {3.418347916806157*^9, 
   3.4183479619646726`*^9}, {3.418349165039968*^9, 3.418349229285392*^9}, 
   3.418518120560309*^9, {3.4187553298073015`*^9, 3.4187554349823017`*^9}, {
   3.4187554728193016`*^9, 3.4187557787523017`*^9}, {3.4187617854913015`*^9, 
   3.4187618541293015`*^9}, 3.4187991917459*^9, 3.4187992507099*^9, {
   3.4187993343609*^9, 3.4187993905699005`*^9}, {3.4188820820787077`*^9, 
   3.418882202838708*^9}, {3.419032763971491*^9, 3.419032764683491*^9}, {
   3.4190328630414915`*^9, 3.419032894910491*^9}, {3.4190329759964914`*^9, 
   3.4190330476564913`*^9}, {3.4190331441004915`*^9, 3.419033214769491*^9}, {
   3.419033251210491*^9, 3.419033270237491*^9}, {3.419033309422491*^9, 
   3.419033428905491*^9}, {3.419033461131491*^9, 3.4190335668674912`*^9}, {
   3.4190336132554913`*^9, 3.4190336154134912`*^9}, {3.419033658025491*^9, 
   3.4190337187484913`*^9}, {3.419035573219491*^9, 3.419035589436491*^9}, {
   3.4194669588129997`*^9, 3.419467020599*^9}, {3.41946706073*^9, 
   3.419467184403*^9}, {3.419467225074*^9, 3.419467265539*^9}, {
   3.4194679390620003`*^9, 3.4194679477609997`*^9}, {3.4194679865179996`*^9, 
   3.419468071995*^9}, {3.419468108873*^9, 3.4194681096610003`*^9}, {
   3.419468191763*^9, 3.419468195918*^9}, {3.4194682568129997`*^9, 
   3.419468277829*^9}, {3.4194885786392*^9, 3.4194886472242002`*^9}, {
   3.4194886847642*^9, 3.4194887125472*^9}, {3.419547778424695*^9, 
   3.4195478299986954`*^9}, {3.419547860924695*^9, 3.419547934678695*^9}, {
   3.419550742459695*^9, 3.4195509041906953`*^9}, {3.419551463001695*^9, 
   3.419551464108695*^9}, {3.419619138285295*^9, 3.419619162252295*^9}, {
   3.4197159070826*^9, 3.4197159433515997`*^9}, {3.4197183220606003`*^9, 
   3.4197183600906*^9}, {3.4197184903026*^9, 3.4197186092226*^9}, {
   3.4197186488946*^9, 3.4197186595956*^9}, {3.4197190298705997`*^9, 
   3.4197190623556004`*^9}, {3.4197302623456*^9, 3.4197302665666*^9}, {
   3.4197303354266*^9, 3.4197303656286*^9}, {3.4197304219656*^9, 
   3.4197304237706003`*^9}, {3.4197627390501003`*^9, 3.4197627745661*^9}, {
   3.50532250715725*^9, 3.505322560251*^9}, {3.51906342282381*^9, 
   3.519063423220471*^9}, {3.5190634640237103`*^9, 3.519063464370463*^9}, {
   3.519742241752458*^9, 3.5197422502615767`*^9}, 3.5206287217686*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Public Options", "Subsection",
 InitializationGroup->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<MathKFD`Private`\>\"", "]"}], ";"}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{{3.4179933692830915`*^9, 3.4179933778920918`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kernel Functions", "Section",
 InitializationCell->True,
 InitializationGroup->True],

Cell[TextData[{
 "This function creates an ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"n", "\[Times]", "n"}]}], TraditionalForm]], "Math"],
 " matrix by applying the kernel function to all combinations of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "p"}], TraditionalForm]], "Math"],
 " matrix ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "Math"],
 ", i.e., ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"K", "(", 
      RowBox[{
       SubscriptBox["x", "i"], ",", 
       SubscriptBox["x", "j"]}], ")"}], "=", 
     RowBox[{
      RowBox[{"\[Phi]", "(", 
       SubscriptBox["x", "i"], ")"}], ".", 
      RowBox[{"\[Phi]", "(", 
       SubscriptBox["x", "j"], ")"}]}]}], "]"}], TraditionalForm]], "Math"],
 "."
}], "Text",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.518988587782208*^9, 3.518988628726059*^9}, 
   3.519743315515132*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"KernelMatrix", "[", 
   RowBox[{"K_", ",", "X_"}], "]"}], ":=", 
  RowBox[{"Outer", "[", 
   RowBox[{"K", ",", "X", ",", "X", ",", "1"}], "]"}]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{{3.4179019087571*^9, 3.4179019147661004`*^9}}],

Cell[CellGroupData[{

Cell["Identity Kernel", "Subsection",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{3.518988637462892*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"IdentityKernel", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"x", ".", "y"}]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{
  3.4188510224287057`*^9, {3.4188519523187056`*^9, 3.4188519536277056`*^9}, {
   3.4188520383187056`*^9, 3.4188520385867057`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RBF Kernel", "Subsection",
 InitializationCell->True,
 InitializationGroup->True],

Cell[TextData[{
 "This kernel depends only on the distance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"d", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}]}]}], TraditionalForm]], "Math"],
 ". One could consider an RBF kernel using an inner kernel function, so that \
it depends on the distance in some other ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "Math"],
 "-space."
}], "Text",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{
  3.497283106605122*^9, {3.497283901926704*^9, 3.49728390842843*^9}, 
   3.497283939408134*^9, 3.518988652138844*^9, {3.518988682512795*^9, 
   3.518988700312244*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"RBFKernel", "[", 
   RowBox[{"x_", ",", "y_", ",", "\[Gamma]_"}], "]"}], ":=", 
  RowBox[{"Exp", "[", 
   RowBox[{
    RowBox[{"-", "\[Gamma]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}]}]}], "]"}]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{{3.418850539107706*^9, 3.4188505467597055`*^9}, {
   3.4188506481657057`*^9, 3.4188506523257055`*^9}, {3.4188508083297057`*^9, 
   3.4188508348307056`*^9}, 3.418851044287706*^9, {3.418852655946706*^9, 
   3.418852660182706*^9}, {3.418854796945706*^9, 3.418854801228706*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynomial Kernel", "Subsection",
 InitializationCell->True,
 InitializationGroup->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolynomialKernel", "[", 
   RowBox[{"x_", ",", "y_", ",", "d_Integer"}], "]"}], ":=", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", ".", "y"}], "+", "1"}], ")"}], "d"]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{3.418851059208706*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["String Kernels", "Subsection",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4197158188915997`*^9, 3.4197158212195997`*^9}, {
  3.4197182925806*^9, 3.4197182992665997`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringKernel", "[", 
   RowBox[{
    RowBox[{"{", "x_", "}"}], ",", 
    RowBox[{"{", "y_", "}"}], ",", "d_Integer"}], "]"}], ":=", 
  RowBox[{"N", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"StringLength", "[", "x", "]"}], "-", 
      RowBox[{"EditDistance", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], ")"}], "d"], "]"}]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{
  3.418851059208706*^9, {3.4197158248476*^9, 3.4197158657036*^9}, {
   3.4197162423906*^9, 3.4197162512306004`*^9}, {3.4197169781446*^9, 
   3.4197169924306*^9}, {3.4197182482506*^9, 3.4197182623006*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LocalStringKernel", "[", 
   RowBox[{
    RowBox[{"{", "x_", "}"}], ",", 
    RowBox[{"{", "y_", "}"}], ",", "d_Integer", ",", "w_Integer"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", "m"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"StringLength", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"m", "=", 
      RowBox[{"n", "/", "2"}]}], ";", 
     RowBox[{"N", "[", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "-", 
           RowBox[{"Abs", "[", 
            RowBox[{"m", "-", "p"}], "]"}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"EditDistance", "[", 
              RowBox[{
               RowBox[{"StringTake", "[", 
                RowBox[{"x", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"p", "-", "w"}], ",", 
                   RowBox[{"p", "+", "w"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"StringTake", "[", 
                RowBox[{"y", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"p", "-", "w"}], ",", 
                   RowBox[{"p", "+", "w"}]}], "}"}]}], "]"}]}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "w"}], "+", "1"}], ")"}]}]}], ")"}], "d"]}], ",", 
        RowBox[{"{", 
         RowBox[{"p", ",", 
          RowBox[{"w", "+", "1"}], ",", 
          RowBox[{"n", "-", "w", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{
  3.418851059208706*^9, {3.4197158248476*^9, 3.4197158657036*^9}, {
   3.4197162423906*^9, 3.4197162512306004`*^9}, {3.4197169781446*^9, 
   3.4197169924306*^9}, {3.4197182482506*^9, 3.4197182623006*^9}, {
   3.4197187270016003`*^9, 3.4197189571906*^9}, {3.4197194801275997`*^9, 
   3.4197194818166*^9}, {3.4197201788016*^9, 3.4197202534835997`*^9}, {
   3.4197202864175997`*^9, 3.4197203956876*^9}, {3.4197209627546*^9, 
   3.4197209822406*^9}, {3.519530958680245*^9, 3.51953095979*^9}, 
   3.519531451669142*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["FDA Formulations", "Section",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4179205919339037`*^9, 3.417920594188904*^9}}],

Cell[CellGroupData[{

Cell["Projection Function", "Subsection",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4179206018549037`*^9, 3.4179206168039036`*^9}, {
  3.518988714950687*^9, 3.518988715924444*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProjectKFD", "[", 
   RowBox[{"K_", ",", "X_", ",", "\[Alpha]_", ",", "\[Beta]_", ",", "x_"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "*", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "[", 
          RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", "X"}], "]"}]}], ")"}], 
    "]"}], "-", "\[Beta]"}]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{{3.417920336306904*^9, 3.417920410570904*^9}, {
   3.4179204709149036`*^9, 3.417920507003904*^9}, {3.417920574293904*^9, 
   3.4179205752969036`*^9}, {3.4179206480679035`*^9, 
   3.4179206618249035`*^9}, {3.4179874792674913`*^9, 
   3.4179874863174915`*^9}, {3.4180830182521186`*^9, 
   3.4180830394241185`*^9}, {3.4183347032588315`*^9, 
   3.4183347501442065`*^9}, {3.418337343796589*^9, 3.418337348529062*^9}, {
   3.4183380829524965`*^9, 3.4183380865508566`*^9}, {3.418346564265917*^9, 
   3.418346617394229*^9}, {3.4188806959287076`*^9, 3.4188806986967077`*^9}, {
   3.4188814267877073`*^9, 3.418881431550708*^9}, {3.419033767738491*^9, 
   3.419033776480491*^9}, 3.519530744256428*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Training the Fisher Discriminant", "Subsection",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.417921273273904*^9, 3.417921292292904*^9}}],

Cell[TextData[{
 "Mika [",
 
 CounterBox["Reference", "MikaPhD"],
 "] finds the Fisher discriminant in feature space by maximizing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"J", "(", "\[Alpha]", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[Alpha]", "T"], "M", " ", "\[Alpha]"}], 
     RowBox[{
      SuperscriptBox["\[Alpha]", "T"], "N", " ", "\[Alpha]"}]]}], 
   TraditionalForm]]],
 " with respect to ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "Math"],
 ", where the \[OpenCurlyDoubleQuote]between-class scatter\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["M", "1"], "-", 
       SubscriptBox["M", "2"]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["M", "1"], "-", 
        SubscriptBox["M", "2"]}], ")"}], "T"]}]}], TraditionalForm]], "Math"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["M", "i"], ")"}], "j"], "=", 
    RowBox[{
     FractionBox["1", 
      SubscriptBox["l", "i"]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], 
       SubscriptBox["l", "i"]], 
      RowBox[{"K", "(", 
       RowBox[{
        SubscriptBox["X", "j"], ",", 
        SubsuperscriptBox["X", "k", "i"]}], ")"}]}]}]}], TraditionalForm]], 
  "Math"],
 " (here ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "i"], TraditionalForm]], "Math"],
 " is a vector of length ",
 Cell[BoxData[
  FormBox[
   RowBox[{"l", "=", 
    RowBox[{
     SubscriptBox["l", "1"], "+", 
     SubscriptBox["l", "2"]}]}], TraditionalForm]], "Math"],
 ") and the \[OpenCurlyDoubleQuote]within-class scatter\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"N", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["K", "1"], "(", 
       RowBox[{"I", "-", 
        SubscriptBox[
         SubscriptBox["1", "l"], "1"]}], ")"}], 
      SubsuperscriptBox["K", "1", "T"]}], "+", 
     RowBox[{
      RowBox[{
       SubscriptBox["K", "2"], "(", 
       RowBox[{"I", "-", 
        SubscriptBox[
         SubscriptBox["1", "l"], "2"]}], ")"}], 
      SubsuperscriptBox["K", "2", "T"]}]}]}], TraditionalForm]], "Math"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["K", "i"], "=", 
    RowBox[{"[", 
     RowBox[{"K", "(", 
      RowBox[{
       SubscriptBox["X", "j"], ",", 
       SubsuperscriptBox["X", "k", "i"]}], ")"}], "]"}], " "}], 
   TraditionalForm]], "Math"],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    SubscriptBox["1", "l"], "i"], TraditionalForm]], "Math"],
 " is the matrix with all entries ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SubscriptBox["l", "i"]}], TraditionalForm]], "Math"],
 "."
}], "Text",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.417921307955904*^9, 3.4179218129809036`*^9}, {
   3.4179219910779037`*^9, 3.417921995563904*^9}, {3.417922035615904*^9, 
   3.4179222344499035`*^9}, {3.4179223125189037`*^9, 
   3.4179223344239035`*^9}, {3.4179223677689037`*^9, 3.417922528713904*^9}, {
   3.417922770135904*^9, 3.417922905392904*^9}, {3.4179229756249037`*^9, 
   3.4179229966599035`*^9}, {3.4179230359799037`*^9, 
   3.4179230844879036`*^9}, {3.417923115911904*^9, 3.417923205392904*^9}, {
   3.417923237429904*^9, 3.4179232617779036`*^9}, {3.4179877572864914`*^9, 
   3.417987770700492*^9}, {3.4179913754724913`*^9, 3.4179915169554915`*^9}, {
   3.4183338659964123`*^9, 3.4183339006493416`*^9}, {3.4183339443330765`*^9, 
   3.4183341540880194`*^9}, {3.4183342605072985`*^9, 3.418334311790553*^9}, {
   3.4183344456833267`*^9, 3.418334447289648*^9}, {3.4183344876257133`*^9, 
   3.41833458642947*^9}, {3.4183383939995985`*^9, 3.4183384127994785`*^9}, {
   3.4190340686544914`*^9, 3.4190340823454914`*^9}, {3.419034147007491*^9, 
   3.419034479037491*^9}, {3.419144430067099*^9, 3.419144519155099*^9}, {
   3.497283120949657*^9, 3.497283131436221*^9}, {3.519743376612039*^9, 
   3.5197434347362223`*^9}, {3.520003509201342*^9, 3.520003510517764*^9}, 
   3.520003709658504*^9}],

Cell[TextData[{
 "This problem is solved by finding the leading eigenvector of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["N", 
     RowBox[{"-", "1"}]], "M"}], TraditionalForm]], "Math"],
 " and returning the multiplier ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "Math"],
 " for subsequent projection. We also compute the Mahalonobis bias ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     RowBox[{"\[Beta]", "=", 
      RowBox[{"(", 
       SubscriptBox["\[Mu]", 
        RowBox[{"+", "1"}]]}]}],
     TraditionalForm], 
    FormBox[
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[Sigma]", 
         RowBox[{"-", "1"}]], "-", 
        RowBox[{
         SubscriptBox["\[Mu]", 
          RowBox[{"-", "1"}]], 
         SubscriptBox["\[Sigma]", 
          RowBox[{"+", "1"}]]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Sigma]", 
         RowBox[{"+", "1"}]], "+", 
        SubscriptBox["\[Sigma]", 
         RowBox[{"-", "1"}]]}], ")"}]}],
     TraditionalForm]}], TraditionalForm]], "Math"],
 " that allows subsequent classification of a data point ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "Math"],
 " through computation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Alpha]", ".", "x"}], "-", "\[Beta]"}], TraditionalForm]], 
  "Math"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Mu]", 
     RowBox[{"-", "1"}]], ">", 
    SubscriptBox["\[Mu]", 
     RowBox[{"+", "1"}]]}], TraditionalForm]], "Math"],
 ", the signs of ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "Math"],
 " and ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "Math"],
 " are switched so that the correct subsequent classification sign (positive \
or negative) is ensured."
}], "Text",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.417921307955904*^9, 3.4179218129809036`*^9}, {
   3.4179219910779037`*^9, 3.417921995563904*^9}, {3.417922035615904*^9, 
   3.4179222344499035`*^9}, {3.4179223125189037`*^9, 
   3.4179223344239035`*^9}, {3.4179223677689037`*^9, 3.417922528713904*^9}, {
   3.417922770135904*^9, 3.417922905392904*^9}, {3.4179229756249037`*^9, 
   3.4179229966599035`*^9}, {3.4179230359799037`*^9, 
   3.4179230844879036`*^9}, {3.417923115911904*^9, 3.417923205392904*^9}, {
   3.417923237429904*^9, 3.4179232617779036`*^9}, {3.4179877572864914`*^9, 
   3.417987770700492*^9}, {3.4179913754724913`*^9, 3.4179915169554915`*^9}, {
   3.4183338659964123`*^9, 3.4183339006493416`*^9}, {3.4183339443330765`*^9, 
   3.4183341540880194`*^9}, {3.4183342605072985`*^9, 3.418334311790553*^9}, {
   3.4183344456833267`*^9, 3.418334447289648*^9}, {3.4183344876257133`*^9, 
   3.41833458642947*^9}, {3.4183383939995985`*^9, 3.4183384127994785`*^9}, {
   3.4190340686544914`*^9, 3.4190340823454914`*^9}, {3.419034147007491*^9, 
   3.419034479037491*^9}, {3.419144430067099*^9, 3.419144519155099*^9}, {
   3.497283120949657*^9, 3.497283123429696*^9}, {3.4972831850055656`*^9, 
   3.497283398852125*^9}, {3.497283430430003*^9, 3.497283526990365*^9}, {
   3.497283566390944*^9, 3.497283580959113*^9}, {3.50532188021975*^9, 
   3.505321911922875*^9}, {3.5189838742230053`*^9, 3.5189838765718603`*^9}, {
   3.5189890485064096`*^9, 3.5189890497754593`*^9}, {3.518989081351109*^9, 
   3.518989102297011*^9}, 3.5189892297581787`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TrainKFD", "[", 
   RowBox[{"K_", ",", "X_", ",", "y_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "L", ",", "X1", ",", "X2", ",", "L1", ",", "L2", ",", "M1", ",", "M2", 
      ",", "MT", ",", "K1", ",", "K2", ",", "I1", ",", "I2", ",", "U1", ",", 
      "U2", ",", "NB", ",", "muI", ",", "A", ",", "\[Alpha]", ",", "Pf", ",", 
      "P1", ",", "P2", ",", "\[Beta]", ",", "min1", ",", "max2"}], "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"L", "=", 
      RowBox[{"Length", "[", "X", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"X1", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"L1", "=", 
      RowBox[{"Length", "[", "X1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"L2", "=", 
      RowBox[{"Length", "[", "X2", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"M1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"K", "[", 
              RowBox[{
               RowBox[{"X", "[", 
                RowBox[{"[", "j", "]"}], "]"}], ",", "#"}], "]"}], "&"}], ",",
             "X1"}], "]"}], "]"}], "/", "L1"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "L"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"M2", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"K", "[", 
              RowBox[{
               RowBox[{"X", "[", 
                RowBox[{"[", "j", "]"}], "]"}], ",", "#"}], "]"}], "&"}], ",",
             "X2"}], "]"}], "]"}], "/", "L1"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "L"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MT", "=", 
      RowBox[{"Outer", "[", 
       RowBox[{"Times", ",", 
        RowBox[{"M1", "-", "M2"}], ",", 
        RowBox[{"M1", "-", "M2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"K1", "=", 
      RowBox[{"Outer", "[", 
       RowBox[{"K", ",", "X", ",", "X1", ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"K2", "=", 
      RowBox[{"Outer", "[", 
       RowBox[{"K", ",", "X", ",", "X2", ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"I1", "=", 
      RowBox[{"IdentityMatrix", "[", "L1", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"I2", "=", 
      RowBox[{"IdentityMatrix", "[", "L2", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"U1", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "L1"}], ")"}], 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", "L1", "}"}]}], "]"}], ",", 
         RowBox[{"{", "L1", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"U2", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "L2"}], ")"}], 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", "L2", "}"}]}], "]"}], ",", 
         RowBox[{"{", "L2", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"NB", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"K1", ".", 
         RowBox[{"(", 
          RowBox[{"I1", "-", "U1"}], ")"}], ".", 
         RowBox[{"Transpose", "[", "K1", "]"}]}], ")"}], "+", 
       RowBox[{"(", 
        RowBox[{"K2", ".", 
         RowBox[{"(", 
          RowBox[{"I2", "-", "U2"}], ")"}], ".", 
         RowBox[{"Transpose", "[", "K2", "]"}]}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"muI", "=", 
      RowBox[{"L", " ", 
       RowBox[{"IdentityMatrix", "[", "L", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"A", "=", 
      RowBox[{
       RowBox[{"Inverse", "[", 
        RowBox[{"NB", " ", "+", " ", "muI"}], "]"}], " ", ".", " ", "MT"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "=", 
      RowBox[{"First", "[", 
       RowBox[{"Eigenvectors", "[", 
        RowBox[{"A", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Pf", "=", 
      RowBox[{
       RowBox[{"ProjectKFD", "[", 
        RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "0", ",", "#"}], "]"}], 
       "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P1", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P2", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Beta]", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Mean", "[", "P1", "]"}], 
          RowBox[{"StandardDeviation", "[", "P2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"Mean", "[", "P2", "]"}], 
          RowBox[{"StandardDeviation", "[", "P1", "]"}]}]}], ")"}], "/", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"StandardDeviation", "[", "P2", "]"}], "+", 
         RowBox[{"StandardDeviation", "[", "P1", "]"}]}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Mean", "[", "P2", "]"}], ">", 
        RowBox[{"Mean", "[", "P1", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"P1", "=", 
         RowBox[{"-", "P1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"P2", "=", 
         RowBox[{"-", "P2"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], "=", 
         RowBox[{"-", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}]}]}]}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"max2", "=", 
      RowBox[{"Max", "[", "P2", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"min1", "=", 
      RowBox[{"Min", "[", "P1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"max2", "<", "min1"}], ",", 
       RowBox[{"\[Beta]", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"max2", "+", "min1"}], ")"}], "/", "2"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4179876780604916`*^9, 3.4179876835764914`*^9}, {
   3.417987787596492*^9, 3.417987817325492*^9}, {3.4179879185544915`*^9, 
   3.417987922603492*^9}, {3.4179880287134914`*^9, 3.417988065582492*^9}, {
   3.4179881667914915`*^9, 3.4179881980954914`*^9}, 3.4179883062154913`*^9, {
   3.4179883422934914`*^9, 3.4179884082984915`*^9}, {3.4179888216194916`*^9, 
   3.4179890866594915`*^9}, 3.4179891624744916`*^9, {3.4179897302764916`*^9, 
   3.4179897787154913`*^9}, {3.4179898095914917`*^9, 3.417989814181492*^9}, {
   3.4179901032124915`*^9, 3.4179901053494916`*^9}, {3.4179902714544916`*^9, 
   3.4179903032954917`*^9}, {3.4179907002684917`*^9, 3.417990778589492*^9}, {
   3.417990850292492*^9, 3.4179910026774917`*^9}, {3.4179911266514916`*^9, 
   3.4179911935414915`*^9}, {3.417993141989092*^9, 3.4179931490270915`*^9}, {
   3.4179931942890916`*^9, 3.4179932633180914`*^9}, {3.4179934238610916`*^9, 
   3.4179935067110915`*^9}, 3.4179935548100915`*^9, {3.4179936946200914`*^9, 
   3.4179936981040916`*^9}, {3.4179938647050915`*^9, 
   3.4179938950530915`*^9}, {3.4179943123800917`*^9, 
   3.4179943203700914`*^9}, {3.4179943798540916`*^9, 
   3.4179943950730915`*^9}, {3.4179944626150913`*^9, 
   3.4179945721750917`*^9}, {3.4179948373930917`*^9, 3.4179948481060915`*^9}, 
   3.4179950105400915`*^9, {3.4179952165310917`*^9, 3.4179953075870914`*^9}, {
   3.4179963002616916`*^9, 3.4179963242126913`*^9}, {3.4179963575806913`*^9, 
   3.4179963939646916`*^9}, {3.4179978669786916`*^9, 3.417997896060692*^9}, {
   3.4179979446146917`*^9, 3.4179980046476917`*^9}, {3.4179982488726916`*^9, 
   3.4179982572106915`*^9}, {3.4180750010527186`*^9, 3.418075116344719*^9}, {
   3.4180829605201187`*^9, 3.4180829773191185`*^9}, {3.41833481982514*^9, 
   3.4183348365504847`*^9}, {3.418334878975968*^9, 3.4183348804512625`*^9}, {
   3.418847698385706*^9, 3.4188477063727055`*^9}, {3.4188488492647057`*^9, 
   3.418848893765706*^9}, {3.418849409001706*^9, 3.418849453308706*^9}, {
   3.4188495145667057`*^9, 3.418849594058706*^9}, {3.4188521471317058`*^9, 
   3.4188521819017057`*^9}, {3.4188524567247057`*^9, 3.418852462550706*^9}, {
   3.4188548551977057`*^9, 3.4188549440727057`*^9}, {3.4188810501207075`*^9, 
   3.4188810726527076`*^9}, {3.419033898341491*^9, 3.419033906354491*^9}, {
   3.419033939976491*^9, 3.419034017012491*^9}, {3.4191443323000994`*^9, 
   3.419144411103099*^9}, {3.4191446378340993`*^9, 3.419144642063099*^9}, {
   3.419144681553099*^9, 3.419144850507099*^9}, {3.4197305237966003`*^9, 
   3.4197305275256*^9}, {3.519530775057757*^9, 3.519530918796891*^9}, {
   3.519743473297743*^9, 3.519743475483712*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computing the Classification Bias", "Subsection",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.417921273273904*^9, 3.417921292292904*^9}, {
  3.418338483652563*^9, 3.418338512158413*^9}}],

Cell[TextData[{
 "Here we also return a score, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "s", "\[LessEqual]", "1"}], TraditionalForm]],
   "Math"],
 ", which is the accuracy with which the Fisher discriminant classifies ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "Math"],
 "."
}], "Text",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.417921307955904*^9, 3.4179218129809036`*^9}, {
   3.4179219910779037`*^9, 3.417921995563904*^9}, {3.417922035615904*^9, 
   3.4179222344499035`*^9}, {3.4179223125189037`*^9, 
   3.4179223344239035`*^9}, {3.4179223677689037`*^9, 3.417922528713904*^9}, {
   3.417922770135904*^9, 3.417922905392904*^9}, {3.4179229756249037`*^9, 
   3.4179229966599035`*^9}, {3.4179230359799037`*^9, 
   3.4179230844879036`*^9}, {3.417923115911904*^9, 3.417923205392904*^9}, {
   3.417923237429904*^9, 3.4179232617779036`*^9}, {3.4179877572864914`*^9, 
   3.417987770700492*^9}, {3.4179913754724913`*^9, 3.4179915169554915`*^9}, {
   3.4183338659964123`*^9, 3.4183339006493416`*^9}, {3.4183339443330765`*^9, 
   3.4183341540880194`*^9}, {3.4183342605072985`*^9, 3.418334311790553*^9}, {
   3.4183344456833267`*^9, 3.418334447289648*^9}, {3.4183344876257133`*^9, 
   3.41833458642947*^9}, {3.418335263893936*^9, 3.418335309765108*^9}, {
   3.418337256712881*^9, 3.4183372582280326`*^9}, {3.4183464268231735`*^9, 
   3.4183464984503355`*^9}, {3.4183470736848536`*^9, 3.418347215545038*^9}, {
   3.4188819180757074`*^9, 3.4188820365867076`*^9}, 3.4190340534654913`*^9, {
   3.497283596845208*^9, 3.4972836201170883`*^9}, 3.505321928641625*^9, {
   3.505321965735375*^9, 3.505321984954125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ScoreKFD", "[", 
   RowBox[{"K_", ",", "X_", ",", "y_", ",", "\[Alpha]_", ",", "\[Beta]_"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"X1", ",", "X2", ",", "Pf", ",", "P1", ",", "P2", ",", "s"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"X1", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Pf", "=", 
      RowBox[{
       RowBox[{"ProjectKFD", "[", 
        RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "\[Beta]", ",", "#"}], 
        "]"}], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P1", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P2", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Select", "[", 
            RowBox[{"P1", ",", 
             RowBox[{
              RowBox[{"#", " ", ">", " ", "0"}], " ", "&"}]}], "]"}], "]"}], 
          "+", 
          RowBox[{"Length", "[", 
           RowBox[{"Select", "[", 
            RowBox[{"P2", ",", 
             RowBox[{
              RowBox[{"#", "<", " ", "0"}], " ", "&"}]}], "]"}], "]"}]}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Length", "[", "P1", "]"}], "+", 
          RowBox[{"Length", "[", "P2", "]"}]}], ")"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "s"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.418335015254218*^9, 3.4183350219185505`*^9}, {
   3.4183350541009855`*^9, 3.418335058347835*^9}, {3.418335106776519*^9, 
   3.4183351455132647`*^9}, {3.418345578458346*^9, 3.4183455793134313`*^9}, {
   3.418346235497043*^9, 3.4183462781353064`*^9}, {3.4183463159810905`*^9, 
   3.418346408707362*^9}, {3.4183465273222227`*^9, 3.4183465280933*^9}, {
   3.4188549770597057`*^9, 3.4188550161257057`*^9}, {3.4188805649477077`*^9, 
   3.418880566411708*^9}, {3.4188807228937073`*^9, 3.4188807866277075`*^9}, {
   3.4188808466297073`*^9, 3.4188808631867075`*^9}, {3.4188812600637074`*^9, 
   3.4188812831777077`*^9}, {3.418881888359708*^9, 3.4188819009367075`*^9}, {
   3.418882220944708*^9, 3.4188822259477077`*^9}, {3.419034493375491*^9, 
   3.419034533138491*^9}, {3.4190345747794914`*^9, 3.419034634756491*^9}, {
   3.519530988232432*^9, 3.519531012576601*^9}, 3.519743509094927*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Reduced Fisher Discriminant", "Subsection",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.417921273273904*^9, 3.417921292292904*^9}, {
  3.418338483652563*^9, 3.418338512158413*^9}, {3.4188803686057076`*^9, 
  3.4188803854077077`*^9}}],

Cell[TextData[{
 "Here we select data from ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "Math"],
 " close to the discrimination boundary to create a reduced ",
 "dataset",
 " that must still be trained to discriminate."
}], "Text",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.417921307955904*^9, 3.4179218129809036`*^9}, {
   3.4179219910779037`*^9, 3.417921995563904*^9}, {3.417922035615904*^9, 
   3.4179222344499035`*^9}, {3.4179223125189037`*^9, 
   3.4179223344239035`*^9}, {3.4179223677689037`*^9, 3.417922528713904*^9}, {
   3.417922770135904*^9, 3.417922905392904*^9}, {3.4179229756249037`*^9, 
   3.4179229966599035`*^9}, {3.4179230359799037`*^9, 
   3.4179230844879036`*^9}, {3.417923115911904*^9, 3.417923205392904*^9}, {
   3.417923237429904*^9, 3.4179232617779036`*^9}, {3.4179877572864914`*^9, 
   3.417987770700492*^9}, {3.4179913754724913`*^9, 3.4179915169554915`*^9}, {
   3.4183338659964123`*^9, 3.4183339006493416`*^9}, {3.4183339443330765`*^9, 
   3.4183341540880194`*^9}, {3.4183342605072985`*^9, 3.418334311790553*^9}, {
   3.4183344456833267`*^9, 3.418334447289648*^9}, {3.4183344876257133`*^9, 
   3.41833458642947*^9}, {3.418335263893936*^9, 3.418335309765108*^9}, {
   3.418337256712881*^9, 3.4183372582280326`*^9}, {3.4183464268231735`*^9, 
   3.4183464984503355`*^9}, {3.4183470736848536`*^9, 3.418347215545038*^9}, 
   3.4188803402987075`*^9, {3.4188803989977074`*^9, 3.4188804646127076`*^9}, 
   3.497283650879095*^9, {3.505322002297875*^9, 3.505322004391625*^9}, 
   3.518989318864249*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReducedKFD", "[", 
   RowBox[{"K_", ",", "X_", ",", "y_", ",", "\[Alpha]_", ",", "\[Beta]_"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "X1", ",", "X2", ",", "Pf", ",", "P1", ",", "P2", ",", "\[Mu]1", ",", 
      "\[Mu]2", ",", "\[Sigma]1", ",", "\[Sigma]2", ",", "X1r", ",", "X2r"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"X1", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Pf", "=", 
      RowBox[{
       RowBox[{"ProjectKFD", "[", 
        RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "\[Beta]", ",", "#"}], 
        "]"}], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P1", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P2", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Mu]1", "=", 
      RowBox[{"Mean", "[", "P1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Mu]2", "=", 
      RowBox[{"Mean", "[", "P2", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Sigma]1", "=", 
      RowBox[{"StandardDeviation", "[", "P1", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Sigma]2", "=", 
      RowBox[{"StandardDeviation", "[", "P2", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X1r", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"X1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProjectKFD", "[", 
           RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "\[Beta]", ",", "#"}],
            "]"}], "<", 
          RowBox[{"\[Mu]1", "-", 
           RowBox[{"\[Sigma]1", "/", "2"}]}]}], "&"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2r", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"X2", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Mu]2", "+", 
           RowBox[{"\[Sigma]2", "/", "2"}]}], "<", " ", 
          RowBox[{"ProjectKFD", "[", 
           RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "\[Beta]", ",", "#"}],
            "]"}]}], "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{"X1r", ",", "X2r"}], "]"}], ",", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "X1r", "]"}], "}"}]}], "]"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "X2r", "]"}], "}"}]}], "]"}]}], "]"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}], " "}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.418755839494302*^9, 3.4187558484303017`*^9}, {
   3.418755913428302*^9, 3.4187559159383016`*^9}, {3.4187559666543016`*^9, 
   3.4187561488793015`*^9}, {3.4187561991393013`*^9, 
   3.4187565642403016`*^9}, {3.4187570634453015`*^9, 
   3.4187570746153016`*^9}, {3.4187571537763014`*^9, 
   3.4187572378713017`*^9}, {3.4187575431963015`*^9, 3.418757585711302*^9}, {
   3.4187576244953012`*^9, 3.4187576983063016`*^9}, {3.4187577599693017`*^9, 
   3.4187577799303017`*^9}, {3.4187586624053016`*^9, 
   3.4187586710553017`*^9}, {3.4187599888043013`*^9, 
   3.4187599967923017`*^9}, {3.418855035953706*^9, 3.418855167445706*^9}, {
   3.4188587354607058`*^9, 3.4188587439767056`*^9}, {3.4188589561747055`*^9, 
   3.418858963643706*^9}, {3.419034675245491*^9, 3.419034695865491*^9}, {
   3.419035538315491*^9, 3.4190355588264914`*^9}, 3.519064460781045*^9, {
   3.519531037725328*^9, 3.519531080781884*^9}, 3.5197435271796503`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solution Properties", "Section",
 InitializationGroup->True,
 CellChangeTimes->{3.5189893342956057`*^9}],

Cell[CellGroupData[{

Cell["Various Statistics", "Subsection",
 InitializationGroup->True,
 CellChangeTimes->{3.518989338244409*^9}],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"K", "(", 
     RowBox[{
      SubscriptBox["x", "i"], ",", 
      SubscriptBox["x", "j"]}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[Phi]", "(", 
      SubscriptBox["x", "i"], ")"}], ".", 
     RowBox[{"\[Phi]", "(", 
      SubscriptBox["x", "j"], ")"}]}]}], TraditionalForm]], "Math"],
 ", we can define the distance metric in ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "Math"],
 "-space using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FormBox["K",
      TraditionalForm], 
     RowBox[{
      SuperscriptBox["d", "2"], "(", 
      RowBox[{"x", ",", "y"}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"||", 
      RowBox[{
       RowBox[{"\[Phi]", "(", "x", ")"}], "-", 
       RowBox[{"\[Phi]", "(", "y", ")"}]}], 
      SuperscriptBox["||", "2"]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Phi]", "(", "x", ")"}], "-", 
         RowBox[{"\[Phi]", "(", "y", ")"}]}], ")"}], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Phi]", "(", "x", ")"}], "-", 
         RowBox[{"\[Phi]", "(", "y", ")"}]}], ")"}]}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"\[Phi]", "(", "x", ")"}], ".", 
         RowBox[{"\[Phi]", "(", "x", ")"}]}], "+", 
        RowBox[{
         RowBox[{"\[Phi]", "(", "y", ")"}], ".", 
         RowBox[{"\[Phi]", "(", "y", ")"}]}], "-", 
        RowBox[{"2", 
         RowBox[{"\[Phi]", "(", "x", ")"}], 
         RowBox[{"\[Phi]", "(", "y", ")"}]}]}], "=", 
       RowBox[{
        RowBox[{"K", "(", 
         RowBox[{"x", ",", "x"}], ")"}], "+", 
        RowBox[{"K", "(", 
         RowBox[{"y", ",", "y"}], ")"}], "-", 
        RowBox[{"2", 
         RowBox[{"K", "(", 
          RowBox[{"x", ",", "y"}], ")"}]}]}]}]}]}]}], TraditionalForm]], 
  "Math"],
 ". "
}], "Text",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4180751758817186`*^9, 3.4180752577277184`*^9}, {
   3.4187610509773016`*^9, 3.4187611543253016`*^9}, {3.4194885441532*^9, 
   3.4194885516921997`*^9}, {3.4972837250086813`*^9, 3.497283781169917*^9}, {
   3.505322168376*^9, 3.505322393610375*^9}, 3.505322436391625*^9, 
   3.518983889804906*^9, 3.519743540271996*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"KernelDistance", "[", 
   RowBox[{"x_", ",", "y_", ",", "K_"}], "]"}], ":=", 
  SqrtBox[
   RowBox[{
    RowBox[{"K", "[", 
     RowBox[{"x", ",", "x"}], "]"}], "+", 
    RowBox[{"K", "[", 
     RowBox[{"y", ",", "y"}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"K", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}]]}]], "Input",
 InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["KFD Plots", "Section",
 InitializationGroup->True,
 CellChangeTimes->{{3.4179923638188915`*^9, 3.4179923808988914`*^9}, 
   3.518989344656227*^9}],

Cell[CellGroupData[{

Cell["For Classification", "Subsection",
 InitializationGroup->True,
 CellChangeTimes->{3.518989349131364*^9}],

Cell[TextData[{
 "This only works for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["R",
     FontWeight->"Bold"], "2"], TraditionalForm]], "Math"],
 ". It uses ",
 Cell[BoxData[
  RowBox[{"ListPlot", "[", "]"}]], "MCode"],
 " to produce training and testing data plots in a graphics grid."
}], "Text",
 InitializationGroup->True,
 CellChangeTimes->{{3.4180751758817186`*^9, 3.4180752577277184`*^9}, {
  3.4187610509773016`*^9, 3.4187611543253016`*^9}, {3.4194885441532*^9, 
  3.4194885516921997`*^9}, {3.419547681632695*^9, 3.419547736518695*^9}, {
  3.4972836776073227`*^9, 3.497283704512018*^9}, {3.51898937267025*^9, 
  3.5189893874686403`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DataPlotKFD", "[", 
   RowBox[{"X_", ",", "y_", ",", "Xt_", ",", "yt_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "Xa", ",", "Xp", ",", "Xn", ",", "Xpt", ",", "Xnt", ",", "plotRange", 
      ",", "gTrain", ",", "gTest"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Xa", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"X", ",", "Xt"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"plotRange", " ", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Min", "[", 
           RowBox[{"Xa", "\[LeftDoubleBracket]", 
            RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{"Xa", "\[LeftDoubleBracket]", 
            RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Min", "[", 
           RowBox[{"Xa", "\[LeftDoubleBracket]", 
            RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}], ",", 
          RowBox[{"Max", "[", 
           RowBox[{"Xa", "\[LeftDoubleBracket]", 
            RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}]}], 
         "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Xp", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Xn", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Xpt", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Xnt", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"gTrain", "=", 
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Xp", ",", "Xn"}], "}"}], ",", 
        RowBox[{"PlotRange", "->", "All"}], ",", 
        RowBox[{"AspectRatio", "->", "1"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}], ",", 
        RowBox[{"PlotLabel", "->", "\"\<Training Data\>\""}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"gTest", "=", 
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Xpt", ",", "Xnt"}], "}"}], ",", 
        RowBox[{"PlotRange", "->", "All"}], ",", 
        RowBox[{"AspectRatio", "->", "1"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "plotRange"}], ",", 
        RowBox[{"PlotLabel", "->", "\"\<Testing Data\>\""}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"gTrain", ",", "gTest"}], "}"}], "}"}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationGroup->True,
 CellChangeTimes->{{3.419547253231695*^9, 3.4195472900396953`*^9}, {
  3.419547322580695*^9, 3.419547331726695*^9}, {3.4195473780906954`*^9, 
  3.4195474121646953`*^9}, {3.419547453324695*^9, 3.4195474682236953`*^9}, {
  3.4195475116186953`*^9, 3.4195476414936953`*^9}, {3.4195480062896953`*^9, 
  3.419548023761695*^9}, {3.51953109829338*^9, 3.519531117813818*^9}}],

Cell[TextData[{
 "This only works for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["R",
     FontWeight->"Bold"], "2"], TraditionalForm]], "Math"],
 ". It uses ",
 Cell[BoxData[
  RowBox[{"ContourPlot", "[", "]"}]], "MCode"],
 " to plot the decision boundary ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      FormBox[
       SubscriptBox["\[Sum]", "i"],
       TraditionalForm], 
      RowBox[{
       SubscriptBox["\[Alpha]", "i"], 
       RowBox[{"K", "(", 
        RowBox[{
         SubscriptBox["x", 
          RowBox[{"i", ","}]], "x"}], ")"}]}]}], "-", "\[Beta]"}], "=", "0"}],
    TraditionalForm]], "Math"],
 ". Class ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "Math"],
 " is shown as green dots, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "Math"],
 " as blue dots."
}], "Text",
 InitializationGroup->True,
 CellChangeTimes->{{3.4180751758817186`*^9, 3.4180752577277184`*^9}, {
  3.4187610509773016`*^9, 3.4187611543253016`*^9}, {3.4194885441532*^9, 
  3.4194885516921997`*^9}, {3.4972837250086813`*^9, 3.497283781169917*^9}, {
  3.518989399470871*^9, 3.518989400481781*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContourPlotKFD", "[", 
   RowBox[{
   "K_", ",", "X_", ",", "y_", ",", "\[Alpha]_", ",", "\[Beta]_", ",", "Xt_", 
    ",", "yt_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "Xa", ",", "X1", ",", "X2", ",", "X1t", ",", "X2t", ",", "Pf", ",", 
      "gTrain", ",", "gTest"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Xa", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"X", ",", "Xt"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"X1", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"X1t", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2t", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Pf", "=", 
      RowBox[{
       RowBox[{"ProjectKFD", "[", 
        RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "\[Beta]", ",", "#"}], 
        "]"}], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"gTrain", "=", 
      RowBox[{"Show", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Pf", "[", 
            RowBox[{"{", 
             RowBox[{"x1", ",", "x2"}], "}"}], "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{"{", 
           RowBox[{"x1", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}], 
            ",", 
            RowBox[{"Max", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}], 
            ",", 
            RowBox[{"Max", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}]}], 
           "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ListPlot", "[", 
         RowBox[{"X1", ",", "\[IndentingNewLine]", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Hue", "[", "0.7", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"ListPlot", "[", 
         RowBox[{"X2", ",", "\[IndentingNewLine]", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Hue", "[", "0.85", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}], 
        " ", ",", 
        RowBox[{"PlotLabel", "\[Rule]", "\"\<Training Set\>\""}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"gTest", "=", 
      RowBox[{"Show", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Pf", "[", 
            RowBox[{"{", 
             RowBox[{"x1", ",", "x2"}], "}"}], "]"}], "\[Equal]", " ", "0"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"x1", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}], 
            ",", 
            RowBox[{"Max", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x2", ",", 
            RowBox[{"Min", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}], 
            ",", 
            RowBox[{"Max", "[", 
             RowBox[{"Xa", "\[LeftDoubleBracket]", 
              RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}]}], 
           "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ListPlot", "[", 
         RowBox[{"X1t", ",", "\[IndentingNewLine]", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Hue", "[", "0.7", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"ListPlot", "[", 
         RowBox[{"X2t", ",", "\[IndentingNewLine]", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Hue", "[", "0.85", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}], 
        ",", 
        RowBox[{"PlotLabel", "\[Rule]", "\"\<Testing Set\>\""}]}], " ", 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"gTrain", ",", "gTest"}], "}"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.418001628699692*^9, 3.4180016605686913`*^9}, {
   3.4180017033906918`*^9, 3.4180017057066917`*^9}, {3.4180018821446915`*^9, 
   3.418001883166692*^9}, {3.4180019761106915`*^9, 3.4180020328716917`*^9}, {
   3.4180020809936914`*^9, 3.4180022590506916`*^9}, {3.4180025706496916`*^9, 
   3.418002807560692*^9}, {3.4180028524996915`*^9, 3.4180028957096915`*^9}, {
   3.418003064704692*^9, 3.4180031923266916`*^9}, {3.4180032645666914`*^9, 
   3.4180033377806916`*^9}, {3.418003460442692*^9, 3.4180034714386916`*^9}, {
   3.4180035574456916`*^9, 3.418003634501692*^9}, {3.4180036986446915`*^9, 
   3.4180037047686915`*^9}, {3.4180040261626916`*^9, 
   3.4180040323786917`*^9}, {3.4180041238946915`*^9, 
   3.4180041996496916`*^9}, {3.4180044707026916`*^9, 3.418004475987692*^9}, {
   3.4180046987996917`*^9, 3.418004714303692*^9}, {3.4180052710376916`*^9, 
   3.4180052770956917`*^9}, {3.4180055849906917`*^9, 
   3.4180056300686913`*^9}, {3.418005712907692*^9, 3.4180057191616917`*^9}, {
   3.4180057513376913`*^9, 3.4180057522806916`*^9}, {3.418005785928692*^9, 
   3.4180057872756915`*^9}, {3.4180058562656918`*^9, 
   3.4180058716116915`*^9}, {3.4180059514326916`*^9, 
   3.4180060223936915`*^9}, {3.4180061022616916`*^9, 
   3.4180061143056917`*^9}, {3.418006147935692*^9, 3.4180061545946913`*^9}, {
   3.4180062545566916`*^9, 3.4180062703406916`*^9}, {3.4180064799966917`*^9, 
   3.4180065084906917`*^9}, {3.4180065461396914`*^9, 3.418006557190692*^9}, {
   3.4180066582036915`*^9, 3.4180066615266914`*^9}, {3.4180752960087185`*^9, 
   3.4180753060037184`*^9}, {3.4180754332357187`*^9, 
   3.4180754718487186`*^9}, {3.418083065004119*^9, 3.4180830657221184`*^9}, {
   3.4180855185291185`*^9, 3.4180855355071187`*^9}, {3.4182045453240924`*^9, 
   3.418204547636092*^9}, {3.4183355716363907`*^9, 3.418335665954821*^9}, {
   3.418335711999425*^9, 3.4183357213133564`*^9}, {3.418336474861704*^9, 
   3.418336483263544*^9}, {3.418336904314645*^9, 3.418336928846098*^9}, {
   3.418347260496533*^9, 3.418347291860669*^9}, {3.41834803494597*^9, 
   3.418348037917267*^9}, {3.4187612371743016`*^9, 3.4187612715613017`*^9}, {
   3.4187613414253016`*^9, 3.4187614091873016`*^9}, {3.4187616131533017`*^9, 
   3.4187616143373013`*^9}, {3.4187616838383017`*^9, 3.418761764093302*^9}, {
   3.4187619132083015`*^9, 3.4187619188443017`*^9}, {3.418855195748706*^9, 
   3.4188552173687057`*^9}, {3.4190347123204913`*^9, 3.419034719605491*^9}, {
   3.4194882138842*^9, 3.4194882154821997`*^9}, {3.4194883911422*^9, 
   3.4194883950842*^9}, {3.4195487669706955`*^9, 3.4195488073686953`*^9}, {
   3.4195488553156953`*^9, 3.419548921745695*^9}, {3.4195491708946953`*^9, 
   3.419549220863695*^9}, {3.4197448216616316`*^9, 3.4197448247786317`*^9}, {
   3.4197449068716316`*^9, 3.4197449075276318`*^9}, {3.4197450413716316`*^9, 
   3.419745042631632*^9}, {3.419746949443632*^9, 3.419746958321632*^9}, {
   3.519531165420329*^9, 3.5195312025089293`*^9}, 3.5195313361341543`*^9}],

Cell[TextData[{
 "This only works for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["R",
     FontWeight->"Bold"], "3"], TraditionalForm]], "Math"],
 ". It uses ",
 Cell[BoxData[
  RowBox[{"ContourPlot3D", "[", "]"}]], "MCode"],
 " to plot the decision boundary ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      FormBox[
       SubscriptBox["\[Sum]", "i"],
       TraditionalForm], 
      RowBox[{
       SubscriptBox["\[Alpha]", "i"], 
       RowBox[{"K", "(", 
        RowBox[{
         SubscriptBox["x", 
          RowBox[{"i", ","}]], "x"}], ")"}]}]}], "-", "\[Beta]"}], "=", "0"}],
    TraditionalForm]], "Math"],
 ". Class ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "Math"],
 " is shown as green dots, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "Math"],
 " as blue dots."
}], "Text",
 InitializationGroup->True,
 CellChangeTimes->{{3.4180751758817186`*^9, 3.4180752577277184`*^9}, {
  3.4187610509773016`*^9, 3.4187611543253016`*^9}, {3.4194884731022*^9, 
  3.4194884819312*^9}, {3.4194885237002*^9, 3.4194885300882*^9}, {
  3.4972837923542147`*^9, 3.497283853867663*^9}, {3.518989419683125*^9, 
  3.518989420806225*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContourPlot3DKFD", "[", 
   RowBox[{
   "K_", ",", "X_", ",", "y_", ",", "\[Alpha]_", ",", "\[Beta]_", ",", "Xt_", 
    ",", "yt_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Xa", ",", "X1", ",", "X2", ",", "X1t", ",", "X2t", ",", "Pf"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Xa", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"X", ",", "Xt"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"X1", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"X1t", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2t", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Pf", "=", 
      RowBox[{
       RowBox[{"ProjectKFD", "[", 
        RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "\[Beta]", ",", "#"}], 
        "]"}], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ContourPlot3D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Pf", "[", 
           RowBox[{"{", 
            RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "]"}], "\[Equal]", 
          "0"}], ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", 
           RowBox[{"Min", "[", 
            RowBox[{"Xa", "\[LeftDoubleBracket]", 
             RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{"Xa", "\[LeftDoubleBracket]", 
             RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], "]"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x2", ",", 
           RowBox[{"Min", "[", 
            RowBox[{"Xa", "\[LeftDoubleBracket]", 
             RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{"Xa", "\[LeftDoubleBracket]", 
             RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], "]"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3", ",", 
           RowBox[{"Min", "[", 
            RowBox[{"Xa", "\[LeftDoubleBracket]", 
             RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}], "]"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{"Xa", "\[LeftDoubleBracket]", 
             RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}], "]"}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PerformanceGoal", "->", "\"\<Speed\>\""}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ListPointPlot3D", "[", 
        RowBox[{"X1t", ",", "\[IndentingNewLine]", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Hue", "[", "0.7", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"ListPointPlot3D", "[", 
        RowBox[{"X2t", ",", "\[IndentingNewLine]", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Hue", "[", "0.85", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}]}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.418001628699692*^9, 3.4180016605686913`*^9}, {
   3.4180017033906918`*^9, 3.4180017057066917`*^9}, {3.4180018821446915`*^9, 
   3.418001883166692*^9}, {3.4180019761106915`*^9, 3.4180020328716917`*^9}, {
   3.4180020809936914`*^9, 3.4180022590506916`*^9}, {3.4180025706496916`*^9, 
   3.418002807560692*^9}, {3.4180028524996915`*^9, 3.4180028957096915`*^9}, {
   3.418003064704692*^9, 3.4180031923266916`*^9}, {3.4180032645666914`*^9, 
   3.4180033377806916`*^9}, {3.418003460442692*^9, 3.4180034714386916`*^9}, {
   3.4180035574456916`*^9, 3.418003634501692*^9}, {3.4180036986446915`*^9, 
   3.4180037047686915`*^9}, {3.4180040261626916`*^9, 
   3.4180040323786917`*^9}, {3.4180041238946915`*^9, 
   3.4180041996496916`*^9}, {3.4180044707026916`*^9, 3.418004475987692*^9}, {
   3.4180046987996917`*^9, 3.418004714303692*^9}, {3.4180052710376916`*^9, 
   3.4180052770956917`*^9}, {3.4180055849906917`*^9, 
   3.4180056300686913`*^9}, {3.418005712907692*^9, 3.4180057191616917`*^9}, {
   3.4180057513376913`*^9, 3.4180057522806916`*^9}, {3.418005785928692*^9, 
   3.4180057872756915`*^9}, {3.4180058562656918`*^9, 
   3.4180058716116915`*^9}, {3.4180059514326916`*^9, 
   3.4180060223936915`*^9}, {3.4180061022616916`*^9, 
   3.4180061143056917`*^9}, {3.418006147935692*^9, 3.4180061545946913`*^9}, {
   3.4180062545566916`*^9, 3.4180062703406916`*^9}, {3.4180064799966917`*^9, 
   3.4180065084906917`*^9}, {3.4180065461396914`*^9, 3.418006557190692*^9}, {
   3.4180066582036915`*^9, 3.4180066615266914`*^9}, {3.4180752960087185`*^9, 
   3.4180753060037184`*^9}, {3.4180754332357187`*^9, 
   3.4180754718487186`*^9}, {3.418083065004119*^9, 3.4180830657221184`*^9}, {
   3.4180855185291185`*^9, 3.4180855355071187`*^9}, {3.4182039375620923`*^9, 
   3.4182039400690928`*^9}, {3.418204147478092*^9, 3.4182041558230925`*^9}, {
   3.4182041916790924`*^9, 3.418204236289092*^9}, {3.4183357485560803`*^9, 
   3.418335776582883*^9}, {3.418336493533571*^9, 3.418336507418959*^9}, {
   3.418347310995582*^9, 3.4183473347589583`*^9}, {3.4187994310179005`*^9, 
   3.4187994413259*^9}, {3.4187994834849005`*^9, 3.4187994843869*^9}, {
   3.4187995153159*^9, 3.4187995163369*^9}, {3.4187995481929*^9, 
   3.4187996440619*^9}, {3.4188071783307*^9, 3.4188071823407*^9}, {
   3.4188552772127056`*^9, 3.418855294847706*^9}, {3.4190347303504915`*^9, 
   3.4190347349234915`*^9}, {3.4194867092674*^9, 3.4194867135184*^9}, 
   3.4194867504974003`*^9, {3.4194879897132*^9, 3.4194879967672*^9}, {
   3.4194881391142*^9, 3.4194881408761997`*^9}, 3.4194883204161997`*^9, {
   3.4194884169952*^9, 3.4194884180132*^9}, {3.419745079428632*^9, 
   3.419745088207632*^9}, {3.4327021077664957`*^9, 3.432702116496496*^9}, {
   3.519531214049438*^9, 3.5195312227296267`*^9}, 3.519531331495599*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BarChartKFD", "[", 
   RowBox[{
   "K_", ",", "X_", ",", "y_", ",", "\[Alpha]_", ",", "\[Beta]_", ",", "Xt_", 
    ",", "yt_", ",", 
    RowBox[{"title_:", "\"\<KFD Classifier\>\""}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "X1", ",", "X2", ",", "X1t", ",", "X2t", ",", "Pf", ",", "P1", ",", "P2",
       ",", "P1t", ",", "P2t", ",", "PA", ",", "min", ",", "max", ",", 
      "sensitivity", ",", "specificity", ",", "accuracy", ",", "bins", ",", 
      "classBin", ",", "plotLabel", ",", "H1", ",", "H2", ",", "H1t", ",", 
      "H2t", ",", "newdata"}], "}"}], ",", 
    RowBox[{
     RowBox[{"X1", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"X", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"X1t", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"X2t", "=", 
      RowBox[{"Extract", "[", 
       RowBox[{"Xt", ",", 
        RowBox[{"Position", "[", 
         RowBox[{"yt", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Pf", "=", 
      RowBox[{
       RowBox[{"ProjectKFD", "[", 
        RowBox[{"K", ",", "X", ",", "\[Alpha]", ",", "\[Beta]", ",", "#"}], 
        "]"}], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P1t", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X1t"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"P2t", "=", 
      RowBox[{"Map", "[", 
       RowBox[{"Pf", ",", "X2t"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PA", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"P1t", ",", "P2t"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"min", ",", "max"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Min", "[", "PA", "]"}], ",", 
        RowBox[{"Max", "[", "PA", "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"sensitivity", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Select", "[", 
           RowBox[{"P1t", ",", 
            RowBox[{
             RowBox[{"#", ">", "0"}], "&"}]}], "]"}], "]"}], "/", 
         RowBox[{"Length", "[", "P1t", "]"}]}], ",", "2"}], "]"}]}], ";", 
     RowBox[{"specificity", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"Select", "[", 
           RowBox[{"P2t", ",", 
            RowBox[{
             RowBox[{"#", "<", "0"}], "&"}]}], "]"}], "]"}], "/", 
         RowBox[{"Length", "[", "P2t", "]"}]}], ",", "2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"accuracy", "=", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"Select", "[", 
             RowBox[{"P1t", ",", 
              RowBox[{
               RowBox[{"#", ">", "0"}], "&"}]}], "]"}], "]"}], "+", 
           RowBox[{"Length", "[", 
            RowBox[{"Select", "[", 
             RowBox[{"P2t", ",", 
              RowBox[{
               RowBox[{"#", "<", "0"}], "&"}]}], "]"}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Length", "[", "P1t", "]"}], "+", 
           RowBox[{"Length", "[", "P2t", "]"}]}], ")"}]}], ",", "2"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"bins", "=", "40"}], ";", "\[IndentingNewLine]", 
     RowBox[{"classBin", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{"1", "+", 
        RowBox[{"bins", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"0", "-", "min"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"max", "-", "min"}], ")"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"plotLabel", "=", 
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"title", ",", "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<features = \>\"", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"X", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<K\>\"", ",", "Italic"}], "]"}], ",", "\"\<(\>\"", 
             ",", 
             SubscriptBox[
              RowBox[{"Style", "[", 
               RowBox[{"\"\<x\>\"", ",", "Italic"}], "]"}], 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<i\>\"", ",", "Italic"}], "]"}]], ",", 
             "\"\<, \>\"", ",", " ", 
             SubscriptBox[
              RowBox[{"Style", "[", 
               RowBox[{"\"\<x\>\"", ",", "Italic"}], "]"}], 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<j\>\"", ",", "Italic"}], "]"}]], ",", 
             "\"\<) = \>\"", ",", 
             RowBox[{"StringReplace", "[", " ", 
              RowBox[{
               RowBox[{"ToString", "[", 
                RowBox[{"InputForm", "[", 
                 RowBox[{"K", "[", 
                  RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "]"}], "]"}], 
                "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"\"\<\\\"\>\"", "\[Rule]", "\"\<\>\""}], ",", 
                 RowBox[{
                 "\"\<x\>\"", "\[Rule]", 
                  "\"\<\!\(\*SubscriptBox[\(x\), \(i\)]\)\>\""}], ",", 
                 RowBox[{
                 "\"\<y\>\"", "\[Rule]", 
                  "\"\<\!\(\*SubscriptBox[\(x\), \(j\)]\)\>\""}]}], "}"}]}], 
              "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<training set: \>\"", ",", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<p\>\"", ",", "Italic"}], "]"}], ",", "\"\< = \>\"",
              ",", 
             RowBox[{"Length", "[", "X1", "]"}], ",", " ", "\"\<, \>\"", ",", 
             " ", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<n\>\"", ",", "Italic"}], "]"}], ",", "\"\< = \>\"",
              ",", 
             RowBox[{"Length", "[", "X2", "]"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<testing set: \>\"", ",", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<p\>\"", ",", "Italic"}], "]"}], ",", "\"\< = \>\"",
              ",", 
             RowBox[{"Length", "[", "P1t", "]"}], ",", "\"\<, \>\"", ",", 
             RowBox[{"Style", "[", 
              RowBox[{"\"\<n\>\"", ",", "Italic"}], "]"}], ",", "\"\< = \>\"",
              ",", 
             RowBox[{"Length", "[", "P2t", "]"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{
            "\"\<sensitivity = \>\"", ",", "sensitivity", ",", 
             "\"\<, specificity = \>\"", " ", ",", "specificity", ",", 
             "\"\<, accuracy = \>\"", ",", "accuracy"}], "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"H1t", "=", 
      RowBox[{"BinCounts", "[", 
       RowBox[{"P1t", ",", 
        RowBox[{"{", 
         RowBox[{"min", ",", "max", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"max", "-", "min"}], ")"}], "/", "bins"}]}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"H2t", "=", 
      RowBox[{"BinCounts", "[", 
       RowBox[{"P2t", ",", 
        RowBox[{"{", 
         RowBox[{"min", ",", "max", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"max", "-", "min"}], ")"}], "/", "bins"}]}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"newdata", "=", 
      RowBox[{"MapAt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Labeled", "[", 
          RowBox[{"#", ",", "\"\<^\>\"", ",", "Below"}], "]"}], "&"}], ",", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"H1t", ",", "H2t"}], "}"}], "]"}], ",", "classBin"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BarChart", "[", 
      RowBox[{"newdata", ",", 
       RowBox[{"PlotLabel", "\[Rule]", 
        RowBox[{"Style", "[", 
         RowBox[{"plotLabel", ",", "Small"}], "]"}]}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"None", ",", "Automatic"}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.418186478683131*^9, 3.418186585132131*^9}, 
   3.418187059789131*^9, {3.418187119065131*^9, 3.418187120093131*^9}, 
   3.4181871681161313`*^9, {3.418187313859131*^9, 3.418187341935131*^9}, {
   3.418187860515131*^9, 3.418187866144131*^9}, {3.418187980574131*^9, 
   3.4181880150891314`*^9}, {3.418188046581131*^9, 3.4181881411361313`*^9}, {
   3.418188505079131*^9, 3.418188506062131*^9}, {3.4181889535751314`*^9, 
   3.4181890243861313`*^9}, {3.418189089637131*^9, 3.418189091508131*^9}, {
   3.418189277767131*^9, 3.4181892816551313`*^9}, {3.4181893200941315`*^9, 
   3.418189331486131*^9}, {3.418280923427515*^9, 3.418280926095515*^9}, 
   3.418280973659515*^9, {3.4182810299715147`*^9, 3.4182810331365147`*^9}, {
   3.4182811054525146`*^9, 3.418281109592515*^9}, {3.4182811758555145`*^9, 
   3.418281262196515*^9}, {3.4182813069255147`*^9, 3.4182814108815145`*^9}, {
   3.418281476173515*^9, 3.418281560029515*^9}, {3.4182816099475145`*^9, 
   3.418281628368515*^9}, {3.418281659154515*^9, 3.418281694457515*^9}, {
   3.4182817358695145`*^9, 3.4182817619775147`*^9}, {3.418281854682515*^9, 
   3.4182820218725147`*^9}, {3.4182820589315147`*^9, 3.418282066299515*^9}, {
   3.418282105207515*^9, 3.418282112854515*^9}, {3.4182821554875145`*^9, 
   3.418282211207515*^9}, {3.4182822508855147`*^9, 3.4182823158675146`*^9}, {
   3.4182823492095146`*^9, 3.418282370245515*^9}, {3.4182833064405146`*^9, 
   3.418283389785515*^9}, {3.418283424097515*^9, 3.418283497061515*^9}, {
   3.4182835796615148`*^9, 3.418283634988515*^9}, {3.4182838106945148`*^9, 
   3.418283840455515*^9}, {3.418283881061515*^9, 3.4182838899255147`*^9}, 
   3.4182839485105147`*^9, {3.4182840064285145`*^9, 3.4182840168085146`*^9}, {
   3.4182840917095146`*^9, 3.418284095882515*^9}, {3.4182842377775145`*^9, 
   3.418284292026515*^9}, {3.4182843657165146`*^9, 3.418284413632515*^9}, {
   3.418284481823515*^9, 3.4182845382865148`*^9}, {3.4182846777545147`*^9, 
   3.418284749917515*^9}, {3.418284812752515*^9, 3.4182848185205145`*^9}, {
   3.4182848936615148`*^9, 3.4182849709385147`*^9}, {3.418285056427515*^9, 
   3.4182850654905148`*^9}, {3.418335796827907*^9, 3.4183358053217564`*^9}, {
   3.4183358427114954`*^9, 3.4183358950977335`*^9}, {3.418335968661089*^9, 
   3.418335969258148*^9}, {3.4183365184910665`*^9, 3.4183365260828257`*^9}, {
   3.4183455949199915`*^9, 3.418345600450545*^9}, {3.4183473471251945`*^9, 
   3.418347380936576*^9}, {3.4183474140548873`*^9, 3.4183474519806795`*^9}, {
   3.418348722175686*^9, 3.4183487705335217`*^9}, {3.4183488316306305`*^9, 
   3.418348835973065*^9}, {3.4183490745749226`*^9, 3.4183491363711014`*^9}, {
   3.4187996720119*^9, 3.4187997022579*^9}, {3.4187997377699003`*^9, 
   3.4187997391599*^9}, {3.4188054302067003`*^9, 3.4188054674667006`*^9}, {
   3.4188055127537003`*^9, 3.4188055186467*^9}, {3.4188056267467003`*^9, 
   3.4188056291877003`*^9}, {3.4188056971747003`*^9, 
   3.4188057104907002`*^9}, {3.4188060313107004`*^9, 3.4188060327747*^9}, {
   3.4188061473477*^9, 3.4188061753427*^9}, {3.4188062991117*^9, 
   3.4188063190467005`*^9}, {3.4188064758067*^9, 3.4188065374517*^9}, {
   3.4188068299837003`*^9, 3.4188068402567005`*^9}, {3.4188071650247*^9, 
   3.4188071690507*^9}, {3.4188072582637005`*^9, 3.4188072649327*^9}, {
   3.418855318482706*^9, 3.418855440103706*^9}, {3.418855480853706*^9, 
   3.418855492709706*^9}, {3.4188555380617056`*^9, 3.418855570642706*^9}, {
   3.4188556643517056`*^9, 3.418855668893706*^9}, {3.419034751217491*^9, 
   3.419034757681491*^9}, {3.4194683213269997`*^9, 3.419468329877*^9}, {
   3.4194788848174*^9, 3.4194790090514*^9}, {3.4194791383864*^9, 
   3.4194791405144*^9}, 3.4194792752114*^9, {3.4194793298733997`*^9, 
   3.4194793323984003`*^9}, {3.4194794381633997`*^9, 
   3.4194794665243998`*^9}, {3.4194795131014*^9, 3.4194795433504*^9}, {
   3.4194864589364*^9, 3.4194865057454*^9}, {3.4194883558492002`*^9, 
   3.4194883597682*^9}, {3.4195500466706953`*^9, 3.419550051099695*^9}, {
   3.419550550317695*^9, 3.419550556296695*^9}, {3.419550647217695*^9, 
   3.419550659507695*^9}, {3.4195512961096954`*^9, 3.4195513348356953`*^9}, {
   3.4195514173416953`*^9, 3.4195514180576954`*^9}, {3.419551651353695*^9, 
   3.419551663332695*^9}, {3.419551706179695*^9, 3.4195517141496954`*^9}, {
   3.4195518951046953`*^9, 3.4195519089186954`*^9}, {3.419551943283695*^9, 
   3.419552028421695*^9}, {3.419552090514695*^9, 3.4195520951896954`*^9}, {
   3.4195521923546953`*^9, 3.4195522261046953`*^9}, {3.419552313600695*^9, 
   3.4195523287606955`*^9}, {3.4195553563216953`*^9, 3.419555383365695*^9}, {
   3.419555442608695*^9, 3.419555584202695*^9}, {3.419555630199695*^9, 
   3.419555706949695*^9}, {3.4195559333716955`*^9, 3.419555943073695*^9}, {
   3.4195562164736953`*^9, 3.4195565642726955`*^9}, {3.419556642648695*^9, 
   3.4195566639146953`*^9}, {3.419556698811695*^9, 3.4195567093806953`*^9}, {
   3.419556766023695*^9, 3.4195567838976955`*^9}, {3.419560209088095*^9, 
   3.419560224117095*^9}, {3.4195603093160954`*^9, 3.419560313834095*^9}, {
   3.419560450992095*^9, 3.419560453452095*^9}, {3.419656582048111*^9, 
   3.419656601702111*^9}, {3.419656815339111*^9, 3.4196568572621107`*^9}, {
   3.4196569192691107`*^9, 3.4196569232031107`*^9}, {3.419656967746111*^9, 
   3.4196570069531107`*^9}, 3.4196580765021105`*^9, {3.4196581229661107`*^9, 
   3.4196581234271107`*^9}, {3.4197156728976*^9, 3.4197157204486*^9}, {
   3.419740340499632*^9, 3.419740377393632*^9}, {3.419740428040632*^9, 
   3.4197405709566317`*^9}, {3.4197501421426315`*^9, 3.419750163393632*^9}, {
   3.505079404224375*^9, 3.50507940533375*^9}, 3.5050799871279483`*^9, {
   3.518984480072878*^9, 3.518984553494945*^9}, {3.518984586686281*^9, 
   3.5189846742057123`*^9}, {3.518984725243952*^9, 3.5189849280870123`*^9}, {
   3.5189851510595903`*^9, 3.518985350658935*^9}, {3.518985384168054*^9, 
   3.518985507311865*^9}, {3.519065902770864*^9, 3.519065902941791*^9}, {
   3.5190700873202963`*^9, 3.51907008930455*^9}, {3.519070120091063*^9, 
   3.519070128189912*^9}, {3.5194732308716*^9, 3.5194732616972*^9}, 
   3.5194734386168003`*^9, {3.5194741265612*^9, 3.5194741515368*^9}, {
   3.5194742764927998`*^9, 3.5194743049628*^9}, {3.5194744226492*^9, 
   3.5194744865936003`*^9}, {3.519474517076*^9, 3.5194745188543997`*^9}, {
   3.51947455826*^9, 3.5194745761532*^9}, {3.5194749320048*^9, 
   3.5194749713324003`*^9}, {3.5194751545699997`*^9, 
   3.5194752360332003`*^9}, {3.5194753754816*^9, 3.5194753805984*^9}, {
   3.5194755283304*^9, 3.5194755350228*^9}, {3.5194758379748*^9, 
   3.519475900796*^9}, {3.519475942994*^9, 3.5194759554428*^9}, {
   3.5194760645024*^9, 3.5194760767328*^9}, {3.5194763977496*^9, 
   3.5194764037244*^9}, {3.519483485956509*^9, 3.519483494860895*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["End Package", "Section",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{3.518989452444159*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}]], "Input",
 InitializationCell->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]], "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Section"],

Cell["\<\
S. Mika, \[OpenCurlyDoubleQuote]Kernel Fisher Discriminants,\
\[CloseCurlyDoubleQuote] Ph.D. thesis, Elektrotechnik und Informatik der \
Technischen Universit\[ADoubleDot]t Berlin, 2002.\
\>", "Reference",
 CellChangeTimes->{{3.4192026374322925`*^9, 3.4192026892662926`*^9}, {
   3.4192028154532924`*^9, 3.4192028372572927`*^9}, {3.419370438613696*^9, 
   3.419370443501696*^9}, 3.4971260720787077`*^9, {3.518882568269409*^9, 
   3.5188825753421164`*^9}},
 CellTags->"MikaPhD"]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{640, 750},
WindowMargins->{{318, Automatic}, {Automatic, 115}},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], None, 
   Cell["Hugh Murrell, Kazuo Hashimoto, and Daichi Takatori", "Header"]}, {
   Cell["MathKFD Package", "Header"], None, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{
   Cell[
    TextData[{"The Mathematica Journal ", 
      StyleBox["13", FontWeight -> "Bold"], 
      " \[Copyright] 2011 Wolfram Media, Inc."}], "Footer"], None, None}, {
  None, None, 
   Cell[
    TextData[{"The Mathematica Journal ", 
      StyleBox["13", FontWeight -> "Bold"], 
      " \[Copyright] 2011 Wolfram Media, Inc."}], "Footer"]}},
ShowSelection->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->Notebook[{
   Cell[
    CellGroupData[{
      Cell[
       TextData[{"Style Definitions for \n", 
         StyleBox["The Mathematica Journal", FontSlant -> "Italic"]}], 
       "Subtitle", CellMargins -> {{0, Inherited}, {Inherited, 0}}, 
       CellFrameMargins -> {{20, 4}, {8, 20}}, FontSize -> 36, FontWeight -> 
       "Bold", FontColor -> GrayLevel[1], Background -> GrayLevel[0]], 
      Cell[
       StyleData[StyleDefinitions -> "Default_8.0.nb"]], 
      Cell[
       CellGroupData[{
         Cell[
         "Styles Brought in from Core.nb, adjusted for TMJ", "Section", 
          CellFrame -> False, CellDingbat -> None, ShowCellBracket -> True, 
          CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Code"], PageWidth -> DirectedInfinity[1], 
             CellMargins -> {{57, 21}, {10, 10}}, Evaluatable -> True, 
             CellGroupingRules -> "InputGrouping", TextClipboardType -> 
             "Package", StripStyleOnPaste -> True, PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, InitializationCell -> True, 
             DefaultFormatType -> DefaultInputFormatType, AutoIndent -> False,
              ShowAutoStyles -> True, "TwoByteSyntaxCharacterAutoReplacement" -> 
             True, HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, 
             AutoItalicWords -> {}, LanguageCategory -> "Mathematica", 
             AutoSpacing -> False, ShowStringCharacters -> True, NumberMarks -> 
             True, DigitBlock -> DirectedInfinity[1], ZeroWidthTimes -> True, 
             LineBreakWithin -> False, LineIndent -> 0, CounterIncrements -> 
             "Code", MenuSortingValue -> 1375, MenuCommandKey -> "8", 
             FontSize -> 11, FontWeight -> "Bold", Background -> 
             RGBColor[0.9, 0.9, 1]], 
            Cell[
             StyleData["Code", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Code", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Code", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell["Brought in from Core.nb, removed FontSize", "Text"], 
         Cell[
          StyleData["MSG"], StyleMenuListing -> None, FontFamily -> 
          "Helvetica"], 
         Cell["Brought in from Core.nb, not modified", "Text"], 
         Cell[
          StyleData["PrintUsage"], Editable -> False, PageWidth -> 
          WindowWidth, CellFrame -> {{0, 0}, {0, 3}}, CellFrameColor -> 
          RGBColor[1, 0.6000000000000001, 0], FontFamily -> "Helvetica", 
          FontSize -> 10, Background -> RGBColor[1, 0.993332, 0.899718]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Style Environment Names", "Section", CellFrame -> False, 
          CellDingbat -> None, ShowCellBracket -> True, 
          CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
         "Corrected style environment names to use the MenuPosition values \
from Core.nb. ", "Text"], 
         Cell[
          StyleData[All, "Working"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.115343, 0.350561, 0.362966]}, ShowCellLabel -> 
          True, CellFrameLabelMargins -> 6, ScriptMinSize -> 9, 
          MenuSortingValue -> 1100], 
         Cell[
          StyleData[All, "Presentation"], ScreenStyleEnvironment -> 
          "Presentation", MenuSortingValue -> 1200, Magnification -> 1.25], 
         Cell[
          StyleData[All, "Printout"], PageWidth -> PaperWidth, 
          ShowCellBracket -> True, CellLabelAutoDelete -> False, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 4}}, 
          ScriptMinSize -> 5, MenuSortingValue -> 1500, 
          PrivateFontOptions -> {"FontType" -> "Outline"}, Magnification -> 
          0.9], 
         Cell["Disabled Menu appearance for SlideShow and Condensed", "Text"], 
         Cell[
          StyleData[All, "SlideShow"], PageWidth -> WindowWidth, DockedCells -> 
          FEPrivate`FrontEndResource["FEExpressions", "SlideshowToolbar"], 
          ScrollingOptions -> {
           "PagewiseDisplay" -> True, "VerticalScrollRange" -> Fit}, 
          ShowCellBracket -> False, ShowAutoStyles -> False, ScriptMinSize -> 
          9, MenuSortingValue -> 1300, StyleMenuListing -> None], 
         Cell[
          StyleData[All, "Condensed"], PageWidth -> WindowWidth, 
          CellLabelMargins -> {{8, Inherited}, {Inherited, Inherited}}, 
          ShowAutoStyles -> False, ScriptMinSize -> 8, MenuSortingValue -> 
          1400, StyleMenuListing -> None]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Notebook Options", "Section", CellFrame -> False, CellDingbat -> 
          None, ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
         "The options defined for the style below will be used at the \
Notebook level.", "Text"], 
         Cell[
          StyleData["Notebook"], PageHeaders -> {{
             Cell[
              TextData[{
                CounterBox["Page"]}], "PageNumber"], Inherited, 
             Cell["Author(s)", "Header"]}, {
             Cell["Article Title", "Header"], Inherited, 
             Cell[
              TextData[{
                CounterBox["Page"]}], "PageNumber"]}}, PageFooters -> {{
             Cell[
              TextData[{"The Mathematica Journal ", 
                StyleBox["volume", FontWeight -> "Bold"], 
                ":issue \[Copyright] year Wolfram Media, Inc."}], "Footer"], 
             Inherited, 
             Cell[
              TextData[{
                ValueBox["FileName"], " ", 
                ValueBox["Date"]}], "Footer"]}, {
             Cell[
              TextData[{
                ValueBox["FileName"], " ", 
                ValueBox["Date"]}], "Footer"], Inherited, 
             Cell[
              TextData[{"The Mathematica Journal ", 
                StyleBox["volume", FontWeight -> "Bold"], 
                ":issue \[Copyright] year Wolfram Media, Inc."}], "Footer"]}},
           PrintingOptions -> {
           "FacingPages" -> True, "FirstPageHeader" -> False, 
            "PageFooterMargins" -> {36, 36}, "PageHeaderMargins" -> {42, 42}, 
            "PrintRegistrationMarks" -> False, 
            "PrintingMargins" -> {{90, 90}, {90, 90}}}, CellFrameLabelMargins -> 
          6, HyphenationOptions -> {
           "HyphenationCharacter" -> "-", "HyphenationFreeZone" -> 12, 
            "HyphenationMinLengths" -> {2, 3}}, StyleMenuListing -> None]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Styles for Headings", "Section", CellFrame -> False, CellDingbat -> 
          None, ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Title"], ShowCellBracket -> False, ShowSelection -> 
             True, CellMargins -> {{21, 21}, {0, 15}}, 
             CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> 
             False, Hyphenation -> False, LineSpacing -> {1, 1}, 
             CounterIncrements -> "Title", 
             CounterAssignments -> {{"Subtitle", 0}, {"Section", 0}, {
               "Subsection", 0}, {"Subsubsection", 0}, {"List", 0}, {
               "NumberedFigure", 0}, {"NumberedTable", 0}, {
               "NumberedProgram", 0}, {"Equation", 0}, {"Text", 0}, {
               "SmallText", 0}, {"Reference", 0}}, MenuSortingValue -> 1100, 
             FontFamily -> "Times", FontSize -> 36, FontWeight -> "Plain", 
             FontSlant -> "Italic"], 
            Cell[
             StyleData["Title", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Title", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Title", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subtitle"], ShowCellBracket -> False, ShowSelection -> 
             True, CellMargins -> {{21, 21}, {5, 2}}, 
             CellGroupingRules -> {"TitleGrouping", 10}, PageBreakBelow -> 
             False, Hyphenation -> False, LineSpacing -> {1, 1}, 
             CounterIncrements -> "Subtitle", FontFamily -> "Times", FontSize -> 
             24, FontSlant -> "Italic"], 
            Cell[
             StyleData["Subtitle", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Subtitle", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Subtitle", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          StyleData["Subsubtitle"], MenuSortingValue -> "None"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Section"], CellFrame -> False, CellDingbat -> 
             "\[FilledSquare]", CellMargins -> {{21, 21}, {10, 30}}, 
             Evaluatable -> False, 
             CellGroupingRules -> {"SectionGrouping", 40}, PageBreakBelow -> 
             False, Hyphenation -> False, CounterIncrements -> "Section", 
             CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
               "ItemNumbered", 0}}, AspectRatioFixed -> True, FontFamily -> 
             "Helvetica", FontSize -> 16, FontWeight -> "Bold", FontColor -> 
             RGBColor[
              0.7013504234378576, 0.3030136568245975, 0.12634470130464637`]], 
            Cell[
             StyleData["Section", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Section", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Section", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subsection"], CellDingbat -> "\[EmptySquare]", 
             CellMargins -> {{21, 21}, {10, 26}}, 
             CellGroupingRules -> {"SectionGrouping", 50}, PageBreakBelow -> 
             False, Hyphenation -> False, LineSpacing -> {1, 1}, 
             CounterIncrements -> "Subsection", 
             CounterAssignments -> {{"Subsubsection", 0}, {
               "ItemNumbered", 0}}, FontFamily -> "Helvetica", FontSize -> 14,
              FontWeight -> "Bold", FontColor -> GrayLevel[0]], 
            Cell[
             StyleData[
             "Subsection", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Subsection", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Subsection", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subsubsection"], CellDingbat -> 
             "\[FilledSmallSquare]", CellMargins -> {{21, 21}, {6, 20}}, 
             CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
             False, Hyphenation -> False, LineSpacing -> {1, 1}, 
             CounterIncrements -> "Subsubsection", 
             CounterAssignments -> {{"ItemNumbered", 0}}, FontFamily -> 
             "Helvetica", FontSize -> 12, FontWeight -> "Bold", FontSlant -> 
             "Oblique"], 
            Cell[
             StyleData[
             "Subsubsection", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "Subsubsection", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "Subsubsection", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subsubsubsection"], CellDingbat -> None, 
             CellMargins -> {{21, 21}, {6, 20}}, 
             CellGroupingRules -> {"SectionGrouping", 70}, PageBreakBelow -> 
             False, Hyphenation -> False, LineSpacing -> {1, 1}, 
             CounterIncrements -> "Subsubsubsection", 
             CounterAssignments -> {{"ItemNumbered", 0}}, StyleMenuListing -> 
             None, FontFamily -> "Helvetica", FontSize -> 12, FontWeight -> 
             "Bold"], 
            Cell[
             StyleData[
             "Subsubsubsection", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "Subsubsubsection", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "Subsubsubsection", "Printout", StyleDefinitions -> None]]}, 
           Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Styles for Body Text", "Section", CellFrame -> False, CellDingbat -> 
          None, ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Text"], CellMargins -> {{21, 21}, {4, 4}}, 
             CounterIncrements -> "Text", 
             CounterAssignments -> {{"ItemNumbered", 0}}, MenuSortingValue -> 
             1370, MenuCommandKey -> "7", FontFamily -> "Times", FontSize -> 
             12], 
            Cell[
             StyleData["Text", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Text", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Text", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Quote"], 
             CellMargins -> {{45, 45}, {Inherited, Inherited}}, 
             MenuSortingValue -> 1520, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData["Quote", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Quote", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Quote", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Styles for Input, Output, and Graphics", "Section", CellFrame -> 
          False, CellDingbat -> None, ShowCellBracket -> True, 
          CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Input"], CellMargins -> {{57, 21}, {10, 10}}, 
             Evaluatable -> True, CellGroupingRules -> "InputGrouping", 
             CellHorizontalScrolling -> True, PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, 
             CellLabelMargins -> {{23, Inherited}, {Inherited, Inherited}}, 
             CellFrameColor -> GrayLevel[0.869993], DefaultFormatType -> 
             DefaultInputFormatType, LineSpacing -> {1, 1}, 
             AutoItalicWords -> {}, ShowStringCharacters -> True, NumberMarks -> 
             True, CounterIncrements -> "Input", MenuSortingValue -> 1400, 
             FontSize -> 11, FontWeight -> "Bold", Background -> None], 
            Cell[
             StyleData["Input", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Input", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Input", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Output"], CellMargins -> {{57, 21}, {13, 5}}, 
             CellEditDuplicate -> True, CellGroupingRules -> "OutputGrouping",
              CellHorizontalScrolling -> True, PageBreakWithin -> False, 
             GroupPageBreakWithin -> False, GeneratedCell -> True, 
             CellAutoOverwrite -> True, 
             CellLabelMargins -> {{23, Inherited}, {Inherited, Inherited}}, 
             CellFrameColor -> GrayLevel[0.869993], DefaultFormatType -> 
             DefaultOutputFormatType, LineSpacing -> {1, 1}, 
             AutoItalicWords -> {}, CounterIncrements -> "Output", 
             StyleMenuListing -> None, FontSize -> 11, Background -> None], 
            Cell[
             StyleData["Output", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Output", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Output", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Message"], CellFrame -> {{0.25, 0.25}, {0, 0}}, 
             CellDingbat -> "\[WarningSign]", 
             CellMargins -> {{57, 21}, {13, 0}}, CellGroupingRules -> 
             "OutputGrouping", PageBreakWithin -> False, GroupPageBreakWithin -> 
             False, GeneratedCell -> True, CellAutoOverwrite -> True, 
             ShowCellLabel -> False, 
             CellLabelMargins -> {{23, Inherited}, {Inherited, Inherited}}, 
             CellFrameColor -> GrayLevel[0.869993], CellFrameLabelMargins -> 
             0, DefaultFormatType -> DefaultOutputFormatType, 
             LineSpacing -> {1, 1}, AutoItalicWords -> {}, StyleMenuListing -> 
             None, FontFamily -> "Helvetica", FontSize -> 10, FontColor -> 
             RGBColor[0, 0, 1], Background -> GrayLevel[0.949996]], 
            Cell[
             StyleData["Message", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Message", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Message", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Print"], CellFrame -> True, 
             CellMargins -> {{57, 21}, {13, 0}}, CellGroupingRules -> 
             "OutputGrouping", CellHorizontalScrolling -> True, 
             PageBreakWithin -> False, GroupPageBreakWithin -> False, 
             GeneratedCell -> True, CellAutoOverwrite -> True, ShowCellLabel -> 
             False, CellLabelMargins -> {{23, Inherited}, {
               Inherited, Inherited}}, CellFrameColor -> GrayLevel[0], 
             DefaultFormatType -> DefaultOutputFormatType, 
             LineSpacing -> {1, 1}, AutoItalicWords -> {}, StyleMenuListing -> 
             None, FontFamily -> "Helvetica", FontSize -> 10], 
            Cell[
             StyleData["Print", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Print", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Print", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          
          TextData[{
           "PlacedGraphics cell style to be used when importing a graphic \
from another  application or when presenting a graphic not associated with ", 
            StyleBox["Mathematica", FontSlant -> "Italic"], 
            " input. May be followed by NumberedFigureCaption."}], "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["PlacedGraphics"], CellFrame -> False, 
             CellMargins -> {{21, 21}, {8, 10}}, CellGroupingRules -> 
             "GraphicsGrouping", CellHorizontalScrolling -> True, 
             ShowCellLabel -> False, TextAlignment -> Left, 
             LineSpacing -> {1, 1}, 
             InsetBoxOptions -> {
              BaseStyle -> {CellFrame -> None, Background -> None}}], 
            Cell[
             StyleData[
             "PlacedGraphics", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "PlacedGraphics", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "PlacedGraphics", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["CellLabel"], 
             CellMargins -> {{5, Inherited}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, StyleMenuListing -> None, FontFamily -> 
             "Helvetica", FontSize -> 8, FontSlant -> "Oblique", FontColor -> 
             RGBColor[0.115343, 0.350561, 0.362966]], 
            Cell[
             StyleData[
             "CellLabel", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["CellLabel", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["CellLabel", "Printout", StyleDefinitions -> None]]}, 
           Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Styles for Automatic Numbering and Lists", "Section", CellFrame -> 
          False, CellDingbat -> None, ShowCellBracket -> True, 
          CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DisplayFormulaNumbered"], 
             CellMargins -> {{39, 21}, {4, 4}}, StripStyleOnPaste -> True, 
             CellFrameLabels -> {{None, 
                Cell[
                 TextData[{"(", 
                   CounterBox["DisplayFormulaNumbered"], ")"}], 
                 CellSize -> {30, Inherited}, TextAlignment -> Right]}, {
               None, None}}, DefaultFormatType -> TraditionalForm, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, 
             LineSpacing -> {1, 1}, LanguageCategory -> "Formula", 
             ScriptLevel -> 0, SingleLetterItalics -> True, CounterIncrements -> 
             "DisplayFormulaNumbered", MenuSortingValue -> 1700, FontFamily -> 
             "Times", 
             UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
            Cell[
             StyleData[
             "DisplayFormulaNumbered", "Presentation", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "DisplayFormulaNumbered", "SlideShow", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "DisplayFormulaNumbered", "Printout", StyleDefinitions -> 
              None]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineFormula"], CellMargins -> {{10, 4}, {0, 8}}, 
             StripStyleOnPaste -> True, 
             HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             "Formula", ScriptLevel -> 1, SingleLetterItalics -> True, 
             MenuSortingValue -> None], 
            Cell[
             StyleData[
             "InlineFormula", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "InlineFormula", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "InlineFormula", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["NumberedFigureCaption"], CellDingbat -> 
             "\[FilledUpTriangle]", CellMargins -> {{21, 21}, {8, 0}}, 
             PageBreakAbove -> False, TextAlignment -> Left, 
             LineSpacing -> {1, 1}, CounterIncrements -> "NumberedFigure", 
             MenuSortingValue -> 1711, FormatTypeAutoConvert -> False, 
             FontFamily -> "Helvetica", FontSize -> 10], 
            Cell[
             StyleData[
             "NumberedFigureCaption", "Presentation", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "NumberedFigureCaption", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "NumberedFigureCaption", "Printout", StyleDefinitions -> None]]},
            Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["NumberedTableCaption"], CellDingbat -> 
             "\[FilledUpTriangle]", CellMargins -> {{21, 21}, {8, 0}}, 
             PageBreakAbove -> False, LineSpacing -> {1, 1}, 
             CounterIncrements -> "NumberedTable", MenuSortingValue -> 1712, 
             FontFamily -> "Helvetica", FontSize -> 10], 
            Cell[
             StyleData[
             "NumberedTableCaption", "Presentation", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "NumberedTableCaption", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "NumberedTableCaption", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["NumberedProgramCaption"], CellDingbat -> 
             "\[FilledUpTriangle]", CellMargins -> {{21, 21}, {8, 0}}, 
             PageBreakAbove -> False, LineSpacing -> {1, 1}, 
             CounterIncrements -> "NumberedProgram", MenuSortingValue -> 1713,
              FormatTypeAutoConvert -> False, FontFamily -> "Helvetica", 
             FontSize -> 10], 
            Cell[
             StyleData[
             "NumberedProgramCaption", "Presentation", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "NumberedProgramCaption", "SlideShow", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "NumberedProgramCaption", "Printout", StyleDefinitions -> 
              None]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Caption"], CellDingbat -> "\[FilledUpTriangle]", 
             CellMargins -> {{21, 21}, {Inherited, 5}}, PageBreakAbove -> 
             False, LineSpacing -> {1, 1}, FontFamily -> "Helvetica", 
             FontSize -> 10], 
            Cell[
             StyleData["Caption", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Caption", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Caption", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Item"], CellDingbat -> "\[FilledSmallCircle]", 
             CellMargins -> {{58, 21}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, 
             CounterAssignments -> {{"SubitemNumbered", 0}}, MenuSortingValue -> 
             1775, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData["Item", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Item", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Item", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Subitem"], CellDingbat -> "\[FilledSmallCircle]", 
             CellMargins -> {{74, 21}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, MenuSortingValue -> 1776, FontFamily -> 
             "Times", FontSize -> 12], 
            Cell[
             StyleData["Subitem", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Subitem", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Subitem", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ItemNumbered"], CellDingbat -> Cell[
               TextData[{
                 CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold", 
               CellSize -> {20, Inherited}, TextAlignment -> Right], 
             CellMargins -> {{58, 21}, {Inherited, Inherited}}, CellBaseline -> 
             Baseline, LineSpacing -> {1, 1}, TabSpacings -> {4.}, 
             CounterAssignments -> {{"SubitemNumbered", 0}}, MenuSortingValue -> 
             1777, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData[
             "ItemNumbered", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "ItemNumbered", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["ItemNumbered", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SubitemNumbered"], CellDingbat -> Cell[
               TextData[{
                 CounterBox["SubitemNumbered", CounterFunction :> (Part[
                    CharacterRange["a", "z"], #]& )], "."}], FontWeight -> 
               "Bold"], CellMargins -> {{74, 21}, {Inherited, Inherited}}, 
             CellBaseline -> Baseline, LineSpacing -> {1, 1}, 
             MenuSortingValue -> 1778, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData[
             "SubitemNumbered", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "SubitemNumbered", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "SubitemNumbered", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "ItemParagraph", StyleDefinitions -> StyleData["Item"]], 
             CellDingbat -> None, CounterIncrements -> "ItemParagraph", 
             MenuSortingValue -> 1779], 
            Cell[
             StyleData[
             "ItemParagraph", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "ItemParagraph", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["ItemParagraph", "Printout", StyleDefinitions -> None],
              TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "SubitemParagraph", StyleDefinitions -> StyleData["Subitem"]], 
             CellDingbat -> None, CounterIncrements -> "SubitemParagraph", 
             MenuSortingValue -> 1800], 
            Cell[
             StyleData[
             "SubitemParagraph", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "SubitemParagraph", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "SubitemParagraph", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Reference"], CellDingbat -> Cell[
               TextData[{"[", 
                 CounterBox["Reference"], "]"}], "SR", 
               CellSize -> {25, Inherited}, TextAlignment -> Right], 
             CellMargins -> {{47, 21}, {Inherited, Inherited}}, 
             CellFrameLabels -> {{None, None}, {None, None}}, 
             LineSpacing -> {1, 1}, CounterIncrements -> "Reference", 
             MenuSortingValue -> 1870, FontFamily -> "Helvetica", FontSize -> 
             10], 
            Cell[
             StyleData["Reference", "Presentation", StyleDefinitions -> None],
              CellMargins -> {{59, 21}, {Inherited, Inherited}}], 
            Cell[
             StyleData["Reference", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Reference", "Printout", StyleDefinitions -> None], 
             CellMargins -> {{45, 21}, {Inherited, Inherited}}, 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData[
             "DOIReference", StyleDefinitions -> StyleData["Reference"]], 
             CellDingbat -> None, CellMargins -> {{21, 21}, {Inherited, 10}}, 
             CounterIncrements -> "DOIReference", FontSize -> 9], 
            Cell[
             StyleData["DOIReference", "Presentation"], 
             CellMargins -> {{21, 21}, {Inherited, 10}}], 
            Cell[
             StyleData["DOIReference", "Printout"], 
             CellMargins -> {{21, 21}, {Inherited, 10}}]}, Closed]], 
         Cell[
          StyleData[
          "DOIReference1", StyleDefinitions -> StyleData["DOIReference"]], 
          CellChangeTimes -> {{3.500647185533589*^9, 3.500647185556703*^9}}], 
         Cell[
          StyleData[
          "DOIReference10", StyleDefinitions -> StyleData["DOIReference"]], 
          CellChangeTimes -> {{3.500647185533589*^9, 
           3.5006471855594378`*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Journal Element Styles", "Section", CellFrame -> False, CellDingbat -> 
          None, ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          StyleData["OnlineHeader"], ShowCellBracket -> False, ShowSelection -> 
          True, CellMargins -> {{0, 0}, {0, 0}}, 
          CellGroupingRules -> {"TitleGrouping", 30}, PageBreakBelow -> False,
           CellFrameMargins -> {{21, 21}, {2, 8}}, Hyphenation -> False, 
          LineSpacing -> {1, 1}, StyleMenuListing -> None, FontFamily -> 
          "Times", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9864194705119402, 0.9585259784847792, 0.7428549629968719], 
          Background -> RGBColor[0, 0, 0]], 
         Cell[
         "ColumnTitle is a renaming of PreTitle.", "Text", 
          CellChangeTimes -> {{3.4810538075243597`*^9, 
           3.481053831482122*^9}}], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["ColumnTitle"], ShowCellBracket -> False, 
             CellMargins -> {{21, 21}, {14, 4}}, 
             CellGroupingRules -> {"TitleGrouping", 0}, PageBreakBelow -> 
             False, CellFrameMargins -> {{55, 4}, {8, 20}}, Hyphenation -> 
             False, LineSpacing -> {1, 1}, StyleMenuListing -> None, 
             FontFamily -> "Helvetica", FontSize -> 13, FontWeight -> 
             "Regular"], 
            Cell[
             StyleData[
             "ColumnTitle", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["ColumnTitle", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["ColumnTitle", "Printout", StyleDefinitions -> None]]},
            Closed]], 
         Cell[
         "Author to be used after the Title cell with author name(s). Author \
name(s) may be preceded by \"Edited by \" for certain columns. Text in author \
cell to be used as the left page header.", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Author"], ShowCellBracket -> False, ShowSelection -> 
             True, CellMargins -> {{21, 21}, {4, 6}}, CellGroupingRules -> 
             "NormalGrouping", PageBreakBelow -> False, Hyphenation -> False, 
             LineSpacing -> {1, 1}, ParagraphSpacing -> {0, 0}, 
             MenuSortingValue -> 1155, FontFamily -> "Helvetica", FontSize -> 
             14, FontWeight -> "Bold"], 
            Cell[
             StyleData["Author", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Author", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Author", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Abstract"], ShowCellBracket -> False, ShowSelection -> 
             True, CellMargins -> {{21, 83}, {4, 25}}, Hyphenation -> False, 
             LineSpacing -> {1, 3}, MenuSortingValue -> 1156, FontFamily -> 
             "Helvetica", FontSize -> 13, FontWeight -> "Regular", FontSlant -> 
             "Plain"], 
            Cell[
             StyleData["Abstract", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Abstract", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Abstract", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Question"], CellFrame -> {{0, 0}, {0, 2}}, 
             CellDingbat -> "Q:", CellMargins -> {{45, 45}, {8, 8}}, 
             CellFrameMargins -> {{0, 0}, {2, 4}}, LineSpacing -> {1, 1}, 
             MenuSortingValue -> 1820, FontFamily -> "Times", FontSize -> 14, 
             FontWeight -> "Bold", FontColor -> 
             RGBColor[0.115511, 0.321752, 0.580118]], 
            Cell[
             StyleData["Question", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Question", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Question", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Answer"], CellDingbat -> 
             Cell["A:", FontWeight -> "Bold"], 
             CellMargins -> {{45, 45}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, CounterIncrements -> "Text", 
             MenuSortingValue -> 1860, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData["Answer", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Answer", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Answer", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TextAboutAuthor"], CellMargins -> {{21, 21}, {2, 5}}, 
             LineSpacing -> {1, 1}, CounterIncrements -> "Text", 
             MenuSortingValue -> 1880, FontSize -> 12], 
            Cell[
             StyleData[
             "TextAboutAuthor", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "TextAboutAuthor", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "TextAboutAuthor", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["SectionAboutAuthor"], 
             CellMargins -> {{21, 21}, {10, 30}}, 
             CellGroupingRules -> {"SectionGrouping", 40}, PageBreakBelow -> 
             False, CellFrameMargins -> 4, Hyphenation -> False, 
             LineSpacing -> {1, 1}, MenuSortingValue -> 1875, FontFamily -> 
             "Helvetica", FontSize -> 12, FontWeight -> "Bold"], 
            Cell[
             StyleData[
             "SectionAboutAuthor", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "SectionAboutAuthor", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "SectionAboutAuthor", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
         "Styles for algorithm listings, based on BulletedList, indent an \
additional 12 points for each level, dingbat also changes", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Algorithm1"], CellDingbat -> "\[FilledSmallCircle]", 
             CellMargins -> {{58, 21}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData[
             "Algorithm1", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm1", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm1", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Algorithm2"], CellDingbat -> "\[Dash]", 
             CellMargins -> {{74, 21}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData[
             "Algorithm2", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm2", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm2", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Algorithm3"], CellDingbat -> "\[Star]", 
             CellMargins -> {{86, 21}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData[
             "Algorithm3", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm3", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm3", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Algorithm4"], CellDingbat -> "\[CenterDot]", 
             CellMargins -> {{98, 21}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, FontFamily -> "Times", FontSize -> 12], 
            Cell[
             StyleData[
             "Algorithm4", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm4", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Algorithm4", "Printout", StyleDefinitions -> None], 
             TextJustification -> 1.]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Enunciations", "Section", CellFrame -> False, CellDingbat -> None, 
          ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell["Theorem", "Subsubsection", MenuSortingValue -> 1871], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Theorem"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Theorem", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, MenuSortingValue -> 1871, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "Theorem", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Theorem", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Theorem", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["TheoremLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "TheoremLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "TheoremLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "TheoremLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["TheoremContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", LineSpacing -> {1, 1}, CounterIncrements -> 
                "TheoremContinuation", MenuSortingValue -> 1872, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "TheoremContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "TheoremContinuation", "SlideShow", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "TheoremContinuation", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Example", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Example"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Example", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, MenuSortingValue -> 1873, FontSlant -> 
                "Plain"], 
               Cell[
                StyleData[
                "Example", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Example", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Example", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ExampleLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Italic"], 
               Cell[
                StyleData[
                "ExampleLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "ExampleLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "ExampleLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ExampleContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", LineSpacing -> {1, 1}, CounterIncrements -> 
                "ExampleContinuation", MenuSortingValue -> 1874], 
               Cell[
                StyleData[
                "ExampleContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "ExampleContinuation", "SlideShow", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "ExampleContinuation", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Proof", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Proof"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, MenuSortingValue -> 1875, FontSlant -> 
                "Plain"], 
               Cell[
                StyleData["Proof", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Proof", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Proof", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ProofLabel"], StyleMenuListing -> None, FontWeight -> 
                "Bold", FontSlant -> "Italic"], 
               Cell[
                StyleData[
                "ProofLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "ProofLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "ProofLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ProofContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", LineSpacing -> {1, 1}, CounterIncrements -> 
                "ProofContinuation"], 
               Cell[
                StyleData[
                "ProofContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "ProofContinuation", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "ProofContinuation", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["QED"], CellMargins -> {{21, 21}, {8, 0}}, 
                StyleMenuListing -> None, FontSize -> 14], 
               Cell[
                StyleData["QED", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["QED", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["QED", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Corollary", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Corollary"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Corollary", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "Corollary", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "Corollary", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Corollary", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["CorollaryLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "CorollaryLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "CorollaryLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "CorollaryLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["CorollaryContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "CorollaryContinuation", StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "CorollaryContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "CorollaryContinuation", "SlideShow", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "CorollaryContinuation", "Printout", StyleDefinitions -> 
                 None], TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Lemma", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Lemma"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Lemma", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData["Lemma", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Lemma", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Lemma", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["LemmaLabel"], StyleMenuListing -> None, FontWeight -> 
                "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "LemmaLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "LemmaLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "LemmaLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["LemmaContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "LemmaContinuation", StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "LemmaContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "LemmaContinuation", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "LemmaContinuation", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Definition", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Definition"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Definition", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "Definition", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "Definition", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Definition", "Printout", StyleDefinitions -> None],
                 TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["DefinitionLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "DefinitionLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "DefinitionLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "DefinitionLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["DefinitionContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "DefinitionContinuation", StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "DefinitionContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "DefinitionContinuation", "SlideShow", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "DefinitionContinuation", "Printout", StyleDefinitions -> 
                 None], TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Proposition", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Proposition"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Proposition", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "Proposition", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "Proposition", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "Proposition", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["PropositionLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "PropositionLabel", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "PropositionLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "PropositionLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["PropositionContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "PropositionContinuation", StyleMenuListing -> None, 
                FontSlant -> "Italic"], 
               Cell[
                StyleData[
                "PropositionContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "PropositionContinuation", "SlideShow", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "PropositionContinuation", "Printout", StyleDefinitions -> 
                 None], TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Conjecture", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Conjecture"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Conjecture", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "Conjecture", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "Conjecture", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Conjecture", "Printout", StyleDefinitions -> None],
                 TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ConjectureLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "ConjectureLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "ConjectureLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "ConjectureLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["ConjectureContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "ConjectureContinuation", StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "ConjectureContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "ConjectureContinuation", "SlideShow", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "ConjectureContinuation", "Printout", StyleDefinitions -> 
                 None], TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Axiom", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Axiom"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Axiom", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData["Axiom", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Axiom", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Axiom", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["AxiomLabel"], StyleMenuListing -> None, FontWeight -> 
                "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "AxiomLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "AxiomLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "AxiomLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["AxiomContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "AxiomContinuation", StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "AxiomContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "AxiomContinuation", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "AxiomContinuation", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Rule", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Rule"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Rule", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData["Rule", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Rule", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Rule", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["RuleLabel"], StyleMenuListing -> None, FontWeight -> 
                "Bold", FontSlant -> "Plain"], 
               Cell[
                StyleData[
                "RuleLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "RuleLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "RuleLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["RuleContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "RuleContinuation", StyleMenuListing -> None, FontSlant -> 
                "Italic"], 
               Cell[
                StyleData[
                "RuleContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "RuleContinuation", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "RuleContinuation", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Remark", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Remark"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterIncrements -> "Remark", 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Plain"], 
               Cell[
                StyleData[
                "Remark", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Remark", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Remark", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["RemarkLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Italic"], 
               Cell[
                StyleData[
                "RemarkLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "RemarkLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "RemarkLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["RemarkContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "RemarkContinuation", StyleMenuListing -> None], 
               Cell[
                StyleData[
                "RemarkContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "RemarkContinuation", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "RemarkContinuation", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]]}, Closed]], 
         Cell[
          CellGroupData[{
            Cell["Solution", "Subsubsection", StyleMenuListing -> None], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["Solution"], CellMargins -> {{21, 21}, {4, 4}}, 
                CellGroupingRules -> "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, ParagraphIndent -> 24, 
                CounterAssignments -> {{"EnunciationItem1Numbered", 0}, {
                  "Item1Numbered", 0}}, StyleMenuListing -> None, FontSlant -> 
                "Plain"], 
               Cell[
                StyleData[
                "Solution", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData["Solution", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData["Solution", "Printout", StyleDefinitions -> None], 
                TextJustification -> 1.]}, Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["SolutionLabel"], StyleMenuListing -> None, 
                FontWeight -> "Bold", FontSlant -> "Italic"], 
               Cell[
                StyleData[
                "SolutionLabel", "Presentation", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "SolutionLabel", "SlideShow", StyleDefinitions -> None]], 
               Cell[
                StyleData[
                "SolutionLabel", "Printout", StyleDefinitions -> None]]}, 
              Closed]], 
            Cell[
             CellGroupData[{
               Cell[
                StyleData["SolutionContinuation"], 
                CellMargins -> {{21, 21}, {4, 4}}, CellGroupingRules -> 
                "GraphicsGrouping", Hyphenation -> True, 
                LineSpacing -> {1, 1}, CounterIncrements -> 
                "SolutionContinuation", StyleMenuListing -> None], 
               Cell[
                StyleData[
                "SolutionContinuation", "Presentation", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "SolutionContinuation", "SlideShow", StyleDefinitions -> 
                 None]], 
               Cell[
                StyleData[
                "SolutionContinuation", "Printout", StyleDefinitions -> None],
                 TextJustification -> 1.]}, Closed]]}, Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Display Formulas and Programming", "Section", CellFrame -> False, 
          CellDingbat -> None, ShowCellBracket -> True, 
          CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["DisplayFormula"], CellMargins -> {{39, 21}, {4, 4}}, 
             CellHorizontalScrolling -> True, PageBreakAbove -> False, 
             DefaultFormatType -> TraditionalForm, LineSpacing -> {1, 1}, 
             ScriptLevel -> 0, SingleLetterItalics -> True, SpanMaxSize -> 
             DirectedInfinity[1], FormatTypeAutoConvert -> False, FontFamily -> 
             "Times", FontSize -> 12, 
             UnderoverscriptBoxOptions -> {LimitsPositioning -> True}, 
             GridBoxOptions -> {AllowScriptLevelChange -> False}], 
            Cell[
             StyleData[
             "DisplayFormula", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "DisplayFormula", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "DisplayFormula", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Program"], CellMargins -> {{21, 21}, {8, 10}}, 
             LineSpacing -> {1, 1}, MenuSortingValue -> 1455, FontFamily -> 
             "Courier", FontSize -> 12, FontWeight -> "Plain"], 
            Cell[
             StyleData["Program", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Program", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Program", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Table"], CellMargins -> {{21, 21}, {8, 10}}, 
             DefaultFormatType -> TraditionalForm, TextAlignment -> Center, 
             LineSpacing -> {1, 1}, FontFamily -> "Times", FontSize -> 12, 
             Background -> GrayLevel[0.899001]], 
            Cell[
             StyleData["Table", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Table", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Table", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
         "PseudoCellExpression cell style to be used when displaying \
unformatted box expressions. ", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["PseudoCellExpression"], 
             CellFrame -> {{0, 0}, {0, 0.5}}, 
             CellMargins -> {{21, 21}, {Inherited, Inherited}}, 
             CellFrameMargins -> 2, LineSpacing -> {1, 1}, FontFamily -> 
             "Courier", FontSize -> 12], 
            Cell[
             StyleData[
             "PseudoCellExpression", "Presentation", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "PseudoCellExpression", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "PseudoCellExpression", "Printout", StyleDefinitions -> None]]}, 
           Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Styles for Headers and Footers", "Section", CellFrame -> False, 
          CellDingbat -> None, ShowCellBracket -> True, 
          CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          StyleData["Header"], CellMargins -> {{0, 0}, {4, 1}}, 
          StyleMenuListing -> None, FontFamily -> "Times", FontSize -> 9, 
          FontSlant -> "Italic"], 
         Cell[
          StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
          StyleMenuListing -> None, FontFamily -> "Times", FontSize -> 9, 
          FontWeight -> "Bold", FontSlant -> "Plain"], 
         Cell[
          StyleData["Footer"], CellMargins -> {{0, 0}, {0, 4}}, 
          StyleMenuListing -> None, FontFamily -> "Helvetica", FontSize -> 7, 
          FontSlant -> "Oblique"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Hyperlink Styles", "Section", CellFrame -> False, CellDingbat -> 
          None, ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell["The cells below define styles used for ButtonBoxes.", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Hyperlink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[
              0.9230792706187534, 0.3988097962920577, 0.1662928206301976], 
             ButtonBoxOptions -> {
              Active -> True, ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`NotebookLocate[#2]}]& ), ButtonNote -> 
               ButtonData}], 
            Cell[
             StyleData[
             "Hyperlink", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["Hyperlink", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["Hyperlink", "Printout", StyleDefinitions -> None], 
             FontVariations -> {"Underline" -> False}, FontColor -> 
             GrayLevel[0]]}, Closed]], 
         Cell[
         "The following styles are for linking automatically to the locally \
installed on-line help system.", "Text"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MainBookLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[
              0.9230792706187534, 0.3988097962920577, 0.1662928206301976], 
             ButtonBoxOptions -> {
              Active -> True, Appearance -> {Automatic, None}, 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["MainBook", #]}]& )}], 
            Cell[
             StyleData[
             "MainBookLink", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "MainBookLink", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "MainBookLink", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["AddOnsLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[
              0.9230792706187534, 0.3988097962920577, 0.1662928206301976], 
             ButtonBoxOptions -> {
              Active -> True, Appearance -> {Automatic, None}, 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["AddOns", #]}]& )}], 
            Cell[
             StyleData[
             "AddOnsLink", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["AddOnsLink", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["AddOnsLink", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["RefGuideLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[
              0.9230792706187534, 0.3988097962920577, 0.1662928206301976], 
             ButtonBoxOptions -> {
              Active -> True, Appearance -> {Automatic, None}, 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["RefGuide", #]}]& )}], 
            Cell[
             StyleData[
             "RefGuideLink", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "RefGuideLink", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "RefGuideLink", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["GettingStartedLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[
              0.9230792706187534, 0.3988097962920577, 0.1662928206301976], 
             ButtonBoxOptions -> {
              Active -> True, Appearance -> {Automatic, None}, 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["GettingStarted", #]}]& )}], 
            Cell[
             StyleData[
             "GettingStartedLink", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "GettingStartedLink", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "GettingStartedLink", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["OtherInformationLink"], StyleMenuListing -> None, 
             ButtonStyleMenuListing -> Automatic, 
             FontVariations -> {"Underline" -> True}, FontColor -> 
             RGBColor[
              0.9230792706187534, 0.3988097962920577, 0.1662928206301976], 
             ButtonBoxOptions -> {
              Active -> True, Appearance -> {Automatic, None}, 
               ButtonFunction :> (FrontEndExecute[{
                  FrontEnd`HelpBrowserLookup["OtherInformation", #]}]& )}], 
            Cell[
             StyleData[
             "OtherInformationLink", "Presentation", StyleDefinitions -> 
              None]], 
            Cell[
             StyleData[
             "OtherInformationLink", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "OtherInformationLink", "Printout", StyleDefinitions -> None]]}, 
           Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "FormatType Styles", "Section", CellFrame -> False, CellDingbat -> 
          None, ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
         "These cells define styles that are mixed in with other cells.  If \
the FormatType of a cell style matches the name of one of the styles defined \
below, then that style is applied along with the local cell style \
definitions. ", "Text", CellMargins -> {{24, 0}, {Inherited, Inherited}}], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["CellExpression"], CellMargins -> {{54, 24}, {2, 4}}, 
             ShowCellLabel -> False, ShowSpecialCharacters -> False, 
             AllowInlineCells -> False, Hyphenation -> False, 
             LineSpacing -> {1, 1}, AutoItalicWords -> {}, StyleMenuListing -> 
             None, FontFamily -> "Courier", FontSize -> 12, Background -> 
             GrayLevel[1]], 
            Cell[
             StyleData[
             "CellExpression", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "CellExpression", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "CellExpression", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InputForm"], PageWidth -> WindowWidth, 
             InputAutoReplacements -> {}, AllowInlineCells -> False, 
             Hyphenation -> False, AutoSpacing -> False, NumberMarks -> True, 
             AutoNumberFormatting -> False, StyleMenuListing -> None, 
             FontFamily -> "Courier"], 
            Cell[
             StyleData[
             "InputForm", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["InputForm", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["InputForm", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["OutputForm"], StyleMenuListing -> None, FontFamily -> 
             "Courier"], 
            Cell[
             StyleData[
             "OutputForm", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["OutputForm", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["OutputForm", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["StandardForm"], 
             InputAutoReplacements -> {
              "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> 
               "\[LessEqual]", ">=" -> "\[GreaterEqual]", "!=" -> 
               "\[NotEqual]", "==" -> "\[Equal]", $CellContext`ParentList}, 
             "TwoByteSyntaxCharacterAutoReplacement" -> True, 
             SingleLetterItalics -> False, StyleMenuListing -> None, 
             FontFamily -> "Courier"], 
            Cell[
             StyleData[
             "StandardForm", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "StandardForm", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "StandardForm", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TraditionalForm"], TextClipboardType -> "PlainText", 
             InputAutoReplacements -> {
              "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> 
               "\[LessEqual]", ">=" -> "\[GreaterEqual]", "!=" -> 
               "\[NotEqual]", "==" -> "\[Equal]", $CellContext`ParentList}, 
             ShowSyntaxStyles -> False, 
             "TwoByteSyntaxCharacterAutoReplacement" -> True, 
             SingleLetterItalics -> True, TraditionalFunctionNotation -> True,
              DelimiterMatching -> None, ZeroWidthTimes -> False, 
             StyleMenuListing -> None], 
            Cell[
             StyleData[
             "TraditionalForm", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "TraditionalForm", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "TraditionalForm", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
         "The style defined below is mixed in to any cell that is in an \
inline cell within another.", "Text", 
          CellMargins -> {{24, 0}, {Inherited, Inherited}}], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineCell"], TextAlignment -> Left, ScriptLevel -> 1,
              StyleMenuListing -> None], 
            Cell[
             StyleData[
             "InlineCell", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData["InlineCell", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData["InlineCell", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["InlineCellEditing"], StyleMenuListing -> None, 
             Background -> RGBColor[1, 0.749996, 0.8]], 
            Cell[
             StyleData[
             "InlineCellEditing", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "InlineCellEditing", "SlideShow", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "InlineCellEditing", "Printout", StyleDefinitions -> None]]}, 
           Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Inline Formatting", "Section", CellFrame -> False, CellDingbat -> 
          None, ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, FontColor -> GrayLevel[1], 
          Background -> RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          StyleData["RM"], FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["MR"], 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
          "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["MO"], 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
          "Plain", FontSlant -> "Oblique"], 
         Cell[
          StyleData["MB"], 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
          "Bold", FontSlant -> "Plain"], 
         Cell[
          StyleData["MBO"], 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           StyleMenuListing -> None, FontFamily -> "Courier", FontWeight -> 
          "Bold", FontSlant -> "Oblique"], 
         Cell[
          StyleData["AboutAuthorR"], FontFamily -> "Times", FontWeight -> 
          "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["AboutAuthorI"], FontFamily -> "Times", FontWeight -> 
          "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["AboutAuthorB"], FontFamily -> "Times", FontWeight -> 
          "Bold", FontSlant -> "Plain"], 
         Cell[
          StyleData["AboutAuthorBI"], FontFamily -> "Times", FontWeight -> 
          "Bold", FontSlant -> "Italic"], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["MCode"], "TwoByteSyntaxCharacterAutoReplacement" -> 
             True, HyphenationOptions -> {
              "HyphenationCharacter" -> "\[Continuation]"}, LanguageCategory -> 
             "Formula", AutoSpacing -> True, ScriptLevel -> 1, 
             SingleLetterItalics -> False, SpanMaxSize -> 1, StyleMenuListing -> 
             None, FontFamily -> "Courier", 
             ButtonBoxOptions -> {Appearance -> {Automatic, None}}, 
             FractionBoxOptions -> {BaseStyle -> {SpanMaxSize -> Automatic}}, 
             GridBoxOptions -> {
              GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}}], 
            Cell[
             StyleData["MCode", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["Math"], DefaultFormatType -> "DefaultTextFormatType", 
             DefaultInlineFormatType -> "TraditionalForm", LanguageCategory -> 
             "Formula", AutoSpacing -> True, ScriptLevel -> 1, 
             AutoMultiplicationSymbol -> False, SingleLetterItalics -> True, 
             SpanMaxSize -> Infinity, StyleMenuListing -> None, FontFamily -> 
             "Times", ButtonBoxOptions -> {Appearance -> {Automatic, None}}, 
             GridBoxOptions -> {
              BaseStyle -> {FontFamily -> "Times"}, GridBoxDividers -> {}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{1.}}, "RowsIndexed" -> {}}, 
               GridBoxSpacings -> {}}], 
            Cell[
             StyleData["Math", "Printout", StyleDefinitions -> None]]}, 
           Closed]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "Editorial", "Section", CellFrame -> False, CellDingbat -> None, 
          ShowCellBracket -> True, CellMargins -> {{0, 0}, {10, 40}}, 
          CellFrameMargins -> {{20, 4}, {8, 8}}, 
          CellChangeTimes -> {{3.481313643935946*^9, 3.481313646546287*^9}}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.269902, 0.558434, 0.715618]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["EditorialComment"], CellFrame -> False, CellDingbat -> 
             "\[FilledCircle]", 
             CellMargins -> {{36, 25}, {Inherited, Inherited}}, 
             LineSpacing -> {1, 1}, MenuSortingValue -> None, FontColor -> 
             RGBColor[
              0.9230792706187534, 0.3988097962920577, 0.1662928206301976], 
             Background -> GrayLevel[1]], 
            Cell[
             StyleData[
             "EditorialComment", "Presentation", StyleDefinitions -> None]], 
            Cell[
             StyleData[
             "EditorialComment", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TextAnnotation"], CellFrame -> 1, CellFrameColor -> 
             RGBColor[0.8, 0, 0], AutoSpacing -> False, LineIndent -> 
             Automatic, FontSize -> 11, FontWeight -> "Plain", FontColor -> 
             RGBColor[0.4, 0.2, 0.2], Background -> GrayLevel[0.999]], 
            Cell[
             StyleData[
             "TextAnnotation", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TextAnnotationButton"], Editable -> False, FontFamily -> 
             "Verdana", FontSize -> 9, 
             ButtonBoxOptions -> {
              Active -> True, Appearance -> "DialogBox", 
               ButtonFunction :> (Needs["DocuTools`"]; 
                DocuTools`GenerateAnnotationDialog[]), ButtonMargins -> 1, 
               Evaluator -> Automatic, Method -> "Queued"}], 
            Cell[
             StyleData[
             "TextAnnotationButton", "Printout", StyleDefinitions -> None]]}, 
           Closed]], 
         Cell[
          CellGroupData[{
            Cell[
             StyleData["TextAnnotationRemoveButton"], Editable -> False, 
             FontFamily -> "Verdana", FontSize -> 9, 
             ButtonBoxOptions -> {
              Active -> True, Appearance -> "DialogBox", 
               ButtonFunction :> (Needs["DocuTools`"]; 
                DocuTools`AnnotationRemove[
                 DocuTools`CalledFromFrameLabel -> True]), ButtonMargins -> 1,
                Evaluator -> Automatic, Method -> "Queued"}], 
            Cell[
             StyleData[
             "TextAnnotationRemoveButton", "Printout", StyleDefinitions -> 
              None]]}, Closed]]}, Closed]]}, Open]]}, 
  WindowSize -> {740, 867}, 
  WindowMargins -> {{76, Automatic}, {Automatic, 44}}, Visible -> False, 
  FrontEndVersion -> 
  "9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, 2013)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "MikaPhD"->{
  Cell[91514, 2232, 487, 9, 31, "Reference",
   CellTags->"MikaPhD"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"MikaPhD", 190031, 4404}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 254, 7, 51, "Title",
 InitializationCell->True],
Cell[836, 31, 217, 3, 25, "Author"],
Cell[CellGroupData[{
Cell[1078, 38, 168, 2, 57, "Section"],
Cell[1249, 42, 488, 11, 35, "Text",
 InitializationCell->True],
Cell[1740, 55, 280, 6, 20, "Text",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[2057, 66, 158, 3, 31, "Section",
 InitializationGroup->True],
Cell[2218, 71, 93, 1, 20, "Text",
 InitializationGroup->True],
Cell[2314, 74, 594, 10, 32, "Input",
 InitializationGroup->True],
Cell[CellGroupData[{
Cell[2933, 88, 150, 2, 51, "Subsection",
 InitializationGroup->True],
Cell[3086, 92, 9331, 167, 848, "Input",
 InitializationGroup->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[12454, 264, 64, 1, 51, "Subsection",
 InitializationGroup->True],
Cell[12521, 267, 197, 4, 32, "Input",
 InitializationGroup->True]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12767, 277, 90, 2, 31, "Section",
 InitializationCell->True,
 InitializationGroup->True],
Cell[12860, 281, 936, 32, 41, "Text",
 InitializationCell->True,
 InitializationGroup->True],
Cell[13799, 315, 285, 7, 33, "Input",
 InitializationGroup->True],
Cell[CellGroupData[{
Cell[14109, 326, 134, 3, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[14246, 331, 319, 8, 33, "Input",
 InitializationGroup->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[14602, 344, 87, 2, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[14692, 348, 782, 23, 35, "Text",
 InitializationCell->True,
 InitializationGroup->True],
Cell[15477, 373, 659, 16, 33, "Input",
 InitializationGroup->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[16173, 394, 94, 2, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[16270, 398, 306, 9, 36, "Input",
 InitializationGroup->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[16613, 412, 210, 4, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[16826, 418, 654, 17, 53, "Input",
 InitializationGroup->True],
Cell[17483, 437, 2298, 58, 153, "Input",
 InitializationGroup->True]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19830, 501, 158, 3, 31, "Section",
 InitializationCell->True,
 InitializationGroup->True],
Cell[CellGroupData[{
Cell[20013, 508, 215, 4, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[20231, 514, 1201, 26, 48, "Input",
 InitializationGroup->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[21469, 545, 175, 3, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[21647, 550, 4166, 125, 103, "Text",
 InitializationCell->True,
 InitializationGroup->True],
Cell[25816, 677, 3396, 86, 68, "Text",
 InitializationCell->True,
 InitializationGroup->True],
Cell[29215, 765, 9612, 224, 524, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[38864, 994, 225, 4, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[39092, 1000, 1664, 30, 20, "Text",
 InitializationCell->True,
 InitializationGroup->True],
Cell[40759, 1032, 2949, 68, 174, "Input",
 InitializationCell->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[43745, 1105, 274, 5, 51, "Subsection",
 InitializationCell->True,
 InitializationGroup->True],
Cell[44022, 1112, 1560, 27, 35, "Text",
 InitializationCell->True,
 InitializationGroup->True],
Cell[45585, 1141, 4104, 97, 230, "Input",
 InitializationCell->True]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49738, 1244, 110, 2, 31, "Section",
 InitializationGroup->True],
Cell[CellGroupData[{
Cell[49873, 1250, 110, 2, 51, "Subsection",
 InitializationGroup->True],
Cell[49986, 1254, 2290, 71, 61, "Text",
 InitializationCell->True,
 InitializationGroup->True],
Cell[52279, 1327, 391, 13, 38, "Input",
 InitializationCell->True]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52719, 1346, 152, 3, 31, "Section",
 InitializationGroup->True],
Cell[CellGroupData[{
Cell[52896, 1353, 110, 2, 51, "Subsection",
 InitializationGroup->True],
Cell[53009, 1357, 664, 17, 24, "Text",
 InitializationGroup->True],
Cell[53676, 1376, 3599, 90, 216, "Input",
 InitializationGroup->True],
Cell[57278, 1468, 1179, 40, 42, "Text",
 InitializationGroup->True],
Cell[58460, 1510, 8738, 186, 356, "Input",
 InitializationCell->True],
Cell[67201, 1698, 1222, 41, 42, "Text",
 InitializationGroup->True],
Cell[68426, 1741, 6720, 137, 272, "Input",
 InitializationCell->True],
Cell[75149, 1880, 15915, 326, 572, "Input",
 InitializationCell->True]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[91113, 2212, 127, 3, 31, "Section",
 InitializationCell->True,
 InitializationGroup->True],
Cell[91243, 2217, 96, 3, 32, "Input",
 InitializationCell->True],
Cell[91342, 2222, 103, 3, 32, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[91482, 2230, 29, 0, 31, "Section"],
Cell[91514, 2232, 487, 9, 31, "Reference",
 CellTags->"MikaPhD"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
