(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     18870,        576]
NotebookOptionsPosition[     15130,        464]
NotebookOutlinePosition[     16350,        496]
CellTagsIndexPosition[     16307,        493]
WindowTitle->RandomWalkWeb Package - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:guide/Mathematica"],
  FontSlant->"Italic"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE GUIDE", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Functions \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"AbsoluteLinkQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/AbsoluteLinkQ"], "\<\"BaseURL\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/BaseURL"], "\<\"DomainName\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/DomainName"], "\<\"EffectiveTLDNameQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"], "\<\"GetFavicon\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetFavicon"], "\<\"GetHyperlinks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetHyperlinks"], "\<\"GetSource\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetSource"], "\<\"GetStepData\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetStepData"], "\<\"Hostname\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/Hostname"], "\<\"LogMessage\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/LogMessage"], "\<\"PerformRandomWalks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/PerformRandomWalks"], "\<\"RandomWalkGraph\"\
\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkGraph"], "\<\"RandomWalkWeb\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkWeb"], "\<\"SiteRoot\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/SiteRoot"], "\<\"ToAbsoluteLink\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/ToAbsoluteLink"], "\<\"ToGraphData\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/ToGraphData"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"GuideFunction"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Data Visualization\"\>":>
       Documentation`HelpLookup[
       "paclet:guide/DataVisualization"], "\<\".NET Interface\"\>":>
       Documentation`HelpLookup[
       "paclet:NETLink/guide/DotNETInterface"], "\<\"Graphs & Networks\"\>":>
       Documentation`HelpLookup[
       "paclet:guide/GraphsAndNetworks"], "\<\"Random Number Generation\"\>":>
       Documentation`HelpLookup[
       "paclet:guide/RandomNumberGeneration"], "\<\"String Manipulation\"\>":>
       Documentation`HelpLookup[
       "paclet:guide/StringManipulation"], "\<\"Tuning & Debugging\"\>":>
       Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"GuideMoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->
         False], {"\<\"RandomWalkWeb/guide/RandomWalkWebPackage\"\>":>
       None, "\<\"Copy Mathematica URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/guide/RandomWalkWebPackage"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web URL\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/guide/RandomWalkWebPackage.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web URL\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/guide/RandomWalkWebPackage", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["RandomWalkWeb",
  FontSlant->"Italic"],
 " Package"
}], "GuideTitle",
 CellID->942062912],

Cell["\<\
This package contains functions to perform random walks on the World Wide Web \
and visualize the resulting data.\
\>", "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Data Collection and Visualization", "GuideFunctionsSubsection",
 CellID->1793354],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " perform a single random walk on the Web from the specified URL"
}], "GuideText",
 CellID->752087942],

Cell[TextData[{
 Cell[TextData[ButtonBox["PerformRandomWalks",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " perform multiple random walks on the Web"
}], "GuideText",
 CellID->189801587],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetStepData",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " gives a list of steps extracted from random walk data"
}], "GuideText",
 CellID->15497091],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToGraphData",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " converts step data to directed graph data"
}], "GuideText",
 CellID->437442337],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomWalkGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " constructs a graph from random walk data"
}], "GuideText",
 CellID->25564],

Cell[TextData[{
 Cell[TextData[ButtonBox["$BaseDataDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$DataFilePrefix",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/$DataFilePrefix"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexType",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/VertexType"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexIcon",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RefreshIconCache",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->254556927],

Cell["\t", "GuideDelimiterSubsection",
 CellID->760692962]
}, Open  ]],

Cell[CellGroupData[{

Cell["Web Page Components", "GuideFunctionsSubsection",
 CellID->909744156],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetSource",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/GetSource"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " gets the page source from the requested URL"
}], "GuideText",
 CellID->487851455],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetFavicon",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " gets the associated favorite icon"
}], "GuideText",
 CellID->588730865],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetHyperlinks",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " gives a list of extracted hyperlinks"
}], "GuideText",
 CellID->1056723523],

Cell[TextData[{
 Cell[TextData[ButtonBox["$Timeout",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/$Timeout"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$UserAgent",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/$UserAgent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HyperlinkType",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbsoluteLinks",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->862477258],

Cell["\t", "GuideDelimiterSubsection",
 CellID->156078931]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operations on URLs", "GuideFunctionsSubsection",
 CellID->131254545],

Cell[TextData[{
 Cell[TextData[ButtonBox["BaseURL",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/BaseURL"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SiteRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " gives the base or site root of the URL"
}], "GuideText",
 CellID->937479833],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hostname",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["DomainName",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " gives the hostname or domain name"
}], "GuideText",
 CellID->430430152],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToAbsoluteLink",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " converts hyperlink to fully qualified form"
}], "GuideText",
 CellID->342667447],

Cell[TextData[{
 Cell[TextData[ButtonBox["AbsoluteLinkQ",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " tests whether a URL is absolute"
}], "GuideText",
 CellID->100935950],

Cell[TextData[{
 Cell[TextData[ButtonBox["EffectiveTLDNameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$ETLDNInfo",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/$ETLDNInfo"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->178926622],

Cell["\t", "GuideDelimiterSubsection",
 CellID->364646287]
}, Open  ]],

Cell[CellGroupData[{

Cell["Message Logging", "GuideFunctionsSubsection",
 CellID->160426974],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogMessage",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/LogMessage"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " logs message with level of importance to a file"
}], "GuideText",
 CellID->584913780],

Cell[TextData[{
 Cell[TextData[ButtonBox["$LogFileName",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/$LogFileName"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$DebugLogging",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/ref/$DebugLogging"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->578180279]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox[".NET Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/guide/DotNETInterface"]], "GuideMoreAbout",
 CellID->72918142],

Cell[TextData[ButtonBox["Graphs & Networks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphsAndNetworks"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "GuideMoreAbout",
 CellID->870921039],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAbout",
 CellID->261547907],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "GuideMoreAbout",
 CellID->399806227]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomWalkWeb Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 26, 52.3831211}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Guide", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "This package contains functions to perform random walks on the World \
Wide Web and visualize the resulting data.", "synonyms" -> {}, "title" -> 
    "RandomWalkWeb Package", "type" -> "Guide", "uri" -> 
    "RandomWalkWeb/guide/RandomWalkWebPackage"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[614, 21, 75, 1, 3, "GuideColorBar"],
Cell[692, 24, 209, 6, 19, "LinkTrail"],
Cell[904, 32, 4889, 103, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[5818, 139, 116, 5, 66, "GuideTitle",
 CellID->942062912],
Cell[5937, 146, 167, 4, 81, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[6129, 154, 87, 1, 28, "GuideFunctionsSubsection",
 CellID->1793354],
Cell[6219, 157, 313, 9, 20, "GuideText",
 CellID->752087942],
Cell[6535, 168, 301, 9, 20, "GuideText",
 CellID->189801587],
Cell[6839, 179, 296, 8, 20, "GuideText",
 CellID->15497091],
Cell[7138, 189, 285, 8, 20, "GuideText",
 CellID->437442337],
Cell[7426, 199, 291, 9, 20, "GuideText",
 CellID->25564],
Cell[7720, 210, 1281, 36, 19, "InlineGuideFunctionListing",
 CellID->254556927],
Cell[9004, 248, 58, 1, 21, "GuideDelimiterSubsection",
 CellID->760692962]
}, Open  ]],
Cell[CellGroupData[{
Cell[9099, 254, 75, 1, 28, "GuideFunctionsSubsection",
 CellID->909744156],
Cell[9177, 257, 283, 8, 20, "GuideText",
 CellID->487851455],
Cell[9463, 267, 275, 8, 20, "GuideText",
 CellID->588730865],
Cell[9741, 277, 288, 9, 20, "GuideText",
 CellID->1056723523],
Cell[10032, 288, 988, 27, 19, "InlineGuideFunctionListing",
 CellID->862477258],
Cell[11023, 317, 58, 1, 21, "GuideDelimiterSubsection",
 CellID->156078931]
}, Open  ]],
Cell[CellGroupData[{
Cell[11118, 323, 74, 1, 28, "GuideFunctionsSubsection",
 CellID->131254545],
Cell[11195, 326, 415, 12, 20, "GuideText",
 CellID->937479833],
Cell[11613, 340, 416, 12, 20, "GuideText",
 CellID->430430152],
Cell[12032, 354, 295, 9, 20, "GuideText",
 CellID->342667447],
Cell[12330, 365, 282, 9, 20, "GuideText",
 CellID->100935950],
Cell[12615, 376, 480, 13, 19, "InlineGuideFunctionListing",
 CellID->178926622],
Cell[13098, 391, 58, 1, 21, "GuideDelimiterSubsection",
 CellID->364646287]
}, Open  ]],
Cell[CellGroupData[{
Cell[13193, 397, 71, 1, 28, "GuideFunctionsSubsection",
 CellID->160426974],
Cell[13267, 400, 289, 8, 20, "GuideText",
 CellID->584913780],
Cell[13559, 410, 473, 12, 70, "InlineGuideFunctionListing",
 CellID->578180279]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14081, 428, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[14146, 431, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[14302, 436, 153, 3, 70, "GuideMoreAbout",
 CellID->72918142],
Cell[14458, 441, 151, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[14612, 446, 163, 3, 70, "GuideMoreAbout",
 CellID->870921039],
Cell[14778, 451, 154, 3, 70, "GuideMoreAbout",
 CellID->261547907],
Cell[14935, 456, 153, 3, 70, "GuideMoreAbout",
 CellID->399806227]
}, Open  ]],
Cell[15103, 462, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

