(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     13649,        443]
NotebookOptionsPosition[     10389,        338]
NotebookOutlinePosition[     12091,        386]
CellTagsIndexPosition[     12006,        381]
WindowTitle->$BaseDataDirectory - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"PerformRandomWalks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/PerformRandomWalks"], "\<\"GetStepData\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetStepData"], "\<\"RandomWalkGraph\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkGraph"], "\<\"Directory\"\>":>
       Documentation`HelpLookup["paclet:ref/Directory"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Directories & \
Directory Operations\"\>":>Documentation`HelpLookup[
       "paclet:guide/DirectoriesAndDirectoryOperations"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/$BaseDataDirectory\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/$BaseDataDirectory"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/$BaseDataDirectory.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/$BaseDataDirectory", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["$BaseDataDirectory", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$BaseDataDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
      "InlineFormula"],
     "\[LineSeparator]gives the base data directory in which random walk data \
and favorite icons are placed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->7228798],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 " is set to the current working directory."
}], "Notes",
 CellID->581171297]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334018154],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39808307],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16987085],

Cell["The base data directory in which data files are placed:", "ExampleText",
 CellID->289952709],

Cell[CellGroupData[{

Cell[BoxData["$BaseDataDirectory"], "Input",
 CellLabel->"In[2]:=",
 CellID->532698615],

Cell[BoxData["\<\"E:\\\\Users\\\\$UserName\\\\Documents\"\>"], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->744616259]
}, Open  ]],

Cell["\<\
Set the base data directory to the main system directory for temporary files:\
\>", "ExampleText",
 CellID->21870263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$BaseDataDirectory", "=", "$TemporaryDirectory"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->104488195],

Cell[BoxData["\<\"C:\\\\Users\\\\$UserName\\\\AppData\\\\Local\\\\Temp\"\>"], \
"Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->161185181]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PerformRandomWalks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetStepData",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->115493557]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$BaseDataDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 39.1356866}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "$BaseDataDirectory gives the base data directory in which random walk \
data and favorite icons are placed.", "synonyms" -> {}, "title" -> 
    "$BaseDataDirectory", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/$BaseDataDirectory"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6230, 183, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->334018154]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11863, 374}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[611, 21, 76, 1, 3, "SymbolColorBar"],
Cell[690, 24, 209, 5, 19, "LinkTrail"],
Cell[902, 31, 3202, 71, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4129, 106, 61, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4193, 109, 496, 14, 83, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4726, 128, 578, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->7228798],
Cell[5307, 147, 617, 20, 70, "Notes",
 CellID->1067943069],
Cell[5927, 169, 266, 9, 70, "Notes",
 CellID->581171297]
}, Closed]],
Cell[CellGroupData[{
Cell[6230, 183, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334018154],
Cell[CellGroupData[{
Cell[6716, 200, 147, 5, 31, "ExampleSection",
 CellID->39808307],
Cell[6866, 207, 121, 3, 28, "Input",
 CellID->16987085],
Cell[6990, 212, 98, 1, 32, "ExampleText",
 CellID->289952709],
Cell[CellGroupData[{
Cell[7113, 217, 87, 2, 28, "Input",
 CellID->532698615],
Cell[7203, 221, 203, 5, 36, "Output",
 CellID->744616259]
}, Open  ]],
Cell[7421, 229, 127, 3, 32, "ExampleText",
 CellID->21870263],
Cell[CellGroupData[{
Cell[7573, 236, 127, 3, 28, "Input",
 CellID->104488195],
Cell[7703, 241, 220, 6, 36, "Output",
 CellID->161185181]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7984, 254, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[8404, 268, 1134, 38, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9575, 311, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[9997, 325, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[10168, 330, 179, 3, 17, "MoreAbout",
 CellID->115493557]
}, Open  ]],
Cell[10362, 336, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

