(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14490,        486]
NotebookOptionsPosition[     10955,        370]
NotebookOutlinePosition[     12589,        417]
CellTagsIndexPosition[     12504,        412]
WindowTitle->$LogFileName - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"LogMessage\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/LogMessage"], "\<\"$DebugLogging\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$DebugLogging"], \
"\<\"$BaseDataDirectory\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$BaseDataDirectory"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Operations on \
File Names\"\>":>Documentation`HelpLookup[
       "paclet:guide/OperationsOnFileNames"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/$LogFileName\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/$LogFileName"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/$LogFileName.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/$LogFileName", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["$LogFileName", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$LogFileName",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/$LogFileName"]], "InlineFormula"],
     "\[LineSeparator]is the fully qualified name of the log file."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->121114472],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["$LogFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$LogFileName"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["$LogFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$LogFileName"]], "InlineFormula"],
 " to ",
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 " disables message logging."
}], "Notes",
 CellID->168793049],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["$LogFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$LogFileName"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FileNameJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameJoin"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["$TemporaryDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$TemporaryDirectory"], ",", 
     "\"\<messages.log\>\""}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->556381240]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->502722065],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->486199664],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160216672],

Cell["The default log file name:", "ExampleText",
 CellID->283975085],

Cell[CellGroupData[{

Cell[BoxData["$LogFileName"], "Input",
 CellLabel->"In[2]:=",
 CellID->143840842],

Cell[BoxData["\<\"C:\\\\Users\\\\$UserName\\\\AppData\\\\Local\\\\Temp\\\\\
messages.log\"\>"], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->520668220]
}, Open  ]],

Cell["Set the log file name:", "ExampleText",
 CellID->309058203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$LogFileName", "=", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"$BaseDataDirectory", ",", "\"\<messages.log\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->235050879],

Cell[BoxData["\<\"E:\\\\Users\\\\$UserName\\\\Documents\\\\messages.log\"\>"],\
 "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19123930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342418885],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233897215],

Cell["Disable message logging:", "ExampleText",
 CellID->43910945],

Cell[BoxData[
 RowBox[{
  RowBox[{"$LogFileName", "=", "\"\<\>\""}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->482473309]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogMessage",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/LogMessage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DebugLogging",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$DebugLogging"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BaseDataDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Operations on File Names",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnFileNames"]], "MoreAbout",
 CellID->380833802]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$LogFileName - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 46.6656971}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "$LogFileName is the fully qualified name of the log file.", 
    "synonyms" -> {}, "title" -> "$LogFileName", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/$LogFileName"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6577, 200, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->502722065]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12361, 405}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[605, 21, 76, 1, 3, "SymbolColorBar"],
Cell[684, 24, 209, 5, 19, "LinkTrail"],
Cell[896, 31, 3043, 68, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3964, 103, 55, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4022, 106, 433, 12, 83, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4492, 123, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->121114472],
Cell[5075, 142, 602, 19, 70, "Notes",
 CellID->1067943069],
Cell[5680, 163, 286, 10, 70, "Notes",
 CellID->168793049],
Cell[5969, 175, 571, 20, 70, "Notes",
 CellID->556381240]
}, Closed]],
Cell[CellGroupData[{
Cell[6577, 200, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->502722065],
Cell[CellGroupData[{
Cell[7063, 217, 148, 5, 31, "ExampleSection",
 CellID->486199664],
Cell[7214, 224, 122, 3, 28, "Input",
 CellID->160216672],
Cell[7339, 229, 69, 1, 32, "ExampleText",
 CellID->283975085],
Cell[CellGroupData[{
Cell[7433, 234, 81, 2, 28, "Input",
 CellID->143840842],
Cell[7517, 238, 236, 6, 36, "Output",
 CellID->520668220]
}, Open  ]],
Cell[7768, 247, 65, 1, 32, "ExampleText",
 CellID->309058203],
Cell[CellGroupData[{
Cell[7858, 252, 231, 7, 28, "Input",
 CellID->235050879],
Cell[8092, 261, 220, 6, 36, "Output",
 CellID->19123930]
}, Open  ]],
Cell[CellGroupData[{
Cell[8349, 272, 125, 3, 8, "ExampleDelimiter",
 CellID->342418885],
Cell[8477, 277, 122, 3, 28, "Input",
 CellID->233897215],
Cell[8602, 282, 66, 1, 32, "ExampleText",
 CellID->43910945],
Cell[8671, 285, 128, 4, 28, "Input",
 CellID->482473309]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8860, 296, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[9280, 310, 846, 28, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10163, 343, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[10585, 357, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[10756, 362, 157, 3, 17, "MoreAbout",
 CellID->380833802]
}, Open  ]],
Cell[10928, 368, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

