(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     12431,        413]
NotebookOptionsPosition[      9289,        311]
NotebookOutlinePosition[     10937,        358]
CellTagsIndexPosition[     10852,        353]
WindowTitle->$Timeout - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"$UserAgent\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$UserAgent"], "\<\"GetSource\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetSource"], "\<\"GetFavicon\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/GetFavicon"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/$Timeout\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/$Timeout"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/$Timeout.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/$Timeout", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["$Timeout", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Timeout",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/$Timeout"]], "InlineFormula"],
     "\[LineSeparator]is the number of milliseconds to wait before a \
synchronous request times out."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->135131887],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["$Timeout",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$Timeout"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["$Timeout",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$Timeout"]], "InlineFormula"],
 " is set to 100,000 milliseconds."
}], "Notes",
 CellID->380133608]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->975824752],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->202950667],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200471172],

Cell["Typical setting for synchronous requests:", "ExampleText",
 CellID->54952402],

Cell[CellGroupData[{

Cell[BoxData["$Timeout"], "Input",
 CellLabel->"In[2]:=",
 CellID->490413811],

Cell[BoxData["100000"], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->411248966]
}, Open  ]],

Cell["Change the timeout duration to half a minute:", "ExampleText",
 CellID->886382257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$Timeout", "=", "30000"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->584244057],

Cell[BoxData["30000"], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2736981]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserAgent",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$UserAgent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetSource",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetSource"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetFavicon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Timeout - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 48.5156997}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "$Timeout is the number of milliseconds to wait before a synchronous \
request times out.", "synonyms" -> {}, "title" -> "$Timeout", "type" -> 
    "Symbol", "uri" -> "RandomWalkWeb/ref/$Timeout"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5810, 174, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->975824752]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10709, 346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[601, 21, 76, 1, 3, "SymbolColorBar"],
Cell[680, 24, 209, 5, 19, "LinkTrail"],
Cell[892, 31, 2891, 65, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3808, 100, 51, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[3862, 103, 460, 13, 83, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4359, 121, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->135131887],
Cell[4942, 140, 594, 19, 70, "Notes",
 CellID->1067943069],
Cell[5539, 161, 234, 8, 70, "Notes",
 CellID->380133608]
}, Closed]],
Cell[CellGroupData[{
Cell[5810, 174, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->975824752],
Cell[CellGroupData[{
Cell[6296, 191, 148, 5, 31, "ExampleSection",
 CellID->202950667],
Cell[6447, 198, 122, 3, 28, "Input",
 CellID->200471172],
Cell[6572, 203, 83, 1, 32, "ExampleText",
 CellID->54952402],
Cell[CellGroupData[{
Cell[6680, 208, 77, 2, 28, "Input",
 CellID->490413811],
Cell[6760, 212, 163, 5, 36, "Output",
 CellID->411248966]
}, Open  ]],
Cell[6938, 220, 88, 1, 32, "ExampleText",
 CellID->886382257],
Cell[CellGroupData[{
Cell[7051, 225, 103, 3, 28, "Input",
 CellID->584244057],
Cell[7157, 230, 160, 5, 36, "Output",
 CellID->2736981]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7378, 242, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[7798, 256, 822, 28, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8657, 289, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[9079, 303, 168, 3, 17, "MoreAbout",
 CellID->1665078683]
}, Open  ]],
Cell[9262, 309, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

