(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16290,        543]
NotebookOptionsPosition[     12683,        425]
NotebookOutlinePosition[     14358,        472]
CellTagsIndexPosition[     14273,        467]
WindowTitle->AbsoluteLinkQ - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ToAbsoluteLink\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/ToAbsoluteLink"], "\<\"BaseURL\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/BaseURL"], "\<\"Hostname\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/Hostname"], "\<\"DomainName\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/DomainName"], "\<\"SiteRoot\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/SiteRoot"], "\<\"GetHyperlinks\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/GetHyperlinks"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], \
"\<\"Conditionals\"\>":>Documentation`HelpLookup[
       "paclet:guide/Conditionals"], "\<\"Testing Expressions\"\>":>
       Documentation`HelpLookup["paclet:guide/TestingExpressions"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/AbsoluteLinkQ\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/AbsoluteLinkQ"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/AbsoluteLinkQ.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/AbsoluteLinkQ", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["AbsoluteLinkQ", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteLinkQ",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     " is a fully qualified link, and gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->25253953],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["AbsoluteLinkQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteLinkQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474137417],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->635881113],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5613922],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteLinkQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"]], "InlineFormula"],
 " tests whether a URL is explicitly absolute:"
}], "ExampleText",
 CellID->505533659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteLinkQ", "[", "\"\<http://www.example.net/\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159732364],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->525642729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteLinkQ", "[", "\"\<./page2.html\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22261585],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->331272149]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteLinkQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteLinkQ", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<http://www.example.net/\>\"", ",", "\"\<./page2.html\>\""}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581462386]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAbsoluteLink",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseURL",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/BaseURL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hostname",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/Hostname"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DomainName",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/DomainName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SiteRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetHyperlinks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->76740964],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->5206587]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteLinkQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 26, 54.4331240}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "AbsoluteLinkQ[\"url\"] gives True if \"url\" is a fully qualified link, \
and gives False otherwise.", "synonyms" -> {}, "title" -> "AbsoluteLinkQ", 
    "type" -> "Symbol", "uri" -> "RandomWalkWeb/ref/AbsoluteLinkQ"}, 
  "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6783, 197, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->474137417]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14130, 460}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[606, 21, 76, 1, 3, "SymbolColorBar"],
Cell[685, 24, 209, 5, 19, "LinkTrail"],
Cell[897, 31, 3419, 75, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4341, 110, 56, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4400, 113, 892, 27, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5329, 145, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->25253953],
Cell[5911, 164, 604, 19, 70, "Notes",
 CellID->1067943069],
Cell[6518, 185, 228, 7, 70, "Notes",
 CellID->12607960]
}, Closed]],
Cell[CellGroupData[{
Cell[6783, 197, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474137417],
Cell[CellGroupData[{
Cell[7269, 214, 148, 5, 31, "ExampleSection",
 CellID->635881113],
Cell[7420, 221, 120, 3, 28, "Input",
 CellID->5613922],
Cell[7543, 226, 245, 7, 34, "ExampleText",
 CellID->505533659],
Cell[CellGroupData[{
Cell[7813, 237, 142, 4, 28, "Input",
 CellID->159732364],
Cell[7958, 243, 161, 5, 36, "Output",
 CellID->525642729]
}, Open  ]],
Cell[CellGroupData[{
Cell[8156, 253, 127, 3, 28, "Input",
 CellID->22261585],
Cell[8286, 258, 162, 5, 36, "Output",
 CellID->331272149]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8497, 269, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[8721, 278, 122, 3, 70, "Input",
 CellID->139972119],
Cell[8846, 283, 234, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[9105, 294, 209, 6, 70, "Input",
 CellID->475944353],
Cell[9317, 302, 210, 7, 70, "Output",
 CellID->581462386]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9588, 316, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[10008, 330, 1718, 58, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11763, 393, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[12185, 407, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[12356, 412, 135, 3, 17, "MoreAbout",
 CellID->76740964],
Cell[12494, 417, 147, 3, 17, "MoreAbout",
 CellID->5206587]
}, Open  ]],
Cell[12656, 423, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

