(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16162,        499]
NotebookOptionsPosition[     12834,        392]
NotebookOutlinePosition[     14533,        440]
CellTagsIndexPosition[     14448,        435]
WindowTitle->AbsoluteLinks - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"HyperlinkType\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/HyperlinkType"], "\<\"AbsoluteLinkQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/AbsoluteLinkQ"], "\<\"ToAbsoluteLink\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/ToAbsoluteLink"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Options \
Management\"\>":>Documentation`HelpLookup["paclet:guide/OptionsManagement"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/AbsoluteLinks\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/AbsoluteLinks"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/AbsoluteLinks.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/AbsoluteLinks", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["AbsoluteLinks", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AbsoluteLinks",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"]], 
      "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["GetHyperlinks",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], 
      "InlineFormula"],
     " that specifies whether links should be converted to fully qualified \
form."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->397161860],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["AbsoluteLinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteLinks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"], " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " converts all relative links to absolute links."
}], "Notes",
 CellID->26365346],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteLinks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"], " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " disables conversion."
}], "Notes",
 CellID->362121298]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->519294853],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->498293374],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->763817438],

Cell["Convert all relative links to absolute links:", "ExampleText",
 CellID->513209570],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"address", ",", "source"}], "}"}], "=", 
   RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"AbsoluteLinks", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->24396138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"http://wolfram.com/index.ko.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ja.html\"\>", 
   ",", "\<\"http://wolfram.com/index.pt-br.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ru.html\"\>", 
   ",", "\<\"http://wolfram.com/news/newsletter/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/system-modeler/\"\>"}], "}"}]], "Output",
 ImageSize->{503, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253360142]
}, Open  ]],

Cell["Disable conversion:", "ExampleText",
 CellID->31699516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"AbsoluteLinks", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->644651139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"index.ko.html\"\>", ",", "\<\"index.ja.html\"\>", 
   ",", "\<\"index.pt-br.html\"\>", ",", "\<\"index.ru.html\"\>", 
   ",", "\<\"/news/newsletter/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/system-modeler/\"\>"}], 
  "}"}]], "Output",
 ImageSize->{519, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14459874]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HyperlinkType",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteLinkQ",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAbsoluteLink",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->363792060]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteLinks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 26, 56.4331268}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "AbsoluteLinks is an option to GetHyperlinks that specifies whether links \
should be converted to fully qualified form.", "synonyms" -> {}, "title" -> 
    "AbsoluteLinks", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/AbsoluteLinks"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6631, 199, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->519294853]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14305, 428}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[606, 21, 76, 1, 3, "SymbolColorBar"],
Cell[685, 24, 209, 5, 19, "LinkTrail"],
Cell[897, 31, 3033, 67, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3955, 102, 56, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4014, 105, 665, 20, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4716, 130, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->397161860],
Cell[5299, 149, 604, 19, 70, "Notes",
 CellID->1067943069],
Cell[5906, 170, 354, 11, 70, "Notes",
 CellID->26365346],
Cell[6263, 183, 331, 11, 70, "Notes",
 CellID->362121298]
}, Closed]],
Cell[CellGroupData[{
Cell[6631, 199, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->519294853],
Cell[CellGroupData[{
Cell[7117, 216, 148, 5, 31, "ExampleSection",
 CellID->498293374],
Cell[7268, 223, 122, 3, 28, "Input",
 CellID->763817438],
Cell[7393, 228, 88, 1, 32, "ExampleText",
 CellID->513209570],
Cell[CellGroupData[{
Cell[7506, 233, 376, 11, 47, "Input",
 CellID->24396138],
Cell[7885, 246, 1352, 27, 224, "Output",
 CellID->253360142]
}, Open  ]],
Cell[9252, 276, 61, 1, 32, "ExampleText",
 CellID->31699516],
Cell[CellGroupData[{
Cell[9338, 281, 199, 5, 28, "Input",
 CellID->644651139],
Cell[9540, 288, 1150, 23, 173, "Output",
 CellID->14459874]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10751, 318, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[11171, 332, 844, 28, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12052, 365, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[12474, 379, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[12645, 384, 147, 3, 17, "MoreAbout",
 CellID->363792060]
}, Open  ]],
Cell[12807, 390, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

