(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     19614,        675]
NotebookOptionsPosition[     15242,        527]
NotebookOutlinePosition[     16865,        574]
CellTagsIndexPosition[     16780,        569]
WindowTitle->DomainName - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"EffectiveTLDNameQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"], "\<\"AbsoluteLinkQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/AbsoluteLinkQ"], "\<\"BaseURL\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/BaseURL"], "\<\"LogMessage\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/LogMessage"], "\<\"ToAbsoluteLink\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/ToAbsoluteLink"], "\<\"SiteRoot\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/SiteRoot"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"String \
Manipulation\"\>":>Documentation`HelpLookup[
       "paclet:guide/StringManipulation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/DomainName\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/DomainName"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/DomainName.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/DomainName", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["DomainName", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DomainName",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/DomainName"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the domain name of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->641655357],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 " returns the equivalent of ",
 Cell[BoxData[
  ButtonBox["Hostname",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFormula"],
 " if the effective TLD cannot be determined.  If message logging is enabled, \
",
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 " logs the error and hostname for later review."
}], "Notes",
 CellID->154336435],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 " is not a fully qualified (i.e., absolute) URL."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->307887866],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->382722615],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->471743825],

Cell["Return the domain name of the specified URL:", "ExampleText",
 CellID->23876287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DomainName", "[", "\"\<http://www.example.net/dir1/page1.html\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->341821582],

Cell[BoxData["\<\"example.net\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154565044]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DomainName", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<http://www.example.net/dir1/page1.html\>\"", ",", 
    "\"\<http://www.example.net/dir1/subdir1/\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"example.net\"\>", ",", "\<\"example.net\"\>"}], 
  "}"}]], "Output",
 ImageSize->{183, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68676216]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187280277],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 " returns the equivalent of ",
 Cell[BoxData[
  ButtonBox["Hostname",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFormula"],
 " if the effective TLD cannot be determined:"
}], "ExampleText",
 CellID->229029428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DomainName", "[", "\"\<http://www.example.zzz/dir1/page1.html\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60127390],

Cell[BoxData["\<\"www.example.zzz\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173107829]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hostname", "[", "\"\<http://www.example.zzz/dir1/page1.html\>\"", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->213258232],

Cell[BoxData["\<\"www.example.zzz\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->724205871]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59480247],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193774557],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DomainName",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/DomainName"]], "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->467400294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DomainName", "[", "\"\<./page2.html\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->249914984],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102717211]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EffectiveTLDNameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteLinkQ",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseURL",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/BaseURL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogMessage",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/LogMessage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAbsoluteLink",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SiteRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->333683230]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DomainName - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 0.2431321}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "DomainName[\"url\"] gives the domain name of \"url\".", "synonyms" -> {},
     "title" -> "DomainName", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/DomainName"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7453, 223, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->307887866]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16637, 562}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[603, 21, 76, 1, 3, "SymbolColorBar"],
Cell[682, 24, 209, 5, 19, "LinkTrail"],
Cell[894, 31, 3338, 74, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4257, 109, 53, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4313, 112, 579, 17, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4929, 134, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->641655357],
Cell[5512, 153, 598, 19, 70, "Notes",
 CellID->1067943069],
Cell[6113, 174, 222, 7, 70, "Notes",
 CellID->12607960],
Cell[6338, 183, 620, 18, 70, "Notes",
 CellID->154336435],
Cell[6961, 203, 455, 15, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[7453, 223, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->307887866],
Cell[CellGroupData[{
Cell[7939, 240, 148, 5, 31, "ExampleSection",
 CellID->382722615],
Cell[8090, 247, 122, 3, 28, "Input",
 CellID->471743825],
Cell[8215, 252, 86, 1, 32, "ExampleText",
 CellID->23876287],
Cell[CellGroupData[{
Cell[8326, 257, 154, 4, 28, "Input",
 CellID->341821582],
Cell[8483, 263, 176, 5, 36, "Output",
 CellID->154565044]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8708, 274, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[8932, 283, 122, 3, 70, "Input",
 CellID->139972119],
Cell[9057, 288, 228, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[9310, 299, 250, 7, 70, "Input",
 CellID->475944353],
Cell[9563, 308, 242, 8, 70, "Output",
 CellID->68676216]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9854, 322, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[10088, 331, 122, 3, 70, "Input",
 CellID->187280277],
Cell[10213, 336, 403, 12, 70, "ExampleText",
 CellID->229029428],
Cell[CellGroupData[{
Cell[10641, 352, 153, 4, 70, "Input",
 CellID->60127390],
Cell[10797, 358, 181, 5, 70, "Output",
 CellID->173107829]
}, Open  ]],
Cell[CellGroupData[{
Cell[11015, 368, 152, 4, 70, "Input",
 CellID->213258232],
Cell[11170, 374, 181, 5, 70, "Output",
 CellID->724205871]
}, Open  ]],
Cell[CellGroupData[{
Cell[11388, 384, 124, 3, 70, "ExampleDelimiter",
 CellID->59480247],
Cell[11515, 389, 122, 3, 70, "Input",
 CellID->193774557],
Cell[11640, 394, 235, 7, 70, "ExampleText",
 CellID->467400294],
Cell[CellGroupData[{
Cell[11900, 405, 125, 3, 70, "Input",
 CellID->249914984],
Cell[12028, 410, 164, 5, 70, "Output",
 CellID->102717211]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12265, 423, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[12685, 437, 1736, 58, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[14458, 500, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[14880, 514, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[15051, 519, 149, 3, 17, "MoreAbout",
 CellID->333683230]
}, Open  ]],
Cell[15215, 525, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

