(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16166,        548]
NotebookOptionsPosition[     12294,        421]
NotebookOutlinePosition[     14000,        469]
CellTagsIndexPosition[     13915,        464]
WindowTitle->EffectiveTLDNameQ - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"$ETLDNInfo\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$ETLDNInfo"], "\<\"MemberQ\"\>":>
       Documentation`HelpLookup["paclet:ref/MemberQ"], "\<\"DomainName\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/DomainName"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], \
"\<\"Conditionals\"\>":>Documentation`HelpLookup[
       "paclet:guide/Conditionals"], "\<\"Testing Expressions\"\>":>
       Documentation`HelpLookup["paclet:guide/TestingExpressions"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/EffectiveTLDNameQ\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/EffectiveTLDNameQ"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/EffectiveTLDNameQ.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/EffectiveTLDNameQ", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["EffectiveTLDNameQ", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EffectiveTLDNameQ",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"], "[", 
       "\"\<\!\(\*
StyleBox[\"tld\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"tld\", \"TI\"]\)\>\""], "InlineFormula"],
     " is a known effective top-level domain, and gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->70053405],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["EffectiveTLDNameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"]], 
  "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EffectiveTLDNameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"]], 
  "InlineFormula"],
 " searches an in-memory lookup table for ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"tld\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->425314241],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EffectiveTLDNameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"]], 
  "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48829705],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->380522351],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409933951],

Cell["\<\
Test whether the string is a known effective top-level domain:\
\>", "ExampleText",
 CellID->359456046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EffectiveTLDNameQ", "[", "\"\<net\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->265328764],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105872813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EffectiveTLDNameQ", "[", "\"\<zzz\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->663249112],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->510784063]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EffectiveTLDNameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/EffectiveTLDNameQ"]], 
  "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EffectiveTLDNameQ", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<net\>\"", ",", "\"\<zzz\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112328300]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ETLDNInfo",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$ETLDNInfo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DomainName",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/DomainName"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->76740964],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->5206587]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[ButtonBox["Public Suffix List",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://publicsuffix.org/"], None}]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EffectiveTLDNameQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 2.0831347}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "EffectiveTLDNameQ[\"tld\"] gives True if \"tld\" is a known effective \
top-level domain, and gives False otherwise.", "synonyms" -> {}, "title" -> 
    "EffectiveTLDNameQ", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/EffectiveTLDNameQ"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6846, 205, 460, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->48829705]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13773, 457}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[610, 21, 76, 1, 3, "SymbolColorBar"],
Cell[689, 24, 209, 5, 19, "LinkTrail"],
Cell[901, 31, 3090, 67, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4016, 102, 60, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4079, 105, 920, 28, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5036, 138, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->70053405],
Cell[5618, 157, 615, 20, 70, "Notes",
 CellID->1067943069],
Cell[6236, 179, 331, 11, 70, "Notes",
 CellID->425314241],
Cell[6570, 192, 239, 8, 70, "Notes",
 CellID->12607960]
}, Closed]],
Cell[CellGroupData[{
Cell[6846, 205, 460, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48829705],
Cell[CellGroupData[{
Cell[7331, 222, 148, 5, 31, "ExampleSection",
 CellID->380522351],
Cell[7482, 229, 122, 3, 28, "Input",
 CellID->409933951],
Cell[7607, 234, 113, 3, 32, "ExampleText",
 CellID->359456046],
Cell[CellGroupData[{
Cell[7745, 241, 123, 3, 28, "Input",
 CellID->265328764],
Cell[7871, 246, 161, 5, 36, "Output",
 CellID->105872813]
}, Open  ]],
Cell[CellGroupData[{
Cell[8069, 256, 123, 3, 28, "Input",
 CellID->663249112],
Cell[8195, 261, 162, 5, 36, "Output",
 CellID->510784063]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8406, 272, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[8630, 281, 122, 3, 70, "Input",
 CellID->139972119],
Cell[8755, 286, 245, 8, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[9025, 298, 180, 5, 70, "Input",
 CellID->475944353],
Cell[9208, 305, 210, 7, 70, "Output",
 CellID->112328300]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9479, 319, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[9899, 333, 804, 28, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10740, 366, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[11162, 380, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[11333, 385, 135, 3, 17, "MoreAbout",
 CellID->76740964],
Cell[11471, 390, 147, 3, 17, "MoreAbout",
 CellID->5206587]
}, Open  ]],
Cell[CellGroupData[{
Cell[11655, 398, 427, 12, 45, "RelatedLinksSection",
 CellID->1584193535],
Cell[12085, 412, 167, 4, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[12267, 419, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

