(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     24113,        741]
NotebookOptionsPosition[     19677,        595]
NotebookOutlinePosition[     21449,        644]
CellTagsIndexPosition[     21364,        639]
WindowTitle->GetFavicon - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"GetSource\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetSource"], "\<\"$UserAgent\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$UserAgent"], "\<\"$Timeout\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/$Timeout"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Basic Image \
Manipulation\"\>":>Documentation`HelpLookup[
       "paclet:guide/BasicImageManipulation"], "\<\".NET Interface\"\>":>
       Documentation`HelpLookup["paclet:NETLink/guide/DotNETInterface"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/GetFavicon\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/GetFavicon"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/GetFavicon.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/GetFavicon", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["GetFavicon", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GetFavicon",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gets the favorite icon associated with the requested ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     ".  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GetFavicon",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"address\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gets the favorite icon associated with the specified ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"address\", \"TI\"]\)\>\""], "InlineFormula"],
     " and ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->211768597],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["GetFavicon",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GetFavicon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " returns the responding address in addition to the favorite icon."
}], "Notes",
 CellID->83648684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetFavicon",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetFavicon",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it is unable to complete the request."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213108247],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->12020943],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8210132],

Cell["Get the favorite icon associated with the requested URL:", "ExampleText",
 CellID->528100595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetFavicon", "[", "\"\<http://wolfram.com/\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283564397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://wolfram.com/\"\>", ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
      "], {{0, 16}, {16, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{16, 16},
    PlotRange->{{0, 16}, {0, 16}}]}], "}"}]], "Output",
 ImageSize->{180, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41685132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->225615962],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4683642],

Cell["\<\
Get the favorite icon associated with the specified page source:\
\>", "ExampleText",
 CellID->44296734],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"address", ",", "source"}], "}"}], "=", 
   RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"GetFavicon", "[", 
  RowBox[{"address", ",", "source"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->129877221],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
    "], {{0, 16}, {16, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSizeRaw->{16, 16},
  PlotRange->{{0, 16}, {0, 16}}]], "Output",
 ImageSize->{20, 16},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32271481]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetFavicon",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetFavicon", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<http://wolfram.com/\>\"", ",", "\"\<http://wolframscience.com/\>\""}],
    "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"http://wolfram.com/\"\>", ",", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"http://wolframscience.com/\"\>", ",", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{429, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202279266]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255766292],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetFavicon",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"]], "InlineFormula"],
 " may be unable to complete the request:"
}], "ExampleText",
 CellID->37306969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetFavicon", "[", "\"\<http://www.example.zzz/\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190207709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.example.zzz/\"\>", ",", "$Failed"}], 
  "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->766954427]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetSource",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetSource"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserAgent",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$UserAgent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Timeout",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$Timeout"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Basic Image Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicImageManipulation"]], "MoreAbout",
 CellID->154294022],

Cell[TextData[ButtonBox[".NET Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/guide/DotNETInterface"]], "MoreAbout",
 CellID->62574990]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetFavicon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 4.1731376}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "GetFavicon[\"url\"] gets the favorite icon associated with the requested \
\"url\". GetFavicon[\"address\", \"source\"] gets the favorite icon \
associated with the specified \"address\" and \"source\".", "synonyms" -> {}, 
    "title" -> "GetFavicon", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/GetFavicon"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7481, 222, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->213108247]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21221, 632}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[603, 21, 76, 1, 3, "SymbolColorBar"],
Cell[682, 24, 209, 5, 19, "LinkTrail"],
Cell[894, 31, 3106, 68, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4025, 103, 53, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4081, 106, 1228, 34, 146, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5346, 145, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->211768597],
Cell[5929, 164, 598, 19, 70, "Notes",
 CellID->1067943069],
Cell[6530, 185, 325, 9, 70, "Notes",
 CellID->83648684],
Cell[6858, 196, 222, 7, 70, "Notes",
 CellID->12607960],
Cell[7083, 205, 361, 12, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[7481, 222, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213108247],
Cell[CellGroupData[{
Cell[7967, 239, 147, 5, 31, "ExampleSection",
 CellID->12020943],
Cell[8117, 246, 120, 3, 28, "Input",
 CellID->8210132],
Cell[8240, 251, 99, 1, 32, "ExampleText",
 CellID->528100595],
Cell[CellGroupData[{
Cell[8364, 256, 132, 3, 28, "Input",
 CellID->283564397],
Cell[8499, 261, 1565, 33, 40, "Output",
 CellID->41685132]
}, Open  ]],
Cell[CellGroupData[{
Cell[10101, 299, 125, 3, 8, "ExampleDelimiter",
 CellID->225615962],
Cell[10229, 304, 120, 3, 28, "Input",
 CellID->4683642],
Cell[10352, 309, 114, 3, 32, "ExampleText",
 CellID->44296734],
Cell[CellGroupData[{
Cell[10491, 316, 319, 10, 47, "Input",
 CellID->129877221],
Cell[10813, 328, 1475, 31, 37, "Output",
 CellID->32271481]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12349, 366, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[12573, 375, 122, 3, 70, "Input",
 CellID->139972119],
Cell[12698, 380, 228, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[12951, 391, 220, 7, 70, "Input",
 CellID->475944353],
Cell[13174, 400, 3175, 65, 70, "Output",
 CellID->202279266]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16398, 471, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[16632, 480, 122, 3, 70, "Input",
 CellID->255766292],
Cell[16757, 485, 233, 7, 70, "ExampleText",
 CellID->37306969],
Cell[CellGroupData[{
Cell[17015, 496, 136, 3, 70, "Input",
 CellID->190207709],
Cell[17154, 501, 243, 8, 70, "Output",
 CellID->766954427]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17458, 516, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[17878, 530, 818, 28, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[18733, 563, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[19155, 577, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[19326, 582, 158, 3, 17, "MoreAbout",
 CellID->154294022],
Cell[19487, 587, 148, 3, 17, "MoreAbout",
 CellID->62574990]
}, Open  ]],
Cell[19650, 593, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

