(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     34744,       1060]
NotebookOptionsPosition[     29345,        880]
NotebookOutlinePosition[     31056,        928]
CellTagsIndexPosition[     30971,        923]
WindowTitle->GetHyperlinks - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"GetSource\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetSource"], "\<\"Flatten\"\>":>
       Documentation`HelpLookup[
       "paclet:ref/Flatten"], "\<\"RandomWalkWeb\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkWeb"], "\<\"ToAbsoluteLink\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/ToAbsoluteLink"], "\<\"GatherBy\"\>":>
       Documentation`HelpLookup[
       "paclet:ref/GatherBy"], "\<\"AbsoluteLinkQ\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/AbsoluteLinkQ"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"List \
Manipulation\"\>":>Documentation`HelpLookup["paclet:guide/ListManipulation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/GetHyperlinks\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/GetHyperlinks"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/GetHyperlinks.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/GetHyperlinks", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["GetHyperlinks", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GetHyperlinks",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"address\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of hyperlinks extracted from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\""], "InlineFormula"],
     " located at the specified ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"address\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->614324166],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["GetHyperlinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetHyperlinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], "InlineFormula"],
 " supports the following options:"
}], "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AbsoluteLinks",
     BaseStyle->"Link",
     ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to convert links to fully qualified form", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}}],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetHyperlinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], "InlineFormula"],
 " supports a ",
 Cell[BoxData[
  ButtonBox["HyperlinkType",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"]], "InlineFormula"],
 " option which determines the type of hyperlinks returned.  Possible \
settings include:"
}], "Notes",
 CellID->13890002],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Raw\>\"", Cell[
    "returns all extracted links", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Selected\>\"", Cell["\<\
uses internal selection criteria to remove JavaScript and SMTP links\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->629461856],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetHyperlinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->223313794],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HyperlinkType",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"], " ", "->", " ", 
   "\"\<Raw\>\""}]], "InlineFormula"],
 ", the value of ",
 Cell[BoxData[
  ButtonBox["AbsoluteLinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"]], "InlineFormula"],
 " is ignored."
}], "Notes",
 CellID->55472200]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1048460619],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->71240145],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89166275],

Cell["\<\
Get a list of hyperlinks extracted from the specified page source:\
\>", "ExampleText",
 CellID->413594937],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"address", ",", "source"}], "}"}], "=", 
   RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->449355338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"http://wolfram.com/index.ko.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ja.html\"\>", 
   ",", "\<\"http://wolfram.com/index.pt-br.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ru.html\"\>", 
   ",", "\<\"http://wolfram.com/news/newsletter/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/system-modeler/\"\>"}], "}"}]], "Output",
 ImageSize->{503, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5448899]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetHyperlinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[BoxData[{
 RowBox[{
  RowBox[{"source", "=", 
   RowBox[{"GetSource", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<http://wolfram.com/\>\"", ",", 
      "\"\<http://wolframscience.com/\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"addresses", ",", "sources"}], "}"}], "=", 
   RowBox[{"GatherBy", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", "source", "]"}], ",", "AbsoluteLinkQ"}], "]"}]}],
   ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->139208013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"addresses", ",", "sources"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"http://www.wolfram.com/\"\>", 
     ",", "\<\"http://www.wolfram.com/products/\"\>", 
     ",", "\<\"http://www.wolfram.com/products/\"\>", 
     ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
     ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
     ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
     ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
     ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
     ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
     ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
     RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
     ",", "\<\"http://wolfram.com/index.ko.html\"\>", 
     ",", "\<\"http://wolfram.com/index.ja.html\"\>", 
     ",", "\<\"http://wolfram.com/index.pt-br.html\"\>", 
     ",", "\<\"http://wolfram.com/index.ru.html\"\>", 
     ",", "\<\"http://wolfram.com/news/newsletter/\"\>", 
     ",", "\<\"http://wolfram.com/connect/\"\>", 
     ",", "\<\"http://wolfram.com/connect/\"\>", 
     ",", "\<\"http://wolfram.com/connect/\"\>", 
     ",", "\<\"http://wolfram.com/connect/\"\>", 
     ",", "\<\"http://wolfram.com/system-modeler/\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"http://wolframscience.com/\"\>", 
     ",", "\<\"http://wolframscience.com/nksonline/\"\>", 
     ",", "\<\"http://wolframscience.com/order/\"\>", 
     ",", "\<\"http://wolframscience.com/downloads/\"\>", 
     ",", "\<\"http://wolframscience.com/reference/\"\>", 
     ",", "\<\"http://wolframscience.com/news/\"\>", 
     ",", "\<\"http://forum.wolframscience.com/\"\>", 
     ",", "\<\"http://wolframscience.com/nksonline/toc.html\"\>", 
     ",", "\<\"http://www.wolfram-media.com/products/nksipad.html\"\>", 
     ",", "\<\"http://wolframscience.com/thebook.html\"\>", ",", 
     RowBox[{"\[LeftSkeleton]", "5", "\[RightSkeleton]"}], 
     ",", "\<\"http://www.wolframalpha.com/\"\>", 
     ",", "\<\"http://tones.wolfram.com/\"\>", 
     ",", "\<\"http://wolframscience.com/prizes/tm23/\"\>", 
     ",", "\<\"http://wolframscience.com/reference/bibliography.html\"\>", 
     ",", "\<\"http://wolframscience.com/openproblems/NKSOpenProblems.pdf\"\>\
", ",", "\<\"http://www.complex-systems.com/\"\>", 
     ",", "\<\"http://www.stephenwolfram.com\"\>", 
     ",", "\<\"http://www.wolfram.com\"\>", 
     ",", "\<\"http://wolframscience.com/guestbook/\"\>", 
     ",", "\<\"http://wolframscience.com/contact/\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{572, 407},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->131155986]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AbsoluteLinks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->763817438],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GetHyperlinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], "InlineFormula"],
 " converts links to fully qualified form:"
}], "ExampleText",
 CellID->513209570],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"address", ",", "source"}], "}"}], "=", 
   RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"AbsoluteLinks", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->24396138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"http://wolfram.com/index.ko.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ja.html\"\>", 
   ",", "\<\"http://wolfram.com/index.pt-br.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ru.html\"\>", 
   ",", "\<\"http://wolfram.com/news/newsletter/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/system-modeler/\"\>"}], "}"}]], "Output",
 ImageSize->{503, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253360142]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteLinks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"], " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " to disable conversion:"
}], "ExampleText",
 CellID->31699516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"AbsoluteLinks", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->644651139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"index.ko.html\"\>", ",", "\<\"index.ja.html\"\>", 
   ",", "\<\"index.pt-br.html\"\>", ",", "\<\"index.ru.html\"\>", 
   ",", "\<\"/news/newsletter/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/system-modeler/\"\>"}], 
  "}"}]], "Output",
 ImageSize->{519, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14459874]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "HyperlinkType",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25669242],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GetHyperlinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], "InlineFormula"],
 " uses internal selection criteria to remove JavaScript and SMTP links:"
}], "ExampleText",
 CellID->334081550],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"address", ",", "source"}], "}"}], "=", 
   RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"HyperlinkType", "\[Rule]", "\"\<Selected\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->712061981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"http://wolfram.com/index.ko.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ja.html\"\>", 
   ",", "\<\"http://wolfram.com/index.pt-br.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ru.html\"\>", 
   ",", "\<\"http://wolfram.com/news/newsletter/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/system-modeler/\"\>"}], "}"}]], "Output",
 ImageSize->{503, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17828767]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HyperlinkType",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"], " ", "->", " ", 
   "\"\<Raw\>\""}]], "InlineFormula"],
 " to get a list of all extracted links:"
}], "ExampleText",
 CellID->58060424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"HyperlinkType", "\[Rule]", "\"\<Raw\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40980253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"index.ko.html\"\>", ",", "\<\"index.ja.html\"\>", 
   ",", "\<\"index.pt-br.html\"\>", ",", "\<\"index.ru.html\"\>", 
   ",", "\<\"/news/newsletter/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/system-modeler/\"\>"}], 
  "}"}]], "Output",
 ImageSize->{519, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22816629]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->608614940],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HyperlinkType",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"], " ", "->", " ", 
   "\"\<Raw\>\""}]], "InlineFormula"],
 " ignores the value of ",
 Cell[BoxData[
  ButtonBox["AbsoluteLinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17318354],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"address", ",", "source"}], "}"}], "=", 
   RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"AbsoluteLinks", "\[Rule]", "True"}], ",", 
   RowBox[{"HyperlinkType", "\[Rule]", "\"\<Raw\>\""}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->112336717],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"index.ko.html\"\>", ",", "\<\"index.ja.html\"\>", 
   ",", "\<\"index.pt-br.html\"\>", ",", "\<\"index.ru.html\"\>", 
   ",", "\<\"/news/newsletter/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/system-modeler/\"\>"}], 
  "}"}]], "Output",
 ImageSize->{519, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134472635]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetSource",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetSource"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkWeb",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAbsoluteLink",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GatherBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GatherBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteLinkQ",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->425979228]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetHyperlinks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 6.4531408}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "GetHyperlinks[\"address\", \"source\"] gives a list of hyperlinks \
extracted from \"source\" located at the specified \"address\".", 
    "synonyms" -> {}, "title" -> "GetHyperlinks", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/GetHyperlinks"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8742, 259, 462, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1048460619]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30827, 916}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[606, 21, 76, 1, 3, "SymbolColorBar"],
Cell[685, 24, 209, 5, 19, "LinkTrail"],
Cell[897, 31, 3292, 72, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4214, 107, 56, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4273, 110, 803, 22, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5113, 137, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->614324166],
Cell[5696, 156, 604, 19, 70, "Notes",
 CellID->1067943069],
Cell[6303, 177, 207, 6, 70, "Notes"],
Cell[6513, 185, 543, 14, 70, "3ColumnTableMod"],
Cell[7059, 201, 441, 13, 70, "Notes",
 CellID->13890002],
Cell[7503, 216, 525, 12, 70, "2ColumnTableMod",
 CellID->629461856],
Cell[8031, 230, 229, 7, 70, "Notes",
 CellID->223313794],
Cell[8263, 239, 442, 15, 70, "Notes",
 CellID->55472200]
}, Closed]],
Cell[CellGroupData[{
Cell[8742, 259, 462, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1048460619],
Cell[CellGroupData[{
Cell[9229, 276, 147, 5, 31, "ExampleSection",
 CellID->71240145],
Cell[9379, 283, 121, 3, 28, "Input",
 CellID->89166275],
Cell[9503, 288, 117, 3, 32, "ExampleText",
 CellID->413594937],
Cell[CellGroupData[{
Cell[9645, 295, 322, 10, 47, "Input",
 CellID->449355338],
Cell[9970, 307, 1350, 27, 224, "Output",
 CellID->5448899]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11369, 340, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[11593, 349, 122, 3, 70, "Input",
 CellID->139972119],
Cell[11718, 354, 234, 7, 70, "ExampleText",
 CellID->892767892],
Cell[11955, 363, 529, 18, 70, "Input",
 CellID->139208013],
Cell[CellGroupData[{
Cell[12509, 385, 146, 4, 70, "Input",
 CellID->475944353],
Cell[12658, 391, 2703, 52, 70, "Output",
 CellID->131155986]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15410, 449, 202, 6, 18, "ExampleSection"],
Cell[CellGroupData[{
Cell[15637, 459, 214, 6, 70, "ExampleSubsection"],
Cell[15854, 467, 122, 3, 70, "Input",
 CellID->763817438],
Cell[15979, 472, 258, 8, 70, "ExampleText",
 CellID->513209570],
Cell[CellGroupData[{
Cell[16262, 484, 376, 11, 70, "Input",
 CellID->24396138],
Cell[16641, 497, 1352, 27, 70, "Output",
 CellID->253360142]
}, Open  ]],
Cell[18008, 527, 347, 12, 70, "ExampleText",
 CellID->31699516],
Cell[CellGroupData[{
Cell[18380, 543, 199, 5, 70, "Input",
 CellID->644651139],
Cell[18582, 550, 1150, 23, 70, "Output",
 CellID->14459874]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19781, 579, 214, 6, 70, "ExampleSubsection"],
Cell[19998, 587, 121, 3, 70, "Input",
 CellID->25669242],
Cell[20122, 592, 288, 8, 70, "ExampleText",
 CellID->334081550],
Cell[CellGroupData[{
Cell[20435, 604, 392, 12, 70, "Input",
 CellID->712061981],
Cell[20830, 618, 1351, 27, 70, "Output",
 CellID->17828767]
}, Open  ]],
Cell[22196, 648, 298, 10, 70, "ExampleText",
 CellID->58060424],
Cell[CellGroupData[{
Cell[22519, 662, 204, 5, 70, "Input",
 CellID->40980253],
Cell[22726, 669, 1150, 23, 70, "Output",
 CellID->22816629]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23937, 699, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[24171, 708, 122, 3, 70, "Input",
 CellID->608614940],
Cell[24296, 713, 435, 15, 70, "ExampleText",
 CellID->17318354],
Cell[CellGroupData[{
Cell[24756, 732, 439, 12, 70, "Input",
 CellID->112336717],
Cell[25198, 746, 1151, 23, 70, "Output",
 CellID->134472635]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26410, 776, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[26830, 790, 1698, 58, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[28565, 853, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[28987, 867, 168, 3, 70, "MoreAbout",
 CellID->1665078683],
Cell[29158, 872, 145, 3, 70, "MoreAbout",
 CellID->425979228]
}, Open  ]],
Cell[29318, 878, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

