(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     19399,        625]
NotebookOptionsPosition[     15469,        495]
NotebookOutlinePosition[     17117,        542]
CellTagsIndexPosition[     17032,        537]
WindowTitle->GetSource - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkWeb"], "\<\"$Timeout\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$Timeout"], "\<\"GetHyperlinks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetHyperlinks"], "\<\"GetFavicon\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetFavicon"], "\<\"$UserAgent\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/$UserAgent"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\".NET \
Interface\"\>":>Documentation`HelpLookup[
       "paclet:NETLink/guide/DotNETInterface"], "\<\"String Manipulation\"\>":>
       Documentation`HelpLookup["paclet:guide/StringManipulation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/GetSource\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/GetSource"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/GetSource.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/GetSource", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["GetSource", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GetSource",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/GetSource"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gets the source of the page associated with the \
requested ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->435767842],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["GetSource",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetSource"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetSource",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetSource"]], "InlineFormula"],
 " returns the responding address in addition to the page source ",
 "(i.e., HTML)",
 ".  The address may differ from ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 " due to one or more redirects."
}], "Notes",
 CellID->83648684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetSource",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetSource"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetSource",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetSource"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it is unable to complete the request."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21529680],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->852372799],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30739123],

Cell["\<\
Get the source of the page associated with the requested URL:\
\>", "ExampleText",
 CellID->202018423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14091968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://wolfram.com/\"\>", 
   ",", "\<\"<!DOCTYPE html PUBLIC \\\"-//W3C//DTD XHTML 1.0 Transitional//EN\
\\\" \\\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\\">\\n<html \
xmlns=\\\"http://www.w3.org/1999/xhtml\\\" xml:lang=\\\"en\\\" \
lang=\\\"en\\\">\\n<head>\\n\\n<link rel=\\\"shortcut icon\\\" \
href=\\\"/common/images2003/f\[Ellipsis]nction displayIMG(){\\n\\t\\t// \
Insert no-flash image into the flash \
div\\n\\t\\tdocument.getElementById('flash').innerHTML = '<a \
href=\\\"/system-modeler/\\\"><img \
src=\\\"/images/homepage2010/noflash-wsm.png\\\" border=\\\"0\\\" /></a>';\\n\
\\t}\\n/* ]]> */\\n</script>\\t\\n</body>\\n</html>\\n\"\>"}], 
  "}"}]], "Output",
 ImageSize->{515, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1463890]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetSource",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetSource"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetSource", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<http://wolfram.com/\>\"", ",", "\"\<http://wolframscience.com/\>\""}],
    "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"http://wolfram.com/\"\>", 
     ",", "\<\"<!DOCTYPE html PUBLIC \\\"-//W3C//DTD XHTML 1.0 \
Transitional//EN\\\" \
\\\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\\\">\\n<html \
xmlns=\\\"http://www.w3.org/1999/xhtml\\\" xml:lang=\\\"en\\\" \
lang=\\\"en\\\">\\n<head>\\n\\n<link rel=\\\"shortcut icon\\\" \
href=\\\"/common/images2003/f\[Ellipsis]nction displayIMG(){\\n\\t\\t// \
Insert no-flash image into the flash \
div\\n\\t\\tdocument.getElementById('flash').innerHTML = '<a \
href=\\\"/system-modeler/\\\"><img \
src=\\\"/images/homepage2010/noflash-wsm.png\\\" border=\\\"0\\\" /></a>';\\n\
\\t}\\n/* ]]> */\\n</script>\\t\\n</body>\\n</html>\\n\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"http://wolframscience.com/\"\>", 
     ",", "\<\"<!DOCTYPE HTML PUBLIC \\\"-//W3C//DTD HTML 4.0 \
Transitional//EN\\\">\\n<html>\\n<head>\\n<title>Stephen Wolfram: A New Kind \
of Science</title>\\n<meta name=\\\"description\\\" content=\\\"Wolfram \
Science -- The Official Website of Stephen Wolfram's 'A New Kind of \
Science'\\\"\[Ellipsis]tephenwolfram.com</a>|<a \
href=\\\"http://www.wolfram.com\\\">wolfram.com</a>|<a href=\\\"/guestbook/\\\
\">send a message</a>|<a href=\\\"/contact/\\\">contact \
info</a></td>\\n\\t</tr>\\n\\t</table>\\n</div>\\n<!-- end common footer \
stuff -->\\n<!-- end footer -->\\n\\n</body>\\n\\n\\n</html>\\n\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{549, 611},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->188973948]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255766292],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetSource",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetSource"]], "InlineFormula"],
 " may be unable to complete the request:"
}], "ExampleText",
 CellID->37306969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetSource", "[", "\"\<http://www.example.zzz/\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190207709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.example.zzz/\"\>", ",", "$Failed"}], 
  "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->492089181]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkWeb",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Timeout",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$Timeout"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetHyperlinks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetFavicon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserAgent",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$UserAgent"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox[".NET Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/guide/DotNETInterface"]], "MoreAbout",
 CellID->62574990],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->135606599]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetSource - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 8.4731436}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "GetSource[\"url\"] gets the source of the page associated with the \
requested \"url\".", "synonyms" -> {}, "title" -> "GetSource", "type" -> 
    "Symbol", "uri" -> "RandomWalkWeb/ref/GetSource"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7163, 214, 460, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21529680]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16890, 530}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[602, 21, 76, 1, 3, "SymbolColorBar"],
Cell[681, 24, 209, 5, 19, "LinkTrail"],
Cell[893, 31, 3321, 73, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4239, 108, 52, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4294, 111, 612, 18, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4943, 134, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->435767842],
Cell[5526, 153, 596, 19, 70, "Notes",
 CellID->1067943069],
Cell[6125, 174, 416, 12, 70, "Notes",
 CellID->83648684],
Cell[6544, 188, 220, 7, 70, "Notes",
 CellID->12607960],
Cell[6767, 197, 359, 12, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[7163, 214, 460, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21529680],
Cell[CellGroupData[{
Cell[7648, 231, 148, 5, 31, "ExampleSection",
 CellID->852372799],
Cell[7799, 238, 121, 3, 28, "Input",
 CellID->30739123],
Cell[7923, 243, 112, 3, 32, "ExampleText",
 CellID->202018423],
Cell[CellGroupData[{
Cell[8060, 250, 130, 3, 28, "Input",
 CellID->14091968],
Cell[8193, 255, 865, 18, 309, "Output",
 CellID->1463890]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9107, 279, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[9331, 288, 122, 3, 70, "Input",
 CellID->139972119],
Cell[9456, 293, 226, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[9707, 304, 219, 7, 70, "Input",
 CellID->475944353],
Cell[9929, 313, 1614, 32, 70, "Output",
 CellID->188973948]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11592, 351, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[11826, 360, 122, 3, 70, "Input",
 CellID->255766292],
Cell[11951, 365, 231, 7, 70, "ExampleText",
 CellID->37306969],
Cell[CellGroupData[{
Cell[12207, 376, 135, 3, 70, "Input",
 CellID->190207709],
Cell[12345, 381, 243, 8, 70, "Output",
 CellID->492089181]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12649, 396, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[13069, 410, 1428, 48, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[14534, 463, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[14956, 477, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[15127, 482, 148, 3, 17, "MoreAbout",
 CellID->62574990],
Cell[15278, 487, 149, 3, 17, "MoreAbout",
 CellID->135606599]
}, Open  ]],
Cell[15442, 493, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

