(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     66244,       2118]
NotebookOptionsPosition[     56255,       1769]
NotebookOutlinePosition[     58110,       1819]
CellTagsIndexPosition[     58024,       1814]
WindowTitle->GetStepData - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"PerformRandomWalks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/PerformRandomWalks"], "\<\"RandomWalkGraph\"\
\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkGraph"], "\<\"Range\"\>":>
       Documentation`HelpLookup[
       "paclet:ref/Range"], "\<\"$DataFilePrefix\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$DataFilePrefix"], "\<\"ToGraphData\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/ToGraphData"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"List \
Manipulation\"\>":>Documentation`HelpLookup["paclet:guide/ListManipulation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/GetStepData\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/GetStepData"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/GetStepData.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/GetStepData", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["GetStepData", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GetStepData",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["fn", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["fn", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " steps extracted from each of the random walk data files ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["fn", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " originating from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     ".  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GetStepData",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        StyleBox["fn", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of steps extracted from the random walk \
data file ",
     Cell[BoxData[
      StyleBox["fn", "TI"]], "InlineFormula"],
     " originating from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->465224700],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " supports a ",
 Cell[BoxData[
  ButtonBox["VertexType",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/VertexType"]], "InlineFormula"],
 " option which determines the type of vertices returned.  Possible settings \
include:"
}], "Notes",
 CellID->13890002],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DomainName\>\"", Cell[
    "labels vertices using domain name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hostname\>\"", Cell[
    "labels vertices by hostname", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->629461856],

Cell[TextData[{
 "The root data directory is given by ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->258881562],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " imports data from a specific folder.  The folder name must be a \
32-character, hexidecimal-formatted MD5 hash of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->3330439],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " accepts file numbers ",
 Cell[BoxData[
  StyleBox["fn", "TI"]], "InlineFormula"],
 " corresponding to positions in the sequence of random walks from ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->763870994],

Cell[TextData[{
 "The list returned by ",
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " does not contain steps that connect a vertex to itself, nor does it \
contain duplicate steps."
}], "Notes",
 CellID->83648684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it is unable to import the requested data."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136170143],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->26720975],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192721251],

Cell["Get a list of steps extracted from random walk data:", "ExampleText",
 CellID->821530070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5031720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{577, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->930259018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360651204],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610716080],

Cell["\<\
Get a list of steps extracted from multiple random walk data files:\
\>", "ExampleText",
 CellID->259613294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143748836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"computerbasedmath.org\"\>", ",", "\<\"twitter.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"computerbasedmath.org\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", 
     ",", "\<\"complex-systems.com\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{541, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166738695]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->298334985],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160906577],

Cell["Get a list of all steps from a single random walk data file:", \
"ExampleText",
 CellID->54821508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205896047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{575, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184906233]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314157920],

Cell[TextData[{
 "Collect random walk data using ",
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->281984562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47865016],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->834686760]
}, Open  ]],

Cell["View the resulting data:", "ExampleText",
 CellID->29887901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GetStepData", "[", 
   RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
    RowBox[{"{", "2", "}"}], ",", " ", "7"}], "]"}], " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->206747454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{577, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->57149211]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58987498],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6389288],

Cell[TextData[{
 "Quickly generate a list of file numbers using ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->520325747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "=", 
  RowBox[{"Range", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18888682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->190802610]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "fn", ",", "8"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->168213023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"computerbasedmath.org\"\>", ",", "\<\"twitter.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"computerbasedmath.org\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", 
     ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{562, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->580016549]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127399744],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159202963],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 " to change the base data directory:"
}], "ExampleText",
 CellID->190501847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$BaseDataDirectory", "=", "$TemporaryDirectory"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104488195],

Cell[BoxData["\<\"C:\\\\Users\\\\$UserName\\\\AppData\\\\Local\\\\Temp\"\>"], \
"Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161185181]
}, Open  ]],

Cell["Collect and view the random walk data:", "ExampleText",
 CellID->690487144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83728472],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->565737287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", " ", "7"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->64316292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{577, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->49554282]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23500834],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110792157],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$DataFilePrefix",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$DataFilePrefix"]], "InlineFormula"],
 " to change the file name prefix:"
}], "ExampleText",
 CellID->218875408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$DataFilePrefix", "=", 
  RowBox[{"DateString", "[", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Year\>\"", ",", " ", "\"\<-\>\"", ",", "\"\<Month\>\"", ",", 
     "\"\<-\>\"", ",", "\"\<Day\>\"", ",", "\"\<_\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39701280],

Cell[BoxData["\<\"2012-09-24_\"\>"], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->424212825]
}, Open  ]],

Cell["Collect and view the random walk data:", "ExampleText",
 CellID->378963063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->742437364],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32742712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", " ", "7"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8364289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{577, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->21981334]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexType",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352278651],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " labels vertices using domain name:"
}], "ExampleText",
 CellID->758379001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"VertexType", "\[Rule]", "\"\<DomainName\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->810720801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{577, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->962014071]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexType",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexType"], " ", "->", " ", 
   "\"\<Hostname\>\""}]], "InlineFormula"],
 " to label vertices by hostname:"
}], "ExampleText",
 CellID->638222872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"VertexType", "\[Rule]", "\"\<Hostname\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32718880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"blog.stephenwolfram.com\"\>", 
     ",", "\<\"www.wolframalpha.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", 
     ",", "\<\"www.mathematica-journal.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.mathematica-journal.com\"\>", 
     ",", "\<\"www.wolfram.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolframalpha.com\"\>", 
     ",", "\<\"www.wolframscience.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolfram.com\"\>", 
     ",", "\<\"www.wolframscience.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolfram-media.com\"\>", 
     ",", "\<\"blog.stephenwolfram.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolframscience.com\"\>", 
     ",", "\<\"www.wolfram-media.com\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{356, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->999820705]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219878613],

Cell["Construct a graph from the specified step data:", "ExampleText",
 CellID->164955485],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"stepData", "=", 
   RowBox[{"GetStepData", "[", 
    RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
     RowBox[{"{", "2", "}"}], ",", "7"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomWalkGraph", "[", "stepData", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->275433556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}]], Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          DiskBox[{0., 0.49171600403719756`}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          
          DiskBox[{0.9870549567799676, 0.4917023249955501}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{3.801899036431133, 0.49201733434184985`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{3.075223556437642, 0.9833469445744307}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{3.0760930698520648`, 0.}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{76.5, 103.5}, {-10.643200000000007`, 
         6.356799999999993}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126415148]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"stepData", "=", 
   RowBox[{"GetStepData", "[", 
    RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", "8"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomWalkGraph", "[", "stepData", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->412043414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 3, 4, 5, 6, 7, 
        1}, {{{1, 2}, {3, 4}, {4, 1}, {4, 3}, {4, 5}, {4, 6}, {5, 4}, {6, 7}},
          Null}]], Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          
          DiskBox[{0.8140859052558821, 0.45714855912998636`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          DiskBox[{0., 0.}, 0.03443006385426714], "DynamicName", BoxID -> 
          "VertexID$2"], 
         TagBox[
          
          DiskBox[{2.3404289944058014`, 1.8324752840268963`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{1.8020559320938747`, 1.0515984511936183`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{1.2606626762505695`, 1.8297543645563343`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{2.79078236726949, 0.457620230872313}, 0.03443006385426714],
           "DynamicName", BoxID -> "VertexID$6"], 
         TagBox[
          
          DiskBox[{3.605538678138704, 0.0014283642127416174`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$7"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.026751335043226663`, 0.7}}], {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.312434252273612, 1.730102692474329}, {2.304733945907327, 
            1.704390610213496}, {2.2958063623115783`, 1.6790784759008108`}, {
            2.2856721493629495`, 1.6542248318976802`}, {2.274354745652184, 
            1.6298871601608427`}, {2.261880326274992, 1.6061217492970594`}, {
            2.2482777422938107`, 1.5829835643778094`}, {2.2335784540105523`, 
            1.5605261198150777`}, {2.0182292290857826`, 1.248175386681767}, {
            2.002467233279876, 1.226450622458948}, {1.985678984579902, 
            1.2055087840031122`}, {1.9679033111506707`, 
            1.1853983059764759`}, {1.94918132489074, 1.1661657002558394`}, {
            1.9295563263480737`, 1.147855448359078}, {1.9090737045737538`, 
            1.1305098985674844`}, {1.887780832145361, 1.1141691679818988`}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.8300506742260643`, 1.1539710427461853`}, {1.8377509805923493`, 
            1.1796831250070183`}, {1.8466785641880978`, 
            1.2049952593197037`}, {1.8568127771367267`, 
            1.2298489033228344`}, {1.8681301808474915`, 1.254186575059672}, {
            1.8806046002246843`, 1.2779519859234552`}, {1.8942071842058654`, 
            1.3010901708427052`}, {1.9089064724891234`, 
            1.3235476154054369`}, {2.124255697413894, 1.635898348538748}, {
            2.140017693219801, 1.657623112761567}, {2.1568059419197745`, 
            1.6785649512174028`}, {2.174581615349006, 1.6986754292440391`}, {
            2.193303601608937, 1.7179080349646756`}, {2.212928600151603, 
            1.736218286861437}, {2.233411221925923, 1.7535638366530306`}, {
            2.2547040943543153`, 1.7699045672386162`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.7161126354990208`, 1.1137701590201041`}, {1.6947621205898316`, 
            1.1300113383763382`}, {1.67421713678277, 1.147260223387737}, {
            1.6545252008874536`, 1.1654769205215096`}, {1.6357318567688806`, 
            1.1846192978715093`}, {1.6178805700127605`, 
            1.2046430826016656`}, {1.6010126273975192`, 
            1.2255019633410005`}, {1.585167041405493, 1.2471476972934021`}, {
            1.3686097390681708`, 1.5584100626384882`}, {1.353823157656833, 
            1.5807925871595236`}, {1.3401297794987352`, 
            1.6038601355422235`}, {1.3275612748862016`, 
            1.6275593567440603`}, {1.3161467124837027`, 1.651835438778201}, {
            1.3059124920973242`, 1.6766322354836607`}, {1.2968822836168183`, 
            1.7018923963811583`}, {1.2890769722714555`, 1.72755749931434}, 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], {
            1.346605972845424, 1.767582656729849}, {1.3679564877546129`, 
            1.751341477373615}, {1.3885014715616744`, 1.7340925923622161`}, {
            1.408193407456991, 1.7158758952284434`}, {1.4269867515755637`, 
            1.6967335178784437`}, {1.4448380383316837`, 
            1.6767097331482874`}, {1.461705980946925, 1.6558508524089526`}, {
            1.4775515669389516`, 1.634205118456551}, {1.6941088692762736`, 
            1.3229427531114648`}, {1.7088954506876115`, 
            1.3005602285904296`}, {1.7225888288457092`, 
            1.2774926802077295`}, {1.7351573334582429`, 
            1.2537934590058928`}, {1.7465718958607417`, 1.229517376971752}, {
            1.7568061162471202`, 1.2047205802662924`}, {1.765836324727626, 
            1.1794604193687948`}, {1.773641636072989, 1.153795316435613}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{2.58, 176.42000000000002`}, {-48.56320000000001, 
         42.356238094929495`}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"twitter.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{482, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19961489]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418918349],

Cell["\<\
Invalid file numbers and out of range step sizes are ignored:\
\>", "ExampleText",
 CellID->211706579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "7"}], ",", "1", ",", "2", ",", "3", ",", "20"}], "}"}], 
   ",", "100"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467215405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"computerbasedmath.org\"\>", ",", "\<\"twitter.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"computerbasedmath.org\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", 
     ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{583, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->217209952]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82760349],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"computerbasedmath.org\"\>", ",", "\<\"twitter.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"computerbasedmath.org\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"wolfram.com\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", 
     ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{583, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42955075]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283851897],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->136550100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http:///\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30964636],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118080000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187551867],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121226319],

Cell["At least one valid file must be specified:", "ExampleText",
 CellID->98111338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"-", "7"}], "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->316349048],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31516604]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "7"}], ",", "2"}], "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->228371998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{577, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158051017]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399604478],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129130089],

Cell["The number of steps must be greater than or equal to 1:", "ExampleText",
 CellID->271731252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"-", "7"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->431987857],

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\<\"http://wolfram.com/\"\>", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"-", "7"}]}], "]"}]], "Output",
 ImageSize->{288, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->397386773]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PerformRandomWalks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DataFilePrefix",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$DataFilePrefix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToGraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->425979228]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetStepData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 11.6631481}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "GetStepData[\"url\", {fn_1, fn_2, ...}, n] gives a list of the first n \
steps extracted from each of the random walk data files fn_i originating from \
\"url\". GetStepData[\"url\", fn] gives a list of steps extracted from the \
random walk data file fn originating from \"url\".", "synonyms" -> {}, 
    "title" -> "GetStepData", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/GetStepData"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9941, 303, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->136170143]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57881, 1807}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[604, 21, 76, 1, 3, "SymbolColorBar"],
Cell[683, 24, 209, 5, 19, "LinkTrail"],
Cell[895, 31, 3217, 71, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4137, 106, 54, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4194, 109, 1802, 54, 166, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6033, 168, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->465224700],
Cell[6616, 187, 600, 19, 70, "Notes",
 CellID->1067943069],
Cell[7219, 208, 429, 13, 70, "Notes",
 CellID->13890002],
Cell[7651, 223, 494, 11, 70, "2ColumnTableMod",
 CellID->629461856],
Cell[8148, 236, 250, 9, 70, "Notes",
 CellID->258881562],
Cell[8401, 247, 389, 11, 70, "Notes",
 CellID->3330439],
Cell[8793, 260, 426, 13, 70, "Notes",
 CellID->763870994],
Cell[9222, 275, 311, 9, 70, "Notes",
 CellID->83648684],
Cell[9536, 286, 368, 12, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[9941, 303, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->136170143],
Cell[CellGroupData[{
Cell[10427, 320, 147, 5, 31, "ExampleSection",
 CellID->26720975],
Cell[10577, 327, 122, 3, 28, "Input",
 CellID->192721251],
Cell[10702, 332, 95, 1, 32, "ExampleText",
 CellID->821530070],
Cell[CellGroupData[{
Cell[10822, 337, 188, 5, 28, "Input",
 CellID->5031720],
Cell[11013, 344, 964, 28, 88, "Output",
 CellID->930259018]
}, Open  ]],
Cell[CellGroupData[{
Cell[12014, 377, 125, 3, 8, "ExampleDelimiter",
 CellID->360651204],
Cell[12142, 382, 122, 3, 28, "Input",
 CellID->610716080],
Cell[12267, 387, 118, 3, 32, "ExampleText",
 CellID->259613294],
Cell[CellGroupData[{
Cell[12410, 394, 215, 6, 28, "Input",
 CellID->143748836],
Cell[12628, 402, 1044, 31, 88, "Output",
 CellID->166738695]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13721, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->298334985],
Cell[13849, 444, 122, 3, 70, "Input",
 CellID->160906577],
Cell[13974, 449, 104, 2, 70, "ExampleText",
 CellID->54821508],
Cell[CellGroupData[{
Cell[14103, 455, 156, 4, 70, "Input",
 CellID->205896047],
Cell[14262, 461, 1078, 31, 70, "Output",
 CellID->184906233]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15401, 499, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[15625, 508, 122, 3, 70, "Input",
 CellID->314157920],
Cell[15750, 513, 251, 9, 70, "ExampleText",
 CellID->281984562],
Cell[CellGroupData[{
Cell[16026, 526, 172, 4, 70, "Input",
 CellID->47865016],
Cell[16201, 532, 158, 5, 70, "Output",
 CellID->834686760]
}, Open  ]],
Cell[16374, 540, 66, 1, 70, "ExampleText",
 CellID->29887901],
Cell[CellGroupData[{
Cell[16465, 545, 215, 6, 70, "Input",
 CellID->206747454],
Cell[16683, 553, 963, 28, 70, "Output",
 CellID->57149211]
}, Open  ]],
Cell[CellGroupData[{
Cell[17683, 586, 124, 3, 70, "ExampleDelimiter",
 CellID->58987498],
Cell[17810, 591, 120, 3, 70, "Input",
 CellID->6389288],
Cell[17933, 596, 223, 8, 70, "ExampleText",
 CellID->520325747],
Cell[CellGroupData[{
Cell[18181, 608, 124, 4, 70, "Input",
 CellID->18888682],
Cell[18308, 614, 213, 7, 70, "Output",
 CellID->190802610]
}, Open  ]],
Cell[CellGroupData[{
Cell[18558, 626, 170, 5, 70, "Input",
 CellID->168213023],
Cell[18731, 633, 1833, 52, 70, "Output",
 CellID->580016549]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20613, 691, 125, 3, 70, "ExampleDelimiter",
 CellID->127399744],
Cell[20741, 696, 122, 3, 70, "Input",
 CellID->159202963],
Cell[20866, 701, 258, 9, 70, "ExampleText",
 CellID->190501847],
Cell[CellGroupData[{
Cell[21149, 714, 127, 3, 70, "Input",
 CellID->104488195],
Cell[21279, 719, 220, 6, 70, "Output",
 CellID->161185181]
}, Open  ]],
Cell[21514, 728, 81, 1, 70, "ExampleText",
 CellID->690487144],
Cell[CellGroupData[{
Cell[21620, 733, 172, 4, 70, "Input",
 CellID->83728472],
Cell[21795, 739, 158, 5, 70, "Output",
 CellID->565737287]
}, Open  ]],
Cell[CellGroupData[{
Cell[21990, 749, 194, 5, 70, "Input",
 CellID->64316292],
Cell[22187, 756, 963, 28, 70, "Output",
 CellID->49554282]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23199, 790, 124, 3, 70, "ExampleDelimiter",
 CellID->23500834],
Cell[23326, 795, 122, 3, 70, "Input",
 CellID->110792157],
Cell[23451, 800, 246, 8, 70, "ExampleText",
 CellID->218875408],
Cell[CellGroupData[{
Cell[23722, 812, 308, 9, 70, "Input",
 CellID->39701280],
Cell[24033, 823, 176, 5, 70, "Output",
 CellID->424212825]
}, Open  ]],
Cell[24224, 831, 81, 1, 70, "ExampleText",
 CellID->378963063],
Cell[CellGroupData[{
Cell[24330, 836, 173, 4, 70, "Input",
 CellID->742437364],
Cell[24506, 842, 157, 5, 70, "Output",
 CellID->32742712]
}, Open  ]],
Cell[CellGroupData[{
Cell[24700, 852, 193, 5, 70, "Input",
 CellID->8364289],
Cell[24896, 859, 963, 28, 70, "Output",
 CellID->21981334]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25920, 894, 202, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[26147, 904, 211, 6, 70, "ExampleSubsection"],
Cell[26361, 912, 122, 3, 70, "Input",
 CellID->352278651],
Cell[26486, 917, 249, 8, 70, "ExampleText",
 CellID->758379001],
Cell[CellGroupData[{
Cell[26760, 929, 256, 6, 70, "Input",
 CellID->810720801],
Cell[27019, 937, 964, 28, 70, "Output",
 CellID->962014071]
}, Open  ]],
Cell[27998, 968, 291, 10, 70, "ExampleText",
 CellID->638222872],
Cell[CellGroupData[{
Cell[28314, 982, 253, 6, 70, "Input",
 CellID->32718880],
Cell[28570, 990, 1027, 28, 70, "Output",
 CellID->999820705]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29658, 1025, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[29888, 1034, 122, 3, 70, "Input",
 CellID->219878613],
Cell[30013, 1039, 90, 1, 70, "ExampleText",
 CellID->164955485],
Cell[CellGroupData[{
Cell[30128, 1044, 324, 9, 70, "Input",
 CellID->275433556],
Cell[30455, 1055, 5875, 124, 70, "Output",
 CellID->126415148]
}, Open  ]],
Cell[CellGroupData[{
Cell[36367, 1184, 351, 10, 70, "Input",
 CellID->412043414],
Cell[36721, 1196, 8046, 159, 70, "Output",
 CellID->19961489]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44816, 1361, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[45057, 1370, 122, 3, 70, "Input",
 CellID->418918349],
Cell[45182, 1375, 112, 3, 70, "ExampleText",
 CellID->211706579],
Cell[CellGroupData[{
Cell[45319, 1382, 273, 8, 70, "Input",
 CellID->467215405],
Cell[45595, 1392, 1833, 52, 70, "Output",
 CellID->217209952]
}, Open  ]],
Cell[CellGroupData[{
Cell[47465, 1449, 224, 6, 70, "Input",
 CellID->82760349],
Cell[47692, 1457, 1832, 52, 70, "Output",
 CellID->42955075]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49573, 1515, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[49807, 1524, 122, 3, 70, "Input",
 CellID->283851897],
Cell[49932, 1529, 237, 7, 70, "ExampleText",
 CellID->136550100],
Cell[CellGroupData[{
Cell[50194, 1540, 178, 5, 70, "Input",
 CellID->30964636],
Cell[50375, 1547, 175, 6, 70, "Output",
 CellID->118080000]
}, Open  ]],
Cell[CellGroupData[{
Cell[50587, 1558, 125, 3, 70, "ExampleDelimiter",
 CellID->187551867],
Cell[50715, 1563, 122, 3, 70, "Input",
 CellID->121226319],
Cell[50840, 1568, 84, 1, 70, "ExampleText",
 CellID->98111338],
Cell[CellGroupData[{
Cell[50949, 1573, 210, 6, 70, "Input",
 CellID->316349048],
Cell[51162, 1581, 174, 6, 70, "Output",
 CellID->31516604]
}, Open  ]],
Cell[CellGroupData[{
Cell[51373, 1592, 236, 7, 70, "Input",
 CellID->228371998],
Cell[51612, 1601, 964, 28, 70, "Output",
 CellID->158051017]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52625, 1635, 125, 3, 70, "ExampleDelimiter",
 CellID->399604478],
Cell[52753, 1640, 122, 3, 70, "Input",
 CellID->129130089],
Cell[52878, 1645, 98, 1, 70, "ExampleText",
 CellID->271731252],
Cell[CellGroupData[{
Cell[53001, 1650, 209, 6, 70, "Input",
 CellID->431987857],
Cell[53213, 1658, 298, 9, 70, "Output",
 CellID->397386773]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53584, 1675, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[54004, 1689, 1434, 48, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[55475, 1742, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[55897, 1756, 168, 3, 70, "MoreAbout",
 CellID->1665078683],
Cell[56068, 1761, 145, 3, 70, "MoreAbout",
 CellID->425979228]
}, Open  ]],
Cell[56228, 1767, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

