(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16477,        561]
NotebookOptionsPosition[     12708,        435]
NotebookOutlinePosition[     14321,        482]
CellTagsIndexPosition[     14236,        477]
WindowTitle->Hostname - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"DomainName\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/DomainName"], "\<\"SiteRoot\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/SiteRoot"], "\<\"AbsoluteLinkQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/AbsoluteLinkQ"], "\<\"ToAbsoluteLink\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/ToAbsoluteLink"], "\<\"BaseURL\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/BaseURL"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"String \
Manipulation\"\>":>Documentation`HelpLookup[
       "paclet:guide/StringManipulation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/Hostname\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/Hostname"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/Hostname.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/Hostname", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["Hostname", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hostname",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/Hostname"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the hostname of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->224978309],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["Hostname",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hostname",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hostname",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 " is not a fully qualified (i.e., absolute) URL."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248398137],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->421380928],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->871513663],

Cell["Return the hostname of the specified URL:", "ExampleText",
 CellID->58196860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hostname", "[", "\"\<http://www.example.net/dir1/page1.html\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->329249221],

Cell[BoxData["\<\"www.example.net\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44281528]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hostname",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hostname", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<http://www.example.net/dir1/page1.html\>\"", ",", 
    "\"\<http://www.example.net/dir1/subdir1/\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"www.example.net\"\>", ",", "\<\"www.example.net\"\>"}], 
  "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168424885]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193774557],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hostname",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/Hostname"]], "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->467400294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hostname", "[", "\"\<./page2.html\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->249914984],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247583273]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DomainName",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/DomainName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SiteRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteLinkQ",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAbsoluteLink",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseURL",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/BaseURL"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->333683230]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hostname - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 13.6731509}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "Hostname[\"url\"] gives the hostname of \"url\".", "synonyms" -> {}, 
    "title" -> "Hostname", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/Hostname"}, "LinkTrails" -> "", "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6674, 200, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->248398137]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14093, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[601, 21, 76, 1, 3, "SymbolColorBar"],
Cell[680, 24, 209, 5, 19, "LinkTrail"],
Cell[892, 31, 3205, 71, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4122, 106, 51, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4176, 109, 572, 17, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4785, 131, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->224978309],
Cell[5368, 150, 594, 19, 70, "Notes",
 CellID->1067943069],
Cell[5965, 171, 218, 7, 70, "Notes",
 CellID->12607960],
Cell[6186, 180, 451, 15, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[6674, 200, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248398137],
Cell[CellGroupData[{
Cell[7160, 217, 148, 5, 31, "ExampleSection",
 CellID->421380928],
Cell[7311, 224, 122, 3, 28, "Input",
 CellID->871513663],
Cell[7436, 229, 83, 1, 32, "ExampleText",
 CellID->58196860],
Cell[CellGroupData[{
Cell[7544, 234, 152, 4, 28, "Input",
 CellID->329249221],
Cell[7699, 240, 180, 5, 36, "Output",
 CellID->44281528]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7928, 251, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[8152, 260, 122, 3, 70, "Input",
 CellID->139972119],
Cell[8277, 265, 224, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[8526, 276, 248, 7, 70, "Input",
 CellID->475944353],
Cell[8777, 285, 251, 8, 70, "Output",
 CellID->168424885]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9077, 299, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[9311, 308, 122, 3, 70, "Input",
 CellID->193774557],
Cell[9436, 313, 231, 7, 70, "ExampleText",
 CellID->467400294],
Cell[CellGroupData[{
Cell[9692, 324, 123, 3, 70, "Input",
 CellID->249914984],
Cell[9818, 329, 164, 5, 70, "Output",
 CellID->247583273]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10043, 341, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[10463, 355, 1424, 48, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11924, 408, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[12346, 422, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[12517, 427, 149, 3, 17, "MoreAbout",
 CellID->333683230]
}, Open  ]],
Cell[12681, 433, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

