(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     15268,        466]
NotebookOptionsPosition[     11944,        359]
NotebookOutlinePosition[     13635,        407]
CellTagsIndexPosition[     13550,        402]
WindowTitle->HyperlinkType - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"AbsoluteLinks\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/AbsoluteLinks"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Options \
Management\"\>":>Documentation`HelpLookup["paclet:guide/OptionsManagement"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/HyperlinkType\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/HyperlinkType"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/HyperlinkType.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/HyperlinkType", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["HyperlinkType", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["HyperlinkType",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"]], 
      "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GetHyperlinks",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"]], 
      "InlineFormula"],
     " that determines the type of hyperlinks returned by the function."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->293064520],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["HyperlinkType",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/HyperlinkType"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell["Possible settings include:", "Notes",
 CellID->13890002],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Raw\>\"", Cell[
    "returns all extracted links", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Selected\>\"", Cell["\<\
uses internal selection criteria to remove JavaScript and SMTP links\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->629461856]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->400963415],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->717566164],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25669242],

Cell["\<\
Use internal selection criteria to remove JavaScript and SMTP links:\
\>", "ExampleText",
 CellID->334081550],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"address", ",", "source"}], "}"}], "=", 
   RowBox[{"GetSource", "[", "\"\<http://wolfram.com/\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"HyperlinkType", "\[Rule]", "\"\<Selected\>\""}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->712061981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"http://wolfram.com/index.ko.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ja.html\"\>", 
   ",", "\<\"http://wolfram.com/index.pt-br.html\"\>", 
   ",", "\<\"http://wolfram.com/index.ru.html\"\>", 
   ",", "\<\"http://wolfram.com/news/newsletter/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/connect/\"\>", 
   ",", "\<\"http://wolfram.com/system-modeler/\"\>"}], "}"}]], "Output",
 ImageSize->{503, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17828767]
}, Open  ]],

Cell["Return all extracted links:", "ExampleText",
 CellID->58060424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetHyperlinks", "[", 
  RowBox[{"address", ",", "source", ",", 
   RowBox[{"HyperlinkType", "\[Rule]", "\"\<Raw\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40980253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.wolfram.com/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/solutions/education/students/\"\>", 
   ",", "\<\"http://www.wolfram.com/mathematica-home-edition/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf-player/\"\>", 
   ",", "\<\"http://www.wolfram.com/cdf/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/webmathematica/\"\>", 
   ",", "\<\"http://www.wolfram.com/products/gridmathematica/\"\>", ",", 
   RowBox[{"\[LeftSkeleton]", "139", "\[RightSkeleton]"}], 
   ",", "\<\"index.ko.html\"\>", ",", "\<\"index.ja.html\"\>", 
   ",", "\<\"index.pt-br.html\"\>", ",", "\<\"index.ru.html\"\>", 
   ",", "\<\"/news/newsletter/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/connect/\"\>", 
   ",", "\<\"/connect/\"\>", ",", "\<\"/system-modeler/\"\>"}], 
  "}"}]], "Output",
 ImageSize->{519, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22816629]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["AbsoluteLinks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinks"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->363792060]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HyperlinkType - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 15.7931539}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "HyperlinkType is an option for GetHyperlinks that determines the type of \
hyperlinks returned by the function.", "synonyms" -> {}, "title" -> 
    "HyperlinkType", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/HyperlinkType"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6303, 185, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->400963415]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13407, 395}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[606, 21, 76, 1, 3, "SymbolColorBar"],
Cell[685, 24, 209, 5, 19, "LinkTrail"],
Cell[897, 31, 2813, 63, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3735, 98, 56, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[3794, 101, 655, 19, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4486, 125, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->293064520],
Cell[5069, 144, 604, 19, 70, "Notes",
 CellID->1067943069],
Cell[5676, 165, 62, 1, 70, "Notes",
 CellID->13890002],
Cell[5741, 168, 525, 12, 70, "2ColumnTableMod",
 CellID->629461856]
}, Closed]],
Cell[CellGroupData[{
Cell[6303, 185, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->400963415],
Cell[CellGroupData[{
Cell[6789, 202, 148, 5, 31, "ExampleSection",
 CellID->717566164],
Cell[6940, 209, 121, 3, 28, "Input",
 CellID->25669242],
Cell[7064, 214, 119, 3, 32, "ExampleText",
 CellID->334081550],
Cell[CellGroupData[{
Cell[7208, 221, 392, 12, 47, "Input",
 CellID->712061981],
Cell[7603, 235, 1351, 27, 224, "Output",
 CellID->17828767]
}, Open  ]],
Cell[8969, 265, 69, 1, 32, "ExampleText",
 CellID->58060424],
Cell[CellGroupData[{
Cell[9063, 270, 204, 5, 28, "Input",
 CellID->40980253],
Cell[9270, 277, 1150, 23, 70, "Output",
 CellID->22816629]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10481, 307, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10901, 321, 224, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11162, 332, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[11584, 346, 168, 3, 70, "MoreAbout",
 CellID->1665078683],
Cell[11755, 351, 147, 3, 70, "MoreAbout",
 CellID->363792060]
}, Open  ]],
Cell[11917, 357, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

