(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16061,        539]
NotebookOptionsPosition[     12291,        415]
NotebookOutlinePosition[     13944,        462]
CellTagsIndexPosition[     13859,        457]
WindowTitle->LogMessage - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"$LogFileName\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$LogFileName"], "\<\"$DebugLogging\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$DebugLogging"], "\<\"ReadList\"\>":>
       Documentation`HelpLookup["paclet:ref/ReadList"], "\<\"ToString\"\>":>
       Documentation`HelpLookup["paclet:ref/ToString"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Tuning & \
Debugging\"\>":>Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/LogMessage\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/LogMessage"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/LogMessage.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/LogMessage", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["LogMessage", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogMessage",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/LogMessage"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"loi\", \"TI\"]\)\>\"", ",", 
        StyleBox["msg", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]logs message ",
     Cell[BoxData[
      StyleBox["msg", "TI"]], "InlineFormula"],
     " with level of importance ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"loi\", \"TI\"]\)\>\""], "InlineFormula"],
     " to a file."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->25056990],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["LogMessage",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/LogMessage"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogMessage",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/LogMessage"]], "InlineFormula"],
 " recognizes the following levels of importance: ",
 Cell[BoxData["\"\<ERROR\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<INFO\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<DEBUG\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->596741572]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->149901957],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->440055278],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159652392],

Cell["Log a message to the log file:", "ExampleText",
 CellID->353047647],

Cell[BoxData[{
 RowBox[{
  RowBox[{"msg", "=", 
   RowBox[{"\"\<$DebugLogging is set to \>\"", "<>", 
    RowBox[{"ToString", "[", "$DebugLogging", "]"}], "<>", "\"\<.\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LogMessage", "[", 
  RowBox[{"\"\<INFO\>\"", ",", "msg"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->165509023],

Cell["Verify that the message has been appended to the log file:", \
"ExampleText",
 CellID->948477452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadList", "[", 
   RowBox[{"$LogFileName", ",", "String"}], "]"}], "//", "Last"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->130385095],

Cell[BoxData["\<\"[2012-09-24 19:44:12.003] INFO  : $DebugLogging is set to \
False.\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->114206387]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148930110],

Cell[TextData[{
 "By default, debug-level messages are not written to the log file.  Use ",
 Cell[BoxData[
  ButtonBox["$DebugLogging",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$DebugLogging"]], "InlineFormula"],
 " to enable it:"
}], "ExampleText",
 CellID->44803184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$DebugLogging", "=", "True"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108235086],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72975046]
}, Open  ]],

Cell[BoxData[
 RowBox[{"LogMessage", "[", 
  RowBox[{"\"\<DEBUG\>\"", ",", "\"\<Debug-level messages are enabled.\>\""}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->79040538],

Cell["Verify that the message has been appended to the log file:", \
"ExampleText",
 CellID->278344400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadList", "[", 
   RowBox[{"$LogFileName", ",", "String"}], "]"}], "//", "Last"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->584580850],

Cell[BoxData["\<\"[2012-09-24 19:44:38.109] DEBUG : Debug-level messages are \
enabled.\"\>"], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->528562457]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$LogFileName",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$LogFileName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DebugLogging",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$DebugLogging"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->508694380]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogMessage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 17.7831567}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "LogMessage[\"loi\", msg] logs message msg with level of importance \"loi\
\" to a file.", "synonyms" -> {}, "title" -> "LogMessage", "type" -> "Symbol",
     "uri" -> "RandomWalkWeb/ref/LogMessage"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6447, 191, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->149901957]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13716, 450}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[603, 21, 76, 1, 3, "SymbolColorBar"],
Cell[682, 24, 209, 5, 19, "LinkTrail"],
Cell[894, 31, 3071, 68, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3990, 103, 53, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4046, 106, 734, 22, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4817, 133, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->25056990],
Cell[5399, 152, 598, 19, 70, "Notes",
 CellID->1067943069],
Cell[6000, 173, 410, 13, 70, "Notes",
 CellID->596741572]
}, Closed]],
Cell[CellGroupData[{
Cell[6447, 191, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->149901957],
Cell[CellGroupData[{
Cell[6933, 208, 148, 5, 31, "ExampleSection",
 CellID->440055278],
Cell[7084, 215, 122, 3, 28, "Input",
 CellID->159652392],
Cell[7209, 220, 73, 1, 32, "ExampleText",
 CellID->353047647],
Cell[7285, 223, 341, 9, 47, "Input",
 CellID->165509023],
Cell[7629, 234, 103, 2, 32, "ExampleText",
 CellID->948477452],
Cell[CellGroupData[{
Cell[7757, 240, 171, 5, 28, "Input",
 CellID->130385095],
Cell[7931, 247, 232, 6, 36, "Output",
 CellID->114206387]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8212, 259, 231, 7, 32, "ExampleSection",
 CellID->1305812373],
Cell[8446, 268, 122, 3, 70, "Input",
 CellID->148930110],
Cell[8571, 273, 290, 8, 70, "ExampleText",
 CellID->44803184],
Cell[CellGroupData[{
Cell[8886, 285, 107, 3, 70, "Input",
 CellID->108235086],
Cell[8996, 290, 160, 5, 70, "Output",
 CellID->72975046]
}, Open  ]],
Cell[9171, 298, 183, 5, 70, "Input",
 CellID->79040538],
Cell[9357, 305, 103, 2, 70, "ExampleText",
 CellID->278344400],
Cell[CellGroupData[{
Cell[9485, 311, 171, 5, 70, "Input",
 CellID->584580850],
Cell[9659, 318, 235, 6, 70, "Output",
 CellID->528562457]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9955, 331, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[10375, 345, 1096, 38, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11508, 388, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[11930, 402, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[12101, 407, 148, 3, 17, "MoreAbout",
 CellID->508694380]
}, Open  ]],
Cell[12264, 413, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

