(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     24559,        875]
NotebookOptionsPosition[     18844,        680]
NotebookOutlinePosition[     20575,        728]
CellTagsIndexPosition[     20490,        723]
WindowTitle->PerformRandomWalks - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"$DataFilePrefix\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$DataFilePrefix"], "\<\"DateString\"\>":>
       Documentation`HelpLookup[
       "paclet:ref/DateString"], "\<\"GetStepData\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetStepData"], "\<\"RandomWalkGraph\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkGraph"], "\<\"RandomWalkWeb\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/RandomWalkWeb"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Random Number \
Generation\"\>":>Documentation`HelpLookup[
       "paclet:guide/RandomNumberGeneration"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/PerformRandomWalks\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/PerformRandomWalks"]}, Visible -> 
            False]]; SelectionMove[
         DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/PerformRandomWalks.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/PerformRandomWalks", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["PerformRandomWalks", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["PerformRandomWalks",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["w", "TI"]], ",", 
        StyleBox[
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["s", "TI"]], "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["w", "TI"]]], "InlineFormula"],
     " random walks on the Web originating from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     " and each having at most ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["s", "TI"]]], "InlineFormula"],
     " steps."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->186403075],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "If a notebook-based front end is being used, ",
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 " displays the current walk number in a temporary cell and the current \
step/URL in the window status area."
}], "Notes",
 CellID->199357990],

Cell[TextData[{
 "The root data directory is given by ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->258881562],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 " exports data to a specific folder.  The folder name is a 32-character, \
hexidecimal-formatted MD5 hash of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->3330439],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 " returns the number of successfully exported data files."
}], "Notes",
 CellID->365786975],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->223313794],

Cell[TextData[{
 "Both the number of random walks ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["w", "TI"]]], "InlineFormula"],
 " and the number of steps ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["s", "TI"]]], "InlineFormula"],
 " must be greater than or equal to 1."
}], "Notes",
 CellID->38767997]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->138910342],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->169408154],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87177602],

Cell["Perform multiple random walks on the Web:", "ExampleText",
 CellID->128132264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47865016],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->834686760]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159202963],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 " to change the base data directory:"
}], "ExampleText",
 CellID->190501847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$BaseDataDirectory", "=", "$TemporaryDirectory"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104488195],

Cell[BoxData["\<\"C:\\\\Users\\\\$UserName\\\\AppData\\\\Local\\\\Temp\"\>"], \
"Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161185181]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->541012001],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->280157781]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23500834],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110792157],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$DataFilePrefix",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$DataFilePrefix"]], "InlineFormula"],
 " to change the file name prefix:"
}], "ExampleText",
 CellID->218875408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$DataFilePrefix", "=", 
  RowBox[{"DateString", "[", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Year\>\"", ",", " ", "\"\<-\>\"", ",", "\"\<Month\>\"", ",", 
     "\"\<-\>\"", ",", "\"\<Day\>\"", ",", "\"\<_\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39701280],

Cell[BoxData["\<\"2012-09-24_\"\>"], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->424212825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13020116],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->49242592]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201346553],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<http://wolfram.com/\>\"", ",", 
     "\"\<http://wolframscience.com/\>\""}], "}"}], ",", "3", ",", "8"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->533802155]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->248500989],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->136550100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http:///\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->395304936],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->456655644]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13228848],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->637332244],

Cell["\<\
The number of random walks and steps must be greater than or equal to 1:\
\>", "ExampleText",
 CellID->271731252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"-", "3"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->199866750],

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\<\"http://wolfram.com/\"\>", ",", 
   RowBox[{"-", "3"}], ",", "8"}], "]"}]], "Output",
 ImageSize->{323, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->669685654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", 
   RowBox[{"-", "8"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25604214],

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\<\"http://wolfram.com/\"\>", ",", "3", ",", 
   RowBox[{"-", "8"}]}], "]"}]], "Output",
 ImageSize->{323, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->184115847]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DataFilePrefix",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$DataFilePrefix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetStepData",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkWeb",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->89198991]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PerformRandomWalks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 19.8031595}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "PerformRandomWalks[\"url\", n_w, n_s] performs n_w random walks on the \
Web originating from \"url\" and each having at most n_s steps.", 
    "synonyms" -> {}, "title" -> "PerformRandomWalks", "type" -> "Symbol", 
    "uri" -> "RandomWalkWeb/ref/PerformRandomWalks"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8571, 267, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->138910342]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20347, 716}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[611, 21, 76, 1, 3, "SymbolColorBar"],
Cell[690, 24, 209, 5, 19, "LinkTrail"],
Cell[902, 31, 3286, 73, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4213, 108, 61, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4277, 111, 1128, 35, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5442, 151, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->186403075],
Cell[6025, 170, 617, 20, 70, "Notes",
 CellID->1067943069],
Cell[6645, 192, 365, 10, 70, "Notes",
 CellID->199357990],
Cell[7013, 204, 250, 9, 70, "Notes",
 CellID->258881562],
Cell[7266, 215, 399, 12, 70, "Notes",
 CellID->3330439],
Cell[7668, 229, 264, 8, 70, "Notes",
 CellID->365786975],
Cell[7935, 239, 242, 8, 70, "Notes",
 CellID->223313794],
Cell[8180, 249, 354, 13, 70, "Notes",
 CellID->38767997]
}, Closed]],
Cell[CellGroupData[{
Cell[8571, 267, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->138910342],
Cell[CellGroupData[{
Cell[9057, 284, 148, 5, 31, "ExampleSection",
 CellID->169408154],
Cell[9208, 291, 121, 3, 28, "Input",
 CellID->87177602],
Cell[9332, 296, 84, 1, 32, "ExampleText",
 CellID->128132264],
Cell[CellGroupData[{
Cell[9441, 301, 172, 4, 28, "Input",
 CellID->47865016],
Cell[9616, 307, 158, 5, 36, "Output",
 CellID->834686760]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9823, 318, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[10047, 327, 122, 3, 70, "Input",
 CellID->159202963],
Cell[10172, 332, 258, 9, 70, "ExampleText",
 CellID->190501847],
Cell[CellGroupData[{
Cell[10455, 345, 127, 3, 70, "Input",
 CellID->104488195],
Cell[10585, 350, 220, 6, 70, "Output",
 CellID->161185181]
}, Open  ]],
Cell[CellGroupData[{
Cell[10842, 361, 173, 4, 70, "Input",
 CellID->541012001],
Cell[11018, 367, 158, 5, 70, "Output",
 CellID->280157781]
}, Open  ]],
Cell[CellGroupData[{
Cell[11213, 377, 124, 3, 70, "ExampleDelimiter",
 CellID->23500834],
Cell[11340, 382, 122, 3, 70, "Input",
 CellID->110792157],
Cell[11465, 387, 246, 8, 70, "ExampleText",
 CellID->218875408],
Cell[CellGroupData[{
Cell[11736, 399, 308, 9, 70, "Input",
 CellID->39701280],
Cell[12047, 410, 176, 5, 70, "Output",
 CellID->424212825]
}, Open  ]],
Cell[CellGroupData[{
Cell[12260, 420, 172, 4, 70, "Input",
 CellID->13020116],
Cell[12435, 426, 157, 5, 70, "Output",
 CellID->49242592]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12641, 437, 125, 3, 70, "ExampleDelimiter",
 CellID->201346553],
Cell[12769, 442, 122, 3, 70, "Input",
 CellID->139972119],
Cell[12894, 447, 247, 8, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[13166, 459, 269, 9, 70, "Input",
 CellID->475944353],
Cell[13438, 470, 203, 7, 70, "Output",
 CellID->533802155]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13702, 484, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[13936, 493, 122, 3, 70, "Input",
 CellID->248500989],
Cell[14061, 498, 254, 8, 70, "ExampleText",
 CellID->136550100],
Cell[CellGroupData[{
Cell[14340, 510, 162, 4, 70, "Input",
 CellID->395304936],
Cell[14505, 516, 158, 5, 70, "Output",
 CellID->456655644]
}, Open  ]],
Cell[CellGroupData[{
Cell[14700, 526, 124, 3, 70, "ExampleDelimiter",
 CellID->13228848],
Cell[14827, 531, 122, 3, 70, "Input",
 CellID->637332244],
Cell[14952, 536, 123, 3, 70, "ExampleText",
 CellID->271731252],
Cell[CellGroupData[{
Cell[15100, 543, 192, 5, 70, "Input",
 CellID->199866750],
Cell[15295, 550, 281, 8, 70, "Output",
 CellID->669685654]
}, Open  ]],
Cell[CellGroupData[{
Cell[15613, 563, 191, 5, 70, "Input",
 CellID->25604214],
Cell[15807, 570, 281, 8, 70, "Output",
 CellID->184115847]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16161, 586, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[16581, 600, 1434, 48, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[18052, 653, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[18474, 667, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[18645, 672, 157, 3, 17, "MoreAbout",
 CellID->89198991]
}, Open  ]],
Cell[18817, 678, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

