(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    272956,       6138]
NotebookOptionsPosition[    261925,       5757]
NotebookOutlinePosition[    263756,       5806]
CellTagsIndexPosition[    263669,       5801]
WindowTitle->RandomWalkGraph - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"PerformRandomWalks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/PerformRandomWalks"], "\<\"$DataFilePrefix\"\
\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/$DataFilePrefix"], "\<\"VertexType\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/VertexType"], "\<\"DateString\"\>":>
       Documentation`HelpLookup[
       "paclet:ref/DateString"], "\<\"ToGraphData\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/ToGraphData"], "\<\"Range\"\>":>
       Documentation`HelpLookup["paclet:ref/Range"], "\<\"Hyperlink\"\>":>
       Documentation`HelpLookup["paclet:ref/Hyperlink"], "\<\"Grid\"\>":>
       Documentation`HelpLookup["paclet:ref/Grid"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Data \
Visualization\"\>":>Documentation`HelpLookup[
       "paclet:guide/DataVisualization"], "\<\"Graphs & Networks\"\>":>
       Documentation`HelpLookup["paclet:guide/GraphsAndNetworks"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/RandomWalkGraph\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/RandomWalkGraph"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/RandomWalkGraph.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/RandomWalkGraph", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["RandomWalkGraph", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomWalkGraph",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["fn", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["fn", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a graph of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " steps extracted from each of the random walk data files ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["fn", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " originating from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     ".  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomWalkGraph",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"], "[", 
       StyleBox["stepData", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a graph using the specified ",
     Cell[BoxData[
      StyleBox["stepData", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->7359465],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graph",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graph"]], "InlineFormula"],
 ", with the following additions:"
}], "Notes"],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RefreshIconCache",
     BaseStyle->"Link",
     ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to refresh the icon cache", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexIcon",
     BaseStyle->"Link",
     ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to render vertices using standard graphics primitives or associated \
favorite icons\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}}],

Cell[TextData[{
 "The root data directory is given by ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->258881562],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomWalkGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["fn", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["fn", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " imports data from a specific folder.  The folder name must be a \
32-character, hexidecimal-formatted MD5 hash of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->3330439],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomWalkGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["fn", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["fn", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " accepts file numbers ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["fn", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " corresponding to positions in the sequence of random walks from ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->763870994],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomWalkGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"], "[", 
   StyleBox["stepData", "TI"], "]"}]], "InlineFormula"],
 " accepts ",
 Cell[BoxData[
  StyleBox["stepData", "TI"]], "InlineFormula"],
 " returned by ",
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->96512434],

Cell[TextData[{
 "The graph returned by ",
 Cell[BoxData[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], "InlineFormula"],
 " does not contain edges that connect a vertex to itself, nor does it \
contain duplicate edges."
}], "Notes",
 CellID->83648684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], "InlineFormula"],
 " returns a list of enumerated vertex labels in addition to the graph.  If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexIcon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"], " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", then the list also contains the associated favorite icons."
}], "Notes",
 CellID->534026890],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexIcon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"], " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and a notebook-based front end is being used, ",
 Cell[BoxData[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], "InlineFormula"],
 " displays the icon download progress in a temporary cell."
}], "Notes",
 CellID->919240060],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it is unable to import or process the requested data."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88763164],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->703909518],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->762936663],

Cell["Construct a graph from random walk data:", "ExampleText",
 CellID->281777683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5031720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}]], Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          DiskBox[{0., 0.49171600403719756`}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          
          DiskBox[{0.9870549567799676, 0.4917023249955501}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{3.801899036431133, 0.49201733434184985`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{3.075223556437642, 0.9833469445744307}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{3.0760930698520648`, 0.}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{2.573360905624395, 
         176.42663909437553`}, {-27.569839094375613`, 21.239306690989903`}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->619147823]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215520068],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199441994],

Cell["Construct a graph from multiple random walk data files:", "ExampleText",
 CellID->397859803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84781920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 3, 4, 5, 6, 7, 
        1}, {{{1, 2}, {3, 4}, {4, 1}, {4, 3}, {4, 5}, {4, 6}, {5, 4}, {6, 7}},
          Null}]], Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          
          DiskBox[{0.8140859052558821, 0.45714855912998636`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          DiskBox[{0., 0.}, 0.03443006385426714], "DynamicName", BoxID -> 
          "VertexID$2"], 
         TagBox[
          
          DiskBox[{2.3404289944058014`, 1.8324752840268963`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{1.8020559320938747`, 1.0515984511936183`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{1.2606626762505695`, 1.8297543645563343`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{2.79078236726949, 0.457620230872313}, 0.03443006385426714],
           "DynamicName", BoxID -> "VertexID$6"], 
         TagBox[
          
          DiskBox[{3.605538678138704, 0.0014283642127416174`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$7"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.026751335043226663`, 0.7}}], {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.312434252273612, 1.730102692474329}, {2.304733945907327, 
            1.704390610213496}, {2.2958063623115783`, 1.6790784759008108`}, {
            2.2856721493629495`, 1.6542248318976802`}, {2.274354745652184, 
            1.6298871601608427`}, {2.261880326274992, 1.6061217492970594`}, {
            2.2482777422938107`, 1.5829835643778094`}, {2.2335784540105523`, 
            1.5605261198150777`}, {2.0182292290857826`, 1.248175386681767}, {
            2.002467233279876, 1.226450622458948}, {1.985678984579902, 
            1.2055087840031122`}, {1.9679033111506707`, 
            1.1853983059764759`}, {1.94918132489074, 1.1661657002558394`}, {
            1.9295563263480737`, 1.147855448359078}, {1.9090737045737538`, 
            1.1305098985674844`}, {1.887780832145361, 1.1141691679818988`}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.8300506742260643`, 1.1539710427461853`}, {1.8377509805923493`, 
            1.1796831250070183`}, {1.8466785641880978`, 
            1.2049952593197037`}, {1.8568127771367267`, 
            1.2298489033228344`}, {1.8681301808474915`, 1.254186575059672}, {
            1.8806046002246843`, 1.2779519859234552`}, {1.8942071842058654`, 
            1.3010901708427052`}, {1.9089064724891234`, 
            1.3235476154054369`}, {2.124255697413894, 1.635898348538748}, {
            2.140017693219801, 1.657623112761567}, {2.1568059419197745`, 
            1.6785649512174028`}, {2.174581615349006, 1.6986754292440391`}, {
            2.193303601608937, 1.7179080349646756`}, {2.212928600151603, 
            1.736218286861437}, {2.233411221925923, 1.7535638366530306`}, {
            2.2547040943543153`, 1.7699045672386162`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.7161126354990208`, 1.1137701590201041`}, {1.6947621205898316`, 
            1.1300113383763382`}, {1.67421713678277, 1.147260223387737}, {
            1.6545252008874536`, 1.1654769205215096`}, {1.6357318567688806`, 
            1.1846192978715093`}, {1.6178805700127605`, 
            1.2046430826016656`}, {1.6010126273975192`, 
            1.2255019633410005`}, {1.585167041405493, 1.2471476972934021`}, {
            1.3686097390681708`, 1.5584100626384882`}, {1.353823157656833, 
            1.5807925871595236`}, {1.3401297794987352`, 
            1.6038601355422235`}, {1.3275612748862016`, 
            1.6275593567440603`}, {1.3161467124837027`, 1.651835438778201}, {
            1.3059124920973242`, 1.6766322354836607`}, {1.2968822836168183`, 
            1.7018923963811583`}, {1.2890769722714555`, 1.72755749931434}, 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], {
            1.346605972845424, 1.767582656729849}, {1.3679564877546129`, 
            1.751341477373615}, {1.3885014715616744`, 1.7340925923622161`}, {
            1.408193407456991, 1.7158758952284434`}, {1.4269867515755637`, 
            1.6967335178784437`}, {1.4448380383316837`, 
            1.6767097331482874`}, {1.461705980946925, 1.6558508524089526`}, {
            1.4775515669389516`, 1.634205118456551}, {1.6941088692762736`, 
            1.3229427531114648`}, {1.7088954506876115`, 
            1.3005602285904296`}, {1.7225888288457092`, 
            1.2774926802077295`}, {1.7351573334582429`, 
            1.2537934590058928`}, {1.7465718958607417`, 1.229517376971752}, {
            1.7568061162471202`, 1.2047205802662924`}, {1.765836324727626, 
            1.1794604193687948`}, {1.773641636072989, 1.153795316435613}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{2.58, 176.42000000000002`}, {-48.56320000000001, 
         42.356238094929495`}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"twitter.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{482, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36596958]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48075071],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219878613],

Cell["Construct a graph from the specified step data:", "ExampleText",
 CellID->164955485],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"stepData", "=", 
   RowBox[{"GetStepData", "[", 
    RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
     RowBox[{"{", "2", "}"}], ",", "7"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomWalkGraph", "[", "stepData", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->275433556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}]], Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          DiskBox[{0., 0.49171600403719756`}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          
          DiskBox[{0.9870549567799676, 0.4917023249955501}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{3.801899036431133, 0.49201733434184985`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{3.075223556437642, 0.9833469445744307}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{3.0760930698520648`, 0.}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{2.5733609056244022`, 
         176.42663909437556`}, {-27.569839094375606`, 21.239306690989896`}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126415148]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"stepData", "=", 
   RowBox[{"GetStepData", "[", 
    RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", "8"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomWalkGraph", "[", "stepData", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->412043414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 3, 4, 5, 6, 7, 
        1}, {{{1, 2}, {3, 4}, {4, 1}, {4, 3}, {4, 5}, {4, 6}, {5, 4}, {6, 7}},
          Null}]], Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          
          DiskBox[{0.8140859052558821, 0.45714855912998636`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          DiskBox[{0., 0.}, 0.03443006385426714], "DynamicName", BoxID -> 
          "VertexID$2"], 
         TagBox[
          
          DiskBox[{2.3404289944058014`, 1.8324752840268963`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{1.8020559320938747`, 1.0515984511936183`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{1.2606626762505695`, 1.8297543645563343`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{2.79078236726949, 0.457620230872313}, 0.03443006385426714],
           "DynamicName", BoxID -> "VertexID$6"], 
         TagBox[
          
          DiskBox[{3.605538678138704, 0.0014283642127416174`}, 
           0.03443006385426714], "DynamicName", BoxID -> "VertexID$7"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.026751335043226663`, 0.7}}], {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.312434252273612, 1.730102692474329}, {2.304733945907327, 
            1.704390610213496}, {2.2958063623115783`, 1.6790784759008108`}, {
            2.2856721493629495`, 1.6542248318976802`}, {2.274354745652184, 
            1.6298871601608427`}, {2.261880326274992, 1.6061217492970594`}, {
            2.2482777422938107`, 1.5829835643778094`}, {2.2335784540105523`, 
            1.5605261198150777`}, {2.0182292290857826`, 1.248175386681767}, {
            2.002467233279876, 1.226450622458948}, {1.985678984579902, 
            1.2055087840031122`}, {1.9679033111506707`, 
            1.1853983059764759`}, {1.94918132489074, 1.1661657002558394`}, {
            1.9295563263480737`, 1.147855448359078}, {1.9090737045737538`, 
            1.1305098985674844`}, {1.887780832145361, 1.1141691679818988`}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.8300506742260643`, 1.1539710427461853`}, {1.8377509805923493`, 
            1.1796831250070183`}, {1.8466785641880978`, 
            1.2049952593197037`}, {1.8568127771367267`, 
            1.2298489033228344`}, {1.8681301808474915`, 1.254186575059672}, {
            1.8806046002246843`, 1.2779519859234552`}, {1.8942071842058654`, 
            1.3010901708427052`}, {1.9089064724891234`, 
            1.3235476154054369`}, {2.124255697413894, 1.635898348538748}, {
            2.140017693219801, 1.657623112761567}, {2.1568059419197745`, 
            1.6785649512174028`}, {2.174581615349006, 1.6986754292440391`}, {
            2.193303601608937, 1.7179080349646756`}, {2.212928600151603, 
            1.736218286861437}, {2.233411221925923, 1.7535638366530306`}, {
            2.2547040943543153`, 1.7699045672386162`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.7161126354990208`, 1.1137701590201041`}, {1.6947621205898316`, 
            1.1300113383763382`}, {1.67421713678277, 1.147260223387737}, {
            1.6545252008874536`, 1.1654769205215096`}, {1.6357318567688806`, 
            1.1846192978715093`}, {1.6178805700127605`, 
            1.2046430826016656`}, {1.6010126273975192`, 
            1.2255019633410005`}, {1.585167041405493, 1.2471476972934021`}, {
            1.3686097390681708`, 1.5584100626384882`}, {1.353823157656833, 
            1.5807925871595236`}, {1.3401297794987352`, 
            1.6038601355422235`}, {1.3275612748862016`, 
            1.6275593567440603`}, {1.3161467124837027`, 1.651835438778201}, {
            1.3059124920973242`, 1.6766322354836607`}, {1.2968822836168183`, 
            1.7018923963811583`}, {1.2890769722714555`, 1.72755749931434}, 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], {
            1.346605972845424, 1.767582656729849}, {1.3679564877546129`, 
            1.751341477373615}, {1.3885014715616744`, 1.7340925923622161`}, {
            1.408193407456991, 1.7158758952284434`}, {1.4269867515755637`, 
            1.6967335178784437`}, {1.4448380383316837`, 
            1.6767097331482874`}, {1.461705980946925, 1.6558508524089526`}, {
            1.4775515669389516`, 1.634205118456551}, {1.6941088692762736`, 
            1.3229427531114648`}, {1.7088954506876115`, 
            1.3005602285904296`}, {1.7225888288457092`, 
            1.2774926802077295`}, {1.7351573334582429`, 
            1.2537934590058928`}, {1.7465718958607417`, 1.229517376971752}, {
            1.7568061162471202`, 1.2047205802662924`}, {1.765836324727626, 
            1.1794604193687948`}, {1.773641636072989, 1.153795316435613}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{2.58, 176.42000000000002`}, {-48.56320000000001, 
         42.356238094929495`}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"twitter.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{482, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19961489]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314157920],

Cell[TextData[{
 "Collect random walk data using ",
 Cell[BoxData[
  ButtonBox["PerformRandomWalks",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->281984562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47865016],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->834686760]
}, Open  ]],

Cell["Visualize the resulting data:", "ExampleText",
 CellID->219661359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomWalkGraph", "[", 
   RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
    RowBox[{"{", "2", "}"}], ",", " ", "7"}], "]"}], " ", "//", 
  "First"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->483337040],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 2, 3, 6, 
      5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, Null}]], 
    Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
       Directive[
        Hue[0.6, 0.2, 0.8], 
        EdgeForm[
         Directive[
          GrayLevel[0], 
          Opacity[0.7]]]], 
       TagBox[
        DiskBox[{0., 0.49171600403719756`}, 0.03572668623919646], 
        "DynamicName", BoxID -> "VertexID$1"], 
       TagBox[
        DiskBox[{0.9870549567799676, 0.4917023249955501}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$2"], 
       TagBox[
        DiskBox[{3.801899036431133, 0.49201733434184985`}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$3"], 
       TagBox[
        DiskBox[{3.075223556437642, 0.9833469445744307}, 0.03572668623919646],
         "DynamicName", BoxID -> "VertexID$4"], 
       TagBox[
        DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$5"], 
       TagBox[
        DiskBox[{3.0760930698520648`, 0.}, 0.03572668623919646], 
        "DynamicName", BoxID -> "VertexID$6"]}, {
       Directive[
        Opacity[0.7], 
        Hue[0.6, 0.7, 0.5]], 
       Arrowheads[{{0.02613296105421413, 0.7}}], {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$1", Automatic, Center], {
          0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
          0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
          0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
          0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
          0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
          0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
          0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
          0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
          0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
          0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
          0.882808477984095, 0.5281902142504762}, 
          DynamicLocation["VertexID$2", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$2", Automatic, Center], {
          0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
          0.44662695986215895`}, {0.8292687673842237, 0.43932435225865074`}, {
          0.8019883657668596, 0.4333263919339648}, {0.7744511423457023, 
          0.4286469510790709}, {0.7467207857084366, 0.42529685238929427`}, {
          0.7188614311247379, 0.4232838440333919}, {0.6909375122130618, 
          0.4226125817334466}, {0.2961155295010749, 0.4226180533501055}, {
          0.26819162920542106`, 0.4232900896136884}, {0.24033233042673346`, 
          0.4253038701431914}, {0.21260206665440107`, 0.4286547374306344}, {
          0.1850649729433194, 0.43333494152963414`}, {0.1577847375811776, 
          0.4393336579796202}, {0.130824454789036, 0.4466370128408428}, {
          0.10424647879587261`, 0.45522811478227143`}, 
          DynamicLocation["VertexID$1", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$2", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$3", Automatic, Center], 
          DynamicLocation["VertexID$4", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$5", Automatic, Center], 
          DynamicLocation["VertexID$6", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$6", Automatic, Center], 
          DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
    Typeset`data}, 
    TagBox[
     DynamicBox[GraphComputation`NetworkGraphicsBox[
      2, Typeset`graph, Typeset`boxes], {
      CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
       SynchronousUpdating -> False, TrackedSymbols :> {}},
      ImageSizeCache->{{2.573360905624395, 
       176.42663909437553`}, {-27.569839094375613`, 21.239306690989903`}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False,
    UnsavedVariables:>{Typeset`data}]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None]], "Output",
 ImageSize->{184, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->170865571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58987498],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6389288],

Cell[TextData[{
 "Quickly generate a list of file numbers using ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->520325747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "=", 
  RowBox[{"Range", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18888682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->190802610]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "fn", ",", "8"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->168213023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 5, 3, 7, 4, 6, 9, 8, 
        1}, {{{1, 2}, {3, 4}, {5, 6}, {6, 4}, {6, 7}, {4, 1}, {4, 3}, {4, 
         6}, {4, 8}, {4, 7}, {8, 5}, {8, 4}, {7, 9}, {7, 5}, {7, 8}}, Null}]],
       Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          
          DiskBox[{1.0464933386575046`, 0.5751185367885526}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          DiskBox[{0., 0.4110936389680635}, 0.041970690459596324`], 
          "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{1.937551614965157, 1.8047615615381254`}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{2.400026901753799, 0.8114110237501299}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          DiskBox[{3.8196641745046485`, 0.}, 0.041970690459596324`], 
          "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          
          DiskBox[{3.0939021484637608`, 0.05872682308113397}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$6"], 
         TagBox[
          
          DiskBox[{3.723602353038599, 0.7303774078184329}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$7"], 
         TagBox[
          
          DiskBox[{3.206823978974828, 0.714042573602088}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$8"], 
         TagBox[
          
          DiskBox[{4.813494240671665, 1.120853141965437}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$9"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.023475608551992745`, 0.7}}], {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.0231147163570062`, 1.716945053903231}, {2.044213158584813, 
            1.6942225470515662`}, {2.0641947528430795`, 
            1.6705119487258802`}, {2.0830132853397147`, 
            1.6458680972262236`}, {2.100625232232874, 1.6203479892974433`}, {
            2.116989860293688, 1.5940106483060823`}, {2.1320693211148134`, 
            1.5669169877300697`}, {2.1458287386469097`, 
            1.5391296702769315`}, {2.3308188533623664`, 
            1.1417894551617338`}, {2.3432264045760522`, 
            1.1133727478411486`}, {2.354253393062785, 1.0843923733270486`}, {
            2.3638743154044315`, 1.0549153579530315`}, {2.3720669201580344`, 
            1.0250098766926459`}, {2.378812259319351, 0.9947450954830808}, {
            2.3840947321461394`, 0.9641910112569372}, {2.387902121239838, 
            0.933418290052058}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.31446380036195, 0.8992275313850246}, {2.293365358134144, 
            0.9219500382366894}, {2.273383763875877, 0.9456606365623754}, {
            2.2545652313792415`, 0.970304488062032}, {2.2369532844860833`, 
            0.9958245959908121}, {2.220588656425268, 1.0221619369821733`}, {
            2.205509195604143, 1.0492555975581859`}, {2.1917497780720474`, 
            1.077042915011324}, {2.0067596633565903`, 1.474383130126522}, {
            1.9943521121429046`, 1.5027998374471072`}, {1.9833251236561715`, 
            1.5317802119612072`}, {1.9737042013145252`, 
            1.5612572273352243`}, {1.9655115965609222`, 
            1.5911627085956097`}, {1.9587662573996059`, 
            1.6214274898051748`}, {1.9534837845728172`, 
            1.6519815740313186`}, {1.9496763954791185`, 1.6827542952361978`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.501132895616635, 0.7575659798907435}, {2.5263675510405648`, 
            0.7433377804109367}, {2.550888963475172, 0.7279128062776192}, {
            2.5746404193548917`, 0.7113267326495607}, {2.597566985883584, 
            0.6936179200974129}, {2.619615638084099, 0.6748273258826899}, {
            2.640735381435401, 0.6549984092310728}, {2.660877369813618, 
            0.6341770308191284}, {2.938427468497603, 0.33310335055153006`}, {
            2.957545117148226, 0.3113376664393093}, {2.9755942104281665`, 
            0.2886780166941423}, {2.9925330040684974`, 0.2651768089632209}, {
            3.008322321721352, 0.24088839726424627`}, {3.0229256455676885`, 
            0.21586895627447472`}, {3.0363092007763606`, 
            0.19017635140890943`}, {3.0484420336191578`, 
            0.16387000498812382`}, 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.4888353214995407`, 0.8309507559449213}, {2.511407110098078, 
            0.8353508258859693}, {2.5341643424302527`, 0.838660604217307}, {
            2.557054385158103, 0.8408724360238311}, {2.5800242977773853`, 
            0.8419812057409908}, {2.603020955059329, 0.8419843489861588}, {
            2.625991169919624, 0.8408818584895807}, {2.648881816430471, 
            0.8386762841111894}, {2.9716006473188825`, 0.7997289040519727}, {
            2.9943587835795977`, 0.796425346884026}, {3.0169317741615966`, 
            0.7920314474532082}, {3.0392674118445657`, 0.7865573680494822}, {
            3.0613140383622626`, 0.7800157692225617}, {3.0830206638786866`, 
            0.7724217805003628}, {3.1043370849182956`, 0.7637929653971591}, {
            3.125214000477508, 0.7541492807923684}, 
            DynamicLocation["VertexID$8", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], {
            2.9927961546009256`, 0.11257186694052063`}, {2.967561499176996, 
            0.12680006642032726`}, {2.9430400867423883`, 
            0.14222504055364477`}, {2.9192886308626687`, 
            0.1588111141817033}, {2.8963620643339767`, 
            0.17651992673385114`}, {2.8743134121334624`, 
            0.19531052094857415`}, {2.85319366878216, 0.21513943760019116`}, {
            2.8330516804039427`, 0.2359608160121357}, {2.555501581719958, 
            0.5370344962797339}, {2.536383933069335, 0.5588001803919547}, {
            2.5183348397893948`, 0.5814598301371218}, {2.5013960461490634`, 
            0.6049610378680432}, {2.485606728496209, 0.6292494495670176}, {
            2.4710034046498723`, 0.6542688905567893}, {2.4576198494412003`, 
            0.6799614954223545}, {2.4454870165984026`, 0.7062678418431403}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$9", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$8", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$8", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$8", Automatic, Center], {
            3.1180155592290872`, 0.6945028414072969}, {3.09544377063055, 
            0.6901027714662489}, {3.0726865382983752`, 0.686792993134911}, {
            3.049796495570525, 0.6845811613283872}, {3.0268265829512426`, 
            0.6834723916112274}, {3.003829925669299, 0.6834692483660592}, {
            2.980859710809004, 0.6845717388626374}, {2.957969064298157, 
            0.6867773132410286}, {2.6352502334097454`, 0.7257246933002455}, {
            2.61249209714903, 0.7290282504681921}, {2.5899191065670313`, 
            0.7334221498990099}, {2.567583468884062, 0.7388962293027358}, {
            2.5455368423663653`, 0.7454378281296565}, {2.5238302168499414`, 
            0.7530318168518554}, {2.5025137958103323`, 0.7616606319550592}, {
            2.48163688025112, 0.7713043165598495}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{1.0478312387282793`, 
         177.95216876127174`}, {-38.09536876127173, 33.23930669098989}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"twitter.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{478, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->92101935]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127399744],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159202963],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$BaseDataDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$BaseDataDirectory"]], 
  "InlineFormula"],
 " to change the base data directory:"
}], "ExampleText",
 CellID->190501847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$BaseDataDirectory", "=", "$TemporaryDirectory"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104488195],

Cell[BoxData["\<\"C:\\\\Users\\\\$UserName\\\\AppData\\\\Local\\\\Temp\"\>"], \
"Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161185181]
}, Open  ]],

Cell["Collect and visualize the random walk data:", "ExampleText",
 CellID->690487144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83728472],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->565737287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomWalkGraph", "[", 
   RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
    RowBox[{"{", "2", "}"}], ",", " ", "7"}], "]"}], " ", "//", 
  "First"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->64316292],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 2, 3, 6, 
      5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, Null}]], 
    Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
       Directive[
        Hue[0.6, 0.2, 0.8], 
        EdgeForm[
         Directive[
          GrayLevel[0], 
          Opacity[0.7]]]], 
       TagBox[
        DiskBox[{0., 0.49171600403719756`}, 0.03572668623919646], 
        "DynamicName", BoxID -> "VertexID$1"], 
       TagBox[
        DiskBox[{0.9870549567799676, 0.4917023249955501}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$2"], 
       TagBox[
        DiskBox[{3.801899036431133, 0.49201733434184985`}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$3"], 
       TagBox[
        DiskBox[{3.075223556437642, 0.9833469445744307}, 0.03572668623919646],
         "DynamicName", BoxID -> "VertexID$4"], 
       TagBox[
        DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$5"], 
       TagBox[
        DiskBox[{3.0760930698520648`, 0.}, 0.03572668623919646], 
        "DynamicName", BoxID -> "VertexID$6"]}, {
       Directive[
        Opacity[0.7], 
        Hue[0.6, 0.7, 0.5]], 
       Arrowheads[{{0.02613296105421413, 0.7}}], {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$1", Automatic, Center], {
          0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
          0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
          0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
          0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
          0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
          0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
          0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
          0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
          0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
          0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
          0.882808477984095, 0.5281902142504762}, 
          DynamicLocation["VertexID$2", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$2", Automatic, Center], {
          0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
          0.44662695986215895`}, {0.8292687673842237, 0.43932435225865074`}, {
          0.8019883657668596, 0.4333263919339648}, {0.7744511423457023, 
          0.4286469510790709}, {0.7467207857084366, 0.42529685238929427`}, {
          0.7188614311247379, 0.4232838440333919}, {0.6909375122130618, 
          0.4226125817334466}, {0.2961155295010749, 0.4226180533501055}, {
          0.26819162920542106`, 0.4232900896136884}, {0.24033233042673346`, 
          0.4253038701431914}, {0.21260206665440107`, 0.4286547374306344}, {
          0.1850649729433194, 0.43333494152963414`}, {0.1577847375811776, 
          0.4393336579796202}, {0.130824454789036, 0.4466370128408428}, {
          0.10424647879587261`, 0.45522811478227143`}, 
          DynamicLocation["VertexID$1", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$2", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$3", Automatic, Center], 
          DynamicLocation["VertexID$4", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$5", Automatic, Center], 
          DynamicLocation["VertexID$6", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$6", Automatic, Center], 
          DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
    Typeset`data}, 
    TagBox[
     DynamicBox[GraphComputation`NetworkGraphicsBox[
      2, Typeset`graph, Typeset`boxes], {
      CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
       SynchronousUpdating -> False, TrackedSymbols :> {}},
      ImageSizeCache->{{2.573360905624395, 
       176.42663909437553`}, {-27.569839094375613`, 21.239306690989903`}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False,
    UnsavedVariables:>{Typeset`data}]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None]], "Output",
 ImageSize->{184, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->110083829]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23500834],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110792157],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$DataFilePrefix",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/$DataFilePrefix"]], "InlineFormula"],
 " to change the file name prefix:"
}], "ExampleText",
 CellID->218875408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$DataFilePrefix", "=", 
  RowBox[{"DateString", "[", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Year\>\"", ",", " ", "\"\<-\>\"", ",", "\"\<Month\>\"", ",", 
     "\"\<-\>\"", ",", "\"\<Day\>\"", ",", "\"\<_\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39701280],

Cell[BoxData["\<\"2012-09-24_\"\>"], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->424212825]
}, Open  ]],

Cell["Collect and visualize the random walk data:", "ExampleText",
 CellID->378963063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerformRandomWalks", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", "3", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->742437364],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32742712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomWalkGraph", "[", 
   RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
    RowBox[{"{", "2", "}"}], ",", " ", "7"}], "]"}], " ", "//", 
  "First"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8364289],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 4, 2, 3, 6, 
      5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, Null}]], 
    Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
       Directive[
        Hue[0.6, 0.2, 0.8], 
        EdgeForm[
         Directive[
          GrayLevel[0], 
          Opacity[0.7]]]], 
       TagBox[
        DiskBox[{0., 0.49171600403719756`}, 0.03572668623919646], 
        "DynamicName", BoxID -> "VertexID$1"], 
       TagBox[
        DiskBox[{0.9870549567799676, 0.4917023249955501}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$2"], 
       TagBox[
        DiskBox[{3.801899036431133, 0.49201733434184985`}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$3"], 
       TagBox[
        DiskBox[{3.075223556437642, 0.9833469445744307}, 0.03572668623919646],
         "DynamicName", BoxID -> "VertexID$4"], 
       TagBox[
        DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
         0.03572668623919646], "DynamicName", BoxID -> "VertexID$5"], 
       TagBox[
        DiskBox[{3.0760930698520648`, 0.}, 0.03572668623919646], 
        "DynamicName", BoxID -> "VertexID$6"]}, {
       Directive[
        Opacity[0.7], 
        Hue[0.6, 0.7, 0.5]], 
       Arrowheads[{{0.02613296105421413, 0.7}}], {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$1", Automatic, Center], {
          0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
          0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
          0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
          0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
          0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
          0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
          0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
          0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
          0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
          0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
          0.882808477984095, 0.5281902142504762}, 
          DynamicLocation["VertexID$2", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$2", Automatic, Center], {
          0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
          0.44662695986215895`}, {0.8292687673842237, 0.43932435225865074`}, {
          0.8019883657668596, 0.4333263919339648}, {0.7744511423457023, 
          0.4286469510790709}, {0.7467207857084366, 0.42529685238929427`}, {
          0.7188614311247379, 0.4232838440333919}, {0.6909375122130618, 
          0.4226125817334466}, {0.2961155295010749, 0.4226180533501055}, {
          0.26819162920542106`, 0.4232900896136884}, {0.24033233042673346`, 
          0.4253038701431914}, {0.21260206665440107`, 0.4286547374306344}, {
          0.1850649729433194, 0.43333494152963414`}, {0.1577847375811776, 
          0.4393336579796202}, {0.130824454789036, 0.4466370128408428}, {
          0.10424647879587261`, 0.45522811478227143`}, 
          DynamicLocation["VertexID$1", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$2", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$3", Automatic, Center], 
          DynamicLocation["VertexID$4", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$5", Automatic, Center], 
          DynamicLocation["VertexID$6", Automatic, Center]}]}, {
        Arrowheads[0.02613296105421413], 
        ArrowBox[{
          DynamicLocation["VertexID$6", Automatic, Center], 
          DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
    Typeset`data}, 
    TagBox[
     DynamicBox[GraphComputation`NetworkGraphicsBox[
      2, Typeset`graph, Typeset`boxes], {
      CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
       SynchronousUpdating -> False, TrackedSymbols :> {}},
      ImageSizeCache->{{2.573360905624395, 
       176.42663909437553`}, {-27.569839094375613`, 21.239306690989903`}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False,
    UnsavedVariables:>{Typeset`data}]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None]], "Output",
 ImageSize->{184, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->700417913]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RefreshIconCache",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362750520],

Cell["\<\
Download icons regardless of whether they already exist in the local icon \
cache:\
\>", "ExampleText",
 CellID->179344981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"RefreshIconCache", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexIcon", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->635038778],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}, {ImageSize -> 350, VertexShape -> {1 -> Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 4 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 6 -> 
           Image[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 5 -> 
           Image[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 3 -> 
           Image[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 2 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True]}, 
         VertexSize -> {Medium}}]], Typeset`boxes, Typeset`boxes$s2d = 
      GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {0., 
           0.49171600403719756`}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           0.9870549567799676, 0.4917023249955501}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$2"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.801899036431133, 0.49201733434184985`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$3"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.075223556437642, 0.9833469445744307}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$4"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.1782560923933993`, 0.49172094279313266`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$5"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.0760930698520648`, 0.}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{7.5, 341.7613065318021}, {-50.49999999999999, 
         46.88202046550722}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None,
    ImageSize->350], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], 
       ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"stephenwolfram.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframalpha.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram-media.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframscience.com\"\>"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->445669905]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexIcon",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180104251],

Cell["Render vertices using their associated favorite icons:", "ExampleText",
 CellID->9511472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"VertexIcon", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3085760],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}, {ImageSize -> 350, VertexShape -> {1 -> Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 4 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 6 -> 
           Image[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 5 -> 
           Image[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 3 -> 
           Image[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 2 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True]}, 
         VertexSize -> {Medium}}]], Typeset`boxes, Typeset`boxes$s2d = 
      GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {0., 
           0.49171600403719756`}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           0.9870549567799676, 0.4917023249955501}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$2"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.801899036431133, 0.49201733434184985`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$3"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.075223556437642, 0.9833469445744307}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$4"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.1782560923933993`, 0.49172094279313266`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$5"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.0760930698520648`, 0.}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{7.5, 341.7613065318021}, {-50.49999999999999, 
         46.88202046550722}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None,
    ImageSize->350], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], 
       ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"stephenwolfram.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframalpha.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram-media.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframscience.com\"\>"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90432115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "8", ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"VertexIcon", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->59355296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 3, 4, 5, 6, 7, 
        1}, {{{1, 2}, {3, 4}, {4, 1}, {4, 3}, {4, 5}, {4, 6}, {5, 4}, {6, 7}},
          Null}, {ImageSize -> 350, VertexShape -> {1 -> Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 4 -> 
           Image[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 7 -> 
           Image[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 6 -> 
           Image[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 5 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 3 -> 
           Image[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 2 -> 
           Image[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True]}, 
         VertexSize -> {Medium}}]], Typeset`boxes, Typeset`boxes$s2d = 
      GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           0.8140859052558821, 0.45714855912998636`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$1"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {0., 0.}, 
           Automatic, {0.18673196472494064`, 0.18673196472494064`}], 
          "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.3404289944058014`, 1.8324752840268963`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$3"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           1.8020559320938747`, 1.0515984511936183`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$4"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           1.2606626762505695`, 1.8297543645563343`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$5"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.79078236726949, 0.457620230872313}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$6"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.605538678138704, 0.0014283642127416174`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$7"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.026751335043226663`, 0.7}}], {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.312434252273612, 1.730102692474329}, {2.304733945907327, 
            1.704390610213496}, {2.2958063623115783`, 1.6790784759008108`}, {
            2.2856721493629495`, 1.6542248318976802`}, {2.274354745652184, 
            1.6298871601608427`}, {2.261880326274992, 1.6061217492970594`}, {
            2.2482777422938107`, 1.5829835643778094`}, {2.2335784540105523`, 
            1.5605261198150777`}, {2.0182292290857826`, 1.248175386681767}, {
            2.002467233279876, 1.226450622458948}, {1.985678984579902, 
            1.2055087840031122`}, {1.9679033111506707`, 
            1.1853983059764759`}, {1.94918132489074, 1.1661657002558394`}, {
            1.9295563263480737`, 1.147855448359078}, {1.9090737045737538`, 
            1.1305098985674844`}, {1.887780832145361, 1.1141691679818988`}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.8300506742260643`, 1.1539710427461853`}, {1.8377509805923493`, 
            1.1796831250070183`}, {1.8466785641880978`, 
            1.2049952593197037`}, {1.8568127771367267`, 
            1.2298489033228344`}, {1.8681301808474915`, 1.254186575059672}, {
            1.8806046002246843`, 1.2779519859234552`}, {1.8942071842058654`, 
            1.3010901708427052`}, {1.9089064724891234`, 
            1.3235476154054369`}, {2.124255697413894, 1.635898348538748}, {
            2.140017693219801, 1.657623112761567}, {2.1568059419197745`, 
            1.6785649512174028`}, {2.174581615349006, 1.6986754292440391`}, {
            2.193303601608937, 1.7179080349646756`}, {2.212928600151603, 
            1.736218286861437}, {2.233411221925923, 1.7535638366530306`}, {
            2.2547040943543153`, 1.7699045672386162`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.7161126354990208`, 1.1137701590201041`}, {1.6947621205898316`, 
            1.1300113383763382`}, {1.67421713678277, 1.147260223387737}, {
            1.6545252008874536`, 1.1654769205215096`}, {1.6357318567688806`, 
            1.1846192978715093`}, {1.6178805700127605`, 
            1.2046430826016656`}, {1.6010126273975192`, 
            1.2255019633410005`}, {1.585167041405493, 1.2471476972934021`}, {
            1.3686097390681708`, 1.5584100626384882`}, {1.353823157656833, 
            1.5807925871595236`}, {1.3401297794987352`, 
            1.6038601355422235`}, {1.3275612748862016`, 
            1.6275593567440603`}, {1.3161467124837027`, 1.651835438778201}, {
            1.3059124920973242`, 1.6766322354836607`}, {1.2968822836168183`, 
            1.7018923963811583`}, {1.2890769722714555`, 1.72755749931434}, 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], {
            1.346605972845424, 1.767582656729849}, {1.3679564877546129`, 
            1.751341477373615}, {1.3885014715616744`, 1.7340925923622161`}, {
            1.408193407456991, 1.7158758952284434`}, {1.4269867515755637`, 
            1.6967335178784437`}, {1.4448380383316837`, 
            1.6767097331482874`}, {1.461705980946925, 1.6558508524089526`}, {
            1.4775515669389516`, 1.634205118456551}, {1.6941088692762736`, 
            1.3229427531114648`}, {1.7088954506876115`, 
            1.3005602285904296`}, {1.7225888288457092`, 
            1.2774926802077295`}, {1.7351573334582429`, 
            1.2537934590058928`}, {1.7465718958607417`, 1.229517376971752}, {
            1.7568061162471202`, 1.2047205802662924`}, {1.765836324727626, 
            1.1794604193687948`}, {1.773641636072989, 1.153795316435613}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{8., 340.62166047222087`}, {-91., 
         86.10552098418097}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None,
    ImageSize->350], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"complex-systems.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], 
       ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"twitter.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframalpha.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram-media.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframscience.com\"\>"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{495, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21166485]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418918349],

Cell["\<\
Invalid file numbers and out of range step sizes are ignored:\
\>", "ExampleText",
 CellID->211706579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "7"}], ",", "1", ",", "2", ",", "3", ",", "20"}], "}"}], 
   ",", "100"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467215405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 5, 3, 7, 4, 6, 9, 8, 
        1}, {{{1, 2}, {3, 4}, {5, 6}, {6, 4}, {6, 7}, {4, 1}, {4, 3}, {4, 
         6}, {4, 8}, {4, 7}, {8, 5}, {8, 4}, {7, 9}, {7, 5}, {7, 8}}, Null}]],
       Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          
          DiskBox[{1.0464933386575046`, 0.5751185367885526}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          DiskBox[{0., 0.4110936389680635}, 0.041970690459596324`], 
          "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{1.937551614965157, 1.8047615615381254`}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{2.400026901753799, 0.8114110237501299}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          DiskBox[{3.8196641745046485`, 0.}, 0.041970690459596324`], 
          "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          
          DiskBox[{3.0939021484637608`, 0.05872682308113397}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$6"], 
         TagBox[
          
          DiskBox[{3.723602353038599, 0.7303774078184329}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$7"], 
         TagBox[
          
          DiskBox[{3.206823978974828, 0.714042573602088}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$8"], 
         TagBox[
          
          DiskBox[{4.813494240671665, 1.120853141965437}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$9"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.023475608551992745`, 0.7}}], {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.0231147163570062`, 1.716945053903231}, {2.044213158584813, 
            1.6942225470515662`}, {2.0641947528430795`, 
            1.6705119487258802`}, {2.0830132853397147`, 
            1.6458680972262236`}, {2.100625232232874, 1.6203479892974433`}, {
            2.116989860293688, 1.5940106483060823`}, {2.1320693211148134`, 
            1.5669169877300697`}, {2.1458287386469097`, 
            1.5391296702769315`}, {2.3308188533623664`, 
            1.1417894551617338`}, {2.3432264045760522`, 
            1.1133727478411486`}, {2.354253393062785, 1.0843923733270486`}, {
            2.3638743154044315`, 1.0549153579530315`}, {2.3720669201580344`, 
            1.0250098766926459`}, {2.378812259319351, 0.9947450954830808}, {
            2.3840947321461394`, 0.9641910112569372}, {2.387902121239838, 
            0.933418290052058}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.31446380036195, 0.8992275313850246}, {2.293365358134144, 
            0.9219500382366894}, {2.273383763875877, 0.9456606365623754}, {
            2.2545652313792415`, 0.970304488062032}, {2.2369532844860833`, 
            0.9958245959908121}, {2.220588656425268, 1.0221619369821733`}, {
            2.205509195604143, 1.0492555975581859`}, {2.1917497780720474`, 
            1.077042915011324}, {2.0067596633565903`, 1.474383130126522}, {
            1.9943521121429046`, 1.5027998374471072`}, {1.9833251236561715`, 
            1.5317802119612072`}, {1.9737042013145252`, 
            1.5612572273352243`}, {1.9655115965609222`, 
            1.5911627085956097`}, {1.9587662573996059`, 
            1.6214274898051748`}, {1.9534837845728172`, 
            1.6519815740313186`}, {1.9496763954791185`, 1.6827542952361978`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.501132895616635, 0.7575659798907435}, {2.5263675510405648`, 
            0.7433377804109367}, {2.550888963475172, 0.7279128062776192}, {
            2.5746404193548917`, 0.7113267326495607}, {2.597566985883584, 
            0.6936179200974129}, {2.619615638084099, 0.6748273258826899}, {
            2.640735381435401, 0.6549984092310728}, {2.660877369813618, 
            0.6341770308191284}, {2.938427468497603, 0.33310335055153006`}, {
            2.957545117148226, 0.3113376664393093}, {2.9755942104281665`, 
            0.2886780166941423}, {2.9925330040684974`, 0.2651768089632209}, {
            3.008322321721352, 0.24088839726424627`}, {3.0229256455676885`, 
            0.21586895627447472`}, {3.0363092007763606`, 
            0.19017635140890943`}, {3.0484420336191578`, 
            0.16387000498812382`}, 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.4888353214995407`, 0.8309507559449213}, {2.511407110098078, 
            0.8353508258859693}, {2.5341643424302527`, 0.838660604217307}, {
            2.557054385158103, 0.8408724360238311}, {2.5800242977773853`, 
            0.8419812057409908}, {2.603020955059329, 0.8419843489861588}, {
            2.625991169919624, 0.8408818584895807}, {2.648881816430471, 
            0.8386762841111894}, {2.9716006473188825`, 0.7997289040519727}, {
            2.9943587835795977`, 0.796425346884026}, {3.0169317741615966`, 
            0.7920314474532082}, {3.0392674118445657`, 0.7865573680494822}, {
            3.0613140383622626`, 0.7800157692225617}, {3.0830206638786866`, 
            0.7724217805003628}, {3.1043370849182956`, 0.7637929653971591}, {
            3.125214000477508, 0.7541492807923684}, 
            DynamicLocation["VertexID$8", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], {
            2.9927961546009256`, 0.11257186694052063`}, {2.967561499176996, 
            0.12680006642032726`}, {2.9430400867423883`, 
            0.14222504055364477`}, {2.9192886308626687`, 
            0.1588111141817033}, {2.8963620643339767`, 
            0.17651992673385114`}, {2.8743134121334624`, 
            0.19531052094857415`}, {2.85319366878216, 0.21513943760019116`}, {
            2.8330516804039427`, 0.2359608160121357}, {2.555501581719958, 
            0.5370344962797339}, {2.536383933069335, 0.5588001803919547}, {
            2.5183348397893948`, 0.5814598301371218}, {2.5013960461490634`, 
            0.6049610378680432}, {2.485606728496209, 0.6292494495670176}, {
            2.4710034046498723`, 0.6542688905567893}, {2.4576198494412003`, 
            0.6799614954223545}, {2.4454870165984026`, 0.7062678418431403}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$9", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$8", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$8", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$8", Automatic, Center], {
            3.1180155592290872`, 0.6945028414072969}, {3.09544377063055, 
            0.6901027714662489}, {3.0726865382983752`, 0.686792993134911}, {
            3.049796495570525, 0.6845811613283872}, {3.0268265829512426`, 
            0.6834723916112274}, {3.003829925669299, 0.6834692483660592}, {
            2.980859710809004, 0.6845717388626374}, {2.957969064298157, 
            0.6867773132410286}, {2.6352502334097454`, 0.7257246933002455}, {
            2.61249209714903, 0.7290282504681921}, {2.5899191065670313`, 
            0.7334221498990099}, {2.567583468884062, 0.7388962293027358}, {
            2.5455368423663653`, 0.7454378281296565}, {2.5238302168499414`, 
            0.7530318168518554}, {2.5025137958103323`, 0.7616606319550592}, {
            2.48163688025112, 0.7713043165598495}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{1.0478312387282793`, 
         177.95216876127174`}, {-38.09536876127173, 33.23930669098989}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"twitter.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{478, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->284259031]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82760349],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 5, 3, 7, 4, 6, 9, 8, 
        1}, {{{1, 2}, {3, 4}, {5, 6}, {6, 4}, {6, 7}, {4, 1}, {4, 3}, {4, 
         6}, {4, 8}, {4, 7}, {8, 5}, {8, 4}, {7, 9}, {7, 5}, {7, 8}}, Null}]],
       Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          
          DiskBox[{1.0464933386575046`, 0.5751185367885526}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          DiskBox[{0., 0.4110936389680635}, 0.041970690459596324`], 
          "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{1.937551614965157, 1.8047615615381254`}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{2.400026901753799, 0.8114110237501299}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          DiskBox[{3.8196641745046485`, 0.}, 0.041970690459596324`], 
          "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          
          DiskBox[{3.0939021484637608`, 0.05872682308113397}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$6"], 
         TagBox[
          
          DiskBox[{3.723602353038599, 0.7303774078184329}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$7"], 
         TagBox[
          
          DiskBox[{3.206823978974828, 0.714042573602088}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$8"], 
         TagBox[
          
          DiskBox[{4.813494240671665, 1.120853141965437}, 
           0.041970690459596324`], "DynamicName", BoxID -> "VertexID$9"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.023475608551992745`, 0.7}}], {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.0231147163570062`, 1.716945053903231}, {2.044213158584813, 
            1.6942225470515662`}, {2.0641947528430795`, 
            1.6705119487258802`}, {2.0830132853397147`, 
            1.6458680972262236`}, {2.100625232232874, 1.6203479892974433`}, {
            2.116989860293688, 1.5940106483060823`}, {2.1320693211148134`, 
            1.5669169877300697`}, {2.1458287386469097`, 
            1.5391296702769315`}, {2.3308188533623664`, 
            1.1417894551617338`}, {2.3432264045760522`, 
            1.1133727478411486`}, {2.354253393062785, 1.0843923733270486`}, {
            2.3638743154044315`, 1.0549153579530315`}, {2.3720669201580344`, 
            1.0250098766926459`}, {2.378812259319351, 0.9947450954830808}, {
            2.3840947321461394`, 0.9641910112569372}, {2.387902121239838, 
            0.933418290052058}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.31446380036195, 0.8992275313850246}, {2.293365358134144, 
            0.9219500382366894}, {2.273383763875877, 0.9456606365623754}, {
            2.2545652313792415`, 0.970304488062032}, {2.2369532844860833`, 
            0.9958245959908121}, {2.220588656425268, 1.0221619369821733`}, {
            2.205509195604143, 1.0492555975581859`}, {2.1917497780720474`, 
            1.077042915011324}, {2.0067596633565903`, 1.474383130126522}, {
            1.9943521121429046`, 1.5027998374471072`}, {1.9833251236561715`, 
            1.5317802119612072`}, {1.9737042013145252`, 
            1.5612572273352243`}, {1.9655115965609222`, 
            1.5911627085956097`}, {1.9587662573996059`, 
            1.6214274898051748`}, {1.9534837845728172`, 
            1.6519815740313186`}, {1.9496763954791185`, 1.6827542952361978`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.501132895616635, 0.7575659798907435}, {2.5263675510405648`, 
            0.7433377804109367}, {2.550888963475172, 0.7279128062776192}, {
            2.5746404193548917`, 0.7113267326495607}, {2.597566985883584, 
            0.6936179200974129}, {2.619615638084099, 0.6748273258826899}, {
            2.640735381435401, 0.6549984092310728}, {2.660877369813618, 
            0.6341770308191284}, {2.938427468497603, 0.33310335055153006`}, {
            2.957545117148226, 0.3113376664393093}, {2.9755942104281665`, 
            0.2886780166941423}, {2.9925330040684974`, 0.2651768089632209}, {
            3.008322321721352, 0.24088839726424627`}, {3.0229256455676885`, 
            0.21586895627447472`}, {3.0363092007763606`, 
            0.19017635140890943`}, {3.0484420336191578`, 
            0.16387000498812382`}, 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            2.4888353214995407`, 0.8309507559449213}, {2.511407110098078, 
            0.8353508258859693}, {2.5341643424302527`, 0.838660604217307}, {
            2.557054385158103, 0.8408724360238311}, {2.5800242977773853`, 
            0.8419812057409908}, {2.603020955059329, 0.8419843489861588}, {
            2.625991169919624, 0.8408818584895807}, {2.648881816430471, 
            0.8386762841111894}, {2.9716006473188825`, 0.7997289040519727}, {
            2.9943587835795977`, 0.796425346884026}, {3.0169317741615966`, 
            0.7920314474532082}, {3.0392674118445657`, 0.7865573680494822}, {
            3.0613140383622626`, 0.7800157692225617}, {3.0830206638786866`, 
            0.7724217805003628}, {3.1043370849182956`, 0.7637929653971591}, {
            3.125214000477508, 0.7541492807923684}, 
            DynamicLocation["VertexID$8", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], {
            2.9927961546009256`, 0.11257186694052063`}, {2.967561499176996, 
            0.12680006642032726`}, {2.9430400867423883`, 
            0.14222504055364477`}, {2.9192886308626687`, 
            0.1588111141817033}, {2.8963620643339767`, 
            0.17651992673385114`}, {2.8743134121334624`, 
            0.19531052094857415`}, {2.85319366878216, 0.21513943760019116`}, {
            2.8330516804039427`, 0.2359608160121357}, {2.555501581719958, 
            0.5370344962797339}, {2.536383933069335, 0.5588001803919547}, {
            2.5183348397893948`, 0.5814598301371218}, {2.5013960461490634`, 
            0.6049610378680432}, {2.485606728496209, 0.6292494495670176}, {
            2.4710034046498723`, 0.6542688905567893}, {2.4576198494412003`, 
            0.6799614954223545}, {2.4454870165984026`, 0.7062678418431403}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$9", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$7", Automatic, Center], 
            DynamicLocation["VertexID$8", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$8", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.023475608551992745`], 
          ArrowBox[{
            DynamicLocation["VertexID$8", Automatic, Center], {
            3.1180155592290872`, 0.6945028414072969}, {3.09544377063055, 
            0.6901027714662489}, {3.0726865382983752`, 0.686792993134911}, {
            3.049796495570525, 0.6845811613283872}, {3.0268265829512426`, 
            0.6834723916112274}, {3.003829925669299, 0.6834692483660592}, {
            2.980859710809004, 0.6845717388626374}, {2.957969064298157, 
            0.6867773132410286}, {2.6352502334097454`, 0.7257246933002455}, {
            2.61249209714903, 0.7290282504681921}, {2.5899191065670313`, 
            0.7334221498990099}, {2.567583468884062, 0.7388962293027358}, {
            2.5455368423663653`, 0.7454378281296565}, {2.5238302168499414`, 
            0.7530318168518554}, {2.5025137958103323`, 0.7616606319550592}, {
            2.48163688025112, 0.7713043165598495}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{1.0478312387282793`, 
         177.95216876127174`}, {-38.09536876127173, 33.23930669098989}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"complex-systems.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"twitter.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{478, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9574339]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283851897],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->136550100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http:///\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30964636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$Failed", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->847376425]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187551867],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121226319],

Cell["At least one valid file must be specified:", "ExampleText",
 CellID->98111338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"-", "7"}], "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->316349048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$Failed", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->687628582]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "7"}], ",", "2"}], "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->228371998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}]], Typeset`boxes, Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          DiskBox[{0., 0.49171600403719756`}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          
          DiskBox[{0.9870549567799676, 0.4917023249955501}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{3.801899036431133, 0.49201733434184985`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{3.075223556437642, 0.9833469445744307}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
           0.03572668623919646], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{3.0760930698520648`, 0.}, 0.03572668623919646], 
          "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{2.573360905624395, 
         176.42663909437553`}, {-27.569839094375613`, 21.239306690989903`}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->555679964]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399604478],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129130089],

Cell["The number of steps must be greater than or equal to 1:", "ExampleText",
 CellID->271731252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"-", "7"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->431987857],

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\<\"http://wolfram.com/\"\>", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"-", "7"}]}], "]"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14437741]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310730134],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103845567],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexIcon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"], " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " ignores the value of ",
 Cell[BoxData[
  ButtonBox["RefreshIconCache",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3187032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"RefreshIconCache", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexIcon", "\[Rule]", "False"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546560914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}, {ImageSize -> 350, VertexSize -> {Medium}}]], Typeset`boxes, 
      Typeset`boxes$s2d = GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          DiskBox[{0., 0.49171600403719756`}, 0.08768553805586388], 
          "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          
          DiskBox[{0.9870549567799676, 0.4917023249955501}, 
           0.08768553805586388], "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          
          DiskBox[{3.801899036431133, 0.49201733434184985`}, 
           0.08768553805586388], "DynamicName", BoxID -> "VertexID$3"], 
         TagBox[
          
          DiskBox[{3.075223556437642, 0.9833469445744307}, 
           0.08768553805586388], "DynamicName", BoxID -> "VertexID$4"], 
         TagBox[
          
          DiskBox[{2.1782560923933993`, 0.49172094279313266`}, 
           0.08768553805586388], "DynamicName", BoxID -> "VertexID$5"], 
         TagBox[
          DiskBox[{3.0760930698520648`, 0.}, 0.08768553805586388], 
          "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{5.9799999999999995`, 343.02}, {-52.299200000000006`,
          47.309681133417605`}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None,
    ImageSize->350], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\<\"stephenwolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\<\"wolframalpha.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\<\"wolfram.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\<\"wolfram-media.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\<\"wolframscience.com\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69303955]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80168887],

Cell["Create a random Web graph and key with clickable links:", "ExampleText",
 CellID->307921457],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"url", "=", "\"\<http://wolfram.com/\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fn", "=", 
   RowBox[{"Range", "[", "3", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"n", "=", "8"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"graph", ",", "key"}], "}"}], "=", 
   RowBox[{"RandomWalkGraph", "[", 
    RowBox[{"url", ",", "fn", ",", "n", ",", 
     RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "525"}], ",", 
     RowBox[{"VertexIcon", "\[Rule]", "True"}], ",", 
     RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
     RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"key", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Hyperlink", "[", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", 
       RowBox[{"\"\<http://www.\>\"", "<>", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "<>", "\"\</\>\""}]}], "]"}], "&"}], 
    "/@", "key"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrependTo", "[", 
    RowBox[{"key", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Key\>\"", ",", "SpanFromLeft"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "graph", "\
\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{"key", ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->752732513],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{2, 5, 3, 7, 4, 6, 9, 8, 
      1}, {{{1, 2}, {3, 4}, {5, 6}, {6, 4}, {6, 7}, {4, 1}, {4, 3}, {4, 6}, {
       4, 8}, {4, 7}, {8, 5}, {8, 4}, {7, 9}, {7, 5}, {7, 8}}, Null}, {
      ImagePadding -> 10, ImageSize -> 525, VertexLabels -> {"Name"}, 
       VertexShape -> {1 -> Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 4 -> 
         Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 7 -> 
         Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 6 -> 
         Image[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 9 -> 
         Image[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 8 -> 
         Image[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 5 -> 
         Image[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 3 -> 
         Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 2 -> 
         Image[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
           "], "Byte", ColorSpace -> "RGB", Interleaving -> True]}, 
       VertexSize -> {Medium}}]], Typeset`boxes, Typeset`boxes$s2d = 
    GraphicsGroupBox[{{
       Directive[
        Hue[0.6, 0.2, 0.8], 
        EdgeForm[
         Directive[
          GrayLevel[0], 
          Opacity[0.7]]]], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           1.0464933386575046`, 0.5751185367885526}, Automatic, {
           0.10340729465736356`, 0.10340729465736356`}], "DynamicName", BoxID -> 
          "VertexID$1"], 
         InsetBox[
          FormBox["2", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$1", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$1"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {0., 
           0.4110936389680635}, Automatic, {0.10340729465736356`, 
           0.10340729465736356`}], "DynamicName", BoxID -> "VertexID$2"], 
         InsetBox[
          FormBox["5", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$2", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$2"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           1.937551614965157, 1.8047615615381254`}, Automatic, {
           0.10340729465736356`, 0.10340729465736356`}], "DynamicName", BoxID -> 
          "VertexID$3"], 
         InsetBox[
          FormBox["3", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$3", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$3"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.400026901753799, 0.8114110237501299}, Automatic, {
           0.10340729465736356`, 0.10340729465736356`}], "DynamicName", BoxID -> 
          "VertexID$4"], 
         InsetBox[
          FormBox["7", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$4", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$4"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.8196641745046485`, 0.}, Automatic, {0.10340729465736356`, 
           0.10340729465736356`}], "DynamicName", BoxID -> "VertexID$5"], 
         InsetBox[
          FormBox["4", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$5", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$5"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.0939021484637608`, 0.05872682308113397}, Automatic, {
           0.10340729465736356`, 0.10340729465736356`}], "DynamicName", BoxID -> 
          "VertexID$6"], 
         InsetBox[
          FormBox["6", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$6", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$6"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.723602353038599, 0.7303774078184329}, Automatic, {
           0.10340729465736356`, 0.10340729465736356`}], "DynamicName", BoxID -> 
          "VertexID$7"], 
         InsetBox[
          FormBox["9", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$7", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$7"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.206823978974828, 0.714042573602088}, Automatic, {
           0.10340729465736356`, 0.10340729465736356`}], "DynamicName", BoxID -> 
          "VertexID$8"], 
         InsetBox[
          FormBox["8", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$8", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$8"], 
       TagBox[{
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           4.813494240671665, 1.120853141965437}, Automatic, {
           0.10340729465736356`, 0.10340729465736356`}], "DynamicName", BoxID -> 
          "VertexID$9"], 
         InsetBox[
          FormBox["1", TraditionalForm], 
          Offset[{2, 2}, 
           DynamicLocation["VertexID$9", Automatic, {Right, Top}]], 
          ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$9"]}, {
       Directive[
        Opacity[0.7], 
        Hue[0.6, 0.7, 0.5]], 
       Arrowheads[{{0.023475608551992745`, 0.7}}], {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$1", Automatic, Center], 
          DynamicLocation["VertexID$2", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$3", Automatic, Center], {
          2.0231147163570062`, 1.716945053903231}, {2.044213158584813, 
          1.6942225470515662`}, {2.0641947528430795`, 1.6705119487258802`}, {
          2.0830132853397147`, 1.6458680972262236`}, {2.100625232232874, 
          1.6203479892974433`}, {2.116989860293688, 1.5940106483060823`}, {
          2.1320693211148134`, 1.5669169877300697`}, {2.1458287386469097`, 
          1.5391296702769315`}, {2.3308188533623664`, 1.1417894551617338`}, {
          2.3432264045760522`, 1.1133727478411486`}, {2.354253393062785, 
          1.0843923733270486`}, {2.3638743154044315`, 1.0549153579530315`}, {
          2.3720669201580344`, 1.0250098766926459`}, {2.378812259319351, 
          0.9947450954830808}, {2.3840947321461394`, 0.9641910112569372}, {
          2.387902121239838, 0.933418290052058}, 
          DynamicLocation["VertexID$4", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], 
          DynamicLocation["VertexID$1", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], {2.31446380036195,
           0.8992275313850246}, {2.293365358134144, 0.9219500382366894}, {
          2.273383763875877, 0.9456606365623754}, {2.2545652313792415`, 
          0.970304488062032}, {2.2369532844860833`, 0.9958245959908121}, {
          2.220588656425268, 1.0221619369821733`}, {2.205509195604143, 
          1.0492555975581859`}, {2.1917497780720474`, 1.077042915011324}, {
          2.0067596633565903`, 1.474383130126522}, {1.9943521121429046`, 
          1.5027998374471072`}, {1.9833251236561715`, 1.5317802119612072`}, {
          1.9737042013145252`, 1.5612572273352243`}, {1.9655115965609222`, 
          1.5911627085956097`}, {1.9587662573996059`, 1.6214274898051748`}, {
          1.9534837845728172`, 1.6519815740313186`}, {1.9496763954791185`, 
          1.6827542952361978`}, 
          DynamicLocation["VertexID$3", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], {
          2.501132895616635, 0.7575659798907435}, {2.5263675510405648`, 
          0.7433377804109367}, {2.550888963475172, 0.7279128062776192}, {
          2.5746404193548917`, 0.7113267326495607}, {2.597566985883584, 
          0.6936179200974129}, {2.619615638084099, 0.6748273258826899}, {
          2.640735381435401, 0.6549984092310728}, {2.660877369813618, 
          0.6341770308191284}, {2.938427468497603, 0.33310335055153006`}, {
          2.957545117148226, 0.3113376664393093}, {2.9755942104281665`, 
          0.2886780166941423}, {2.9925330040684974`, 0.2651768089632209}, {
          3.008322321721352, 0.24088839726424627`}, {3.0229256455676885`, 
          0.21586895627447472`}, {3.0363092007763606`, 
          0.19017635140890943`}, {3.0484420336191578`, 0.16387000498812382`}, 
          DynamicLocation["VertexID$6", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], {
          2.4888353214995407`, 0.8309507559449213}, {2.511407110098078, 
          0.8353508258859693}, {2.5341643424302527`, 0.838660604217307}, {
          2.557054385158103, 0.8408724360238311}, {2.5800242977773853`, 
          0.8419812057409908}, {2.603020955059329, 0.8419843489861588}, {
          2.625991169919624, 0.8408818584895807}, {2.648881816430471, 
          0.8386762841111894}, {2.9716006473188825`, 0.7997289040519727}, {
          2.9943587835795977`, 0.796425346884026}, {3.0169317741615966`, 
          0.7920314474532082}, {3.0392674118445657`, 0.7865573680494822}, {
          3.0613140383622626`, 0.7800157692225617}, {3.0830206638786866`, 
          0.7724217805003628}, {3.1043370849182956`, 0.7637929653971591}, {
          3.125214000477508, 0.7541492807923684}, 
          DynamicLocation["VertexID$8", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$4", Automatic, Center], 
          DynamicLocation["VertexID$7", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$5", Automatic, Center], 
          DynamicLocation["VertexID$6", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$6", Automatic, Center], {
          2.9927961546009256`, 0.11257186694052063`}, {2.967561499176996, 
          0.12680006642032726`}, {2.9430400867423883`, 
          0.14222504055364477`}, {2.9192886308626687`, 0.1588111141817033}, {
          2.8963620643339767`, 0.17651992673385114`}, {2.8743134121334624`, 
          0.19531052094857415`}, {2.85319366878216, 0.21513943760019116`}, {
          2.8330516804039427`, 0.2359608160121357}, {2.555501581719958, 
          0.5370344962797339}, {2.536383933069335, 0.5588001803919547}, {
          2.5183348397893948`, 0.5814598301371218}, {2.5013960461490634`, 
          0.6049610378680432}, {2.485606728496209, 0.6292494495670176}, {
          2.4710034046498723`, 0.6542688905567893}, {2.4576198494412003`, 
          0.6799614954223545}, {2.4454870165984026`, 0.7062678418431403}, 
          DynamicLocation["VertexID$4", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$6", Automatic, Center], 
          DynamicLocation["VertexID$7", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$7", Automatic, Center], 
          DynamicLocation["VertexID$9", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$7", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$7", Automatic, Center], 
          DynamicLocation["VertexID$8", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$8", Automatic, Center], 
          DynamicLocation["VertexID$5", Automatic, Center]}]}, {
        Arrowheads[0.023475608551992745`], 
        ArrowBox[{
          DynamicLocation["VertexID$8", Automatic, Center], {
          3.1180155592290872`, 0.6945028414072969}, {3.09544377063055, 
          0.6901027714662489}, {3.0726865382983752`, 0.686792993134911}, {
          3.049796495570525, 0.6845811613283872}, {3.0268265829512426`, 
          0.6834723916112274}, {3.003829925669299, 0.6834692483660592}, {
          2.980859710809004, 0.6845717388626374}, {2.957969064298157, 
          0.6867773132410286}, {2.6352502334097454`, 0.7257246933002455}, {
          2.61249209714903, 0.7290282504681921}, {2.5899191065670313`, 
          0.7334221498990099}, {2.567583468884062, 0.7388962293027358}, {
          2.5455368423663653`, 0.7454378281296565}, {2.5238302168499414`, 
          0.7530318168518554}, {2.5025137958103323`, 0.7616606319550592}, {
          2.48163688025112, 0.7713043165598495}, 
          DynamicLocation["VertexID$4", Automatic, Center]}]}}}], 
    Typeset`data}, 
    TagBox[
     DynamicBox[GraphComputation`NetworkGraphicsBox[
      2, Typeset`graph, Typeset`boxes], {
      CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
       SynchronousUpdating -> False, TrackedSymbols :> {}},
      ImageSizeCache->{{14.685142529869413`, 
       516.9000000000001}, {-111.71885747013057`, 94.46590794770218}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False,
    UnsavedVariables:>{Typeset`data}]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None,
  ImagePadding->10,
  ImageSize->525]], "Output",
 ImageSize->{529, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299179827],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Key\"\>", "\[SpanFromLeft]", "\[SpanFromLeft]"},
    {"1", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"complex-systems.com\"\>", True->
        StyleBox["\<\"complex-systems.com\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.complex-systems.com/"], None},
       ButtonNote->"http://www.complex-systems.com/"],
      Annotation[#, "http://www.complex-systems.com/", "Hyperlink"]& ]},
    {"2", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"computerbasedmath.org\"\>", True->
        StyleBox["\<\"computerbasedmath.org\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.computerbasedmath.org/"], None},
       ButtonNote->"http://www.computerbasedmath.org/"],
      Annotation[#, "http://www.computerbasedmath.org/", "Hyperlink"]& ]},
    {"3", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"mathematica-journal.com\"\>", True->
        StyleBox["\<\"mathematica-journal.com\"\>", "HyperlinkActive"]}, 
        Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.mathematica-journal.com/"], None},
       ButtonNote->"http://www.mathematica-journal.com/"],
      Annotation[#, "http://www.mathematica-journal.com/", "Hyperlink"]& ]},
    {"4", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"stephenwolfram.com\"\>", True->
        StyleBox["\<\"stephenwolfram.com\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.stephenwolfram.com/"], None},
       ButtonNote->"http://www.stephenwolfram.com/"],
      Annotation[#, "http://www.stephenwolfram.com/", "Hyperlink"]& ]},
    {"5", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"twitter.com\"\>", True->
        StyleBox["\<\"twitter.com\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.twitter.com/"], None},
       ButtonNote->"http://www.twitter.com/"],
      Annotation[#, "http://www.twitter.com/", "Hyperlink"]& ]},
    {"6", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"wolframalpha.com\"\>", True->
        StyleBox["\<\"wolframalpha.com\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.wolframalpha.com/"], None},
       ButtonNote->"http://www.wolframalpha.com/"],
      Annotation[#, "http://www.wolframalpha.com/", "Hyperlink"]& ]},
    {"7", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"wolfram.com\"\>", True->
        StyleBox["\<\"wolfram.com\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.wolfram.com/"], None},
       ButtonNote->"http://www.wolfram.com/"],
      Annotation[#, "http://www.wolfram.com/", "Hyperlink"]& ]},
    {"8", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"wolfram-media.com\"\>", True->
        StyleBox["\<\"wolfram-media.com\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.wolfram-media.com/"], None},
       ButtonNote->"http://www.wolfram-media.com/"],
      Annotation[#, "http://www.wolfram-media.com/", "Hyperlink"]& ]},
    {"9", 
     GraphicsBox[
      TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
        "], {{0, 16}, {16, 0}}, {0, 255},
        ColorFunction->RGBColor],
       BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
       Selectable->False],
      BaseStyle->"ImageGraphics",
      ImageSizeRaw->{16, 16},
      PlotRange->{{0, 16}, {0, 16}}], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"wolframscience.com\"\>", True->
        StyleBox["\<\"wolframscience.com\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaseStyle->{"Hyperlink"},
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{
         URL["http://www.wolframscience.com/"], None},
       ButtonNote->"http://www.wolframscience.com/"],
      Annotation[#, "http://www.wolframscience.com/", "Hyperlink"]& ]}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ImageSize->{218, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56014451]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PerformRandomWalks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DataFilePrefix",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/$DataFilePrefix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexType",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToGraphData",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyperlink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyperlink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->345908322],

Cell[TextData[ButtonBox["Graphs & Networks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphsAndNetworks"]], "MoreAbout",
 CellID->698959272]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomWalkGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 23.3631645}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "RandomWalkGraph[\"url\", {fn_1, fn_2, ...}, n] constructs a graph of the \
first n steps extracted from each of the random walk data files fn_i \
originating from \"url\". RandomWalkGraph[stepData] constructs a graph using \
the specified stepData.", "synonyms" -> {}, "title" -> "RandomWalkGraph", 
    "type" -> "Symbol", "uri" -> "RandomWalkWeb/ref/RandomWalkGraph"}, 
  "LinkTrails" -> "", "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13100, 403, 460, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->88763164]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 263526, 5794}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[608, 21, 76, 1, 3, "SymbolColorBar"],
Cell[687, 24, 209, 5, 19, "LinkTrail"],
Cell[899, 31, 3567, 77, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4491, 112, 58, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4552, 115, 1630, 48, 166, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6219, 168, 578, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->7359465],
Cell[6800, 187, 608, 19, 70, "Notes",
 CellID->1067943069],
Cell[7411, 208, 502, 16, 70, "Notes"],
Cell[7916, 226, 904, 24, 70, "3ColumnTableMod"],
Cell[8823, 252, 250, 9, 70, "Notes",
 CellID->258881562],
Cell[9076, 263, 768, 24, 70, "Notes",
 CellID->3330439],
Cell[9847, 289, 848, 28, 70, "Notes",
 CellID->763870994],
Cell[10698, 319, 492, 17, 70, "Notes",
 CellID->96512434],
Cell[11193, 338, 320, 9, 70, "Notes",
 CellID->83648684],
Cell[11516, 349, 588, 16, 70, "Notes",
 CellID->534026890],
Cell[12107, 367, 566, 17, 70, "Notes",
 CellID->919240060],
Cell[12676, 386, 387, 12, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[13100, 403, 460, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88763164],
Cell[CellGroupData[{
Cell[13585, 420, 148, 5, 31, "ExampleSection",
 CellID->703909518],
Cell[13736, 427, 122, 3, 28, "Input",
 CellID->762936663],
Cell[13861, 432, 83, 1, 32, "ExampleText",
 CellID->281777683],
Cell[CellGroupData[{
Cell[13969, 437, 192, 5, 28, "Input",
 CellID->5031720],
Cell[14164, 444, 5904, 124, 118, "Output",
 CellID->619147823]
}, Open  ]],
Cell[CellGroupData[{
Cell[20105, 573, 125, 3, 8, "ExampleDelimiter",
 CellID->215520068],
Cell[20233, 578, 122, 3, 28, "Input",
 CellID->199441994],
Cell[20358, 583, 98, 1, 32, "ExampleText",
 CellID->397859803],
Cell[CellGroupData[{
Cell[20481, 588, 218, 6, 28, "Input",
 CellID->84781920],
Cell[20702, 596, 8046, 159, 162, "Output",
 CellID->36596958]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28797, 761, 124, 3, 8, "ExampleDelimiter",
 CellID->48075071],
Cell[28924, 766, 122, 3, 28, "Input",
 CellID->219878613],
Cell[29049, 771, 90, 1, 32, "ExampleText",
 CellID->164955485],
Cell[CellGroupData[{
Cell[29164, 776, 324, 9, 47, "Input",
 CellID->275433556],
Cell[29491, 787, 5906, 124, 118, "Output",
 CellID->126415148]
}, Open  ]],
Cell[CellGroupData[{
Cell[35434, 916, 351, 10, 47, "Input",
 CellID->412043414],
Cell[35788, 928, 8046, 159, 162, "Output",
 CellID->19961489]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43895, 1094, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[44119, 1103, 122, 3, 70, "Input",
 CellID->314157920],
Cell[44244, 1108, 251, 9, 70, "ExampleText",
 CellID->281984562],
Cell[CellGroupData[{
Cell[44520, 1121, 172, 4, 70, "Input",
 CellID->47865016],
Cell[44695, 1127, 158, 5, 70, "Output",
 CellID->834686760]
}, Open  ]],
Cell[44868, 1135, 72, 1, 70, "ExampleText",
 CellID->219661359],
Cell[CellGroupData[{
Cell[44965, 1140, 237, 7, 70, "Input",
 CellID->483337040],
Cell[45205, 1149, 5060, 103, 70, "Output",
 CellID->170865571]
}, Open  ]],
Cell[CellGroupData[{
Cell[50302, 1257, 124, 3, 70, "ExampleDelimiter",
 CellID->58987498],
Cell[50429, 1262, 120, 3, 70, "Input",
 CellID->6389288],
Cell[50552, 1267, 223, 8, 70, "ExampleText",
 CellID->520325747],
Cell[CellGroupData[{
Cell[50800, 1279, 124, 4, 70, "Input",
 CellID->18888682],
Cell[50927, 1285, 213, 7, 70, "Output",
 CellID->190802610]
}, Open  ]],
Cell[CellGroupData[{
Cell[51177, 1297, 174, 5, 70, "Input",
 CellID->168213023],
Cell[51354, 1304, 11677, 224, 70, "Output",
 CellID->92101935]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63080, 1534, 125, 3, 70, "ExampleDelimiter",
 CellID->127399744],
Cell[63208, 1539, 122, 3, 70, "Input",
 CellID->159202963],
Cell[63333, 1544, 258, 9, 70, "ExampleText",
 CellID->190501847],
Cell[CellGroupData[{
Cell[63616, 1557, 127, 3, 70, "Input",
 CellID->104488195],
Cell[63746, 1562, 220, 6, 70, "Output",
 CellID->161185181]
}, Open  ]],
Cell[63981, 1571, 86, 1, 70, "ExampleText",
 CellID->690487144],
Cell[CellGroupData[{
Cell[64092, 1576, 172, 4, 70, "Input",
 CellID->83728472],
Cell[64267, 1582, 158, 5, 70, "Output",
 CellID->565737287]
}, Open  ]],
Cell[CellGroupData[{
Cell[64462, 1592, 236, 7, 70, "Input",
 CellID->64316292],
Cell[64701, 1601, 5060, 103, 70, "Output",
 CellID->110083829]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69810, 1710, 124, 3, 70, "ExampleDelimiter",
 CellID->23500834],
Cell[69937, 1715, 122, 3, 70, "Input",
 CellID->110792157],
Cell[70062, 1720, 246, 8, 70, "ExampleText",
 CellID->218875408],
Cell[CellGroupData[{
Cell[70333, 1732, 308, 9, 70, "Input",
 CellID->39701280],
Cell[70644, 1743, 176, 5, 70, "Output",
 CellID->424212825]
}, Open  ]],
Cell[70835, 1751, 86, 1, 70, "ExampleText",
 CellID->378963063],
Cell[CellGroupData[{
Cell[70946, 1756, 173, 4, 70, "Input",
 CellID->742437364],
Cell[71122, 1762, 157, 5, 70, "Output",
 CellID->32742712]
}, Open  ]],
Cell[CellGroupData[{
Cell[71316, 1772, 235, 7, 70, "Input",
 CellID->8364289],
Cell[71554, 1781, 5060, 103, 70, "Output",
 CellID->700417913]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76675, 1891, 202, 6, 18, "ExampleSection"],
Cell[CellGroupData[{
Cell[76902, 1901, 217, 6, 70, "ExampleSubsection"],
Cell[77122, 1909, 122, 3, 70, "Input",
 CellID->362750520],
Cell[77247, 1914, 133, 4, 70, "ExampleText",
 CellID->179344981],
Cell[CellGroupData[{
Cell[77405, 1922, 408, 9, 70, "Input",
 CellID->635038778],
Cell[77816, 1933, 28293, 536, 70, "Output",
 CellID->445669905]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106158, 2475, 211, 6, 70, "ExampleSubsection"],
Cell[106372, 2483, 122, 3, 70, "Input",
 CellID->180104251],
Cell[106497, 2488, 95, 1, 70, "ExampleText",
 CellID->9511472],
Cell[CellGroupData[{
Cell[106617, 2493, 348, 8, 70, "Input",
 CellID->3085760],
Cell[106968, 2503, 28292, 536, 70, "Output",
 CellID->90432115]
}, Open  ]],
Cell[CellGroupData[{
Cell[135297, 3044, 374, 9, 70, "Input",
 CellID->59355296],
Cell[135674, 3055, 30576, 583, 70, "Output",
 CellID->21166485]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[166311, 3645, 238, 7, 18, "ExampleSection",
 CellID->2123667759],
Cell[166552, 3654, 122, 3, 70, "Input",
 CellID->418918349],
Cell[166677, 3659, 112, 3, 70, "ExampleText",
 CellID->211706579],
Cell[CellGroupData[{
Cell[166814, 3666, 277, 8, 70, "Input",
 CellID->467215405],
Cell[167094, 3676, 11678, 224, 70, "Output",
 CellID->284259031]
}, Open  ]],
Cell[CellGroupData[{
Cell[178809, 3905, 228, 6, 70, "Input",
 CellID->82760349],
Cell[179040, 3913, 11676, 224, 70, "Output",
 CellID->9574339]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[190765, 4143, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[190999, 4152, 122, 3, 70, "Input",
 CellID->283851897],
Cell[191124, 4157, 245, 7, 70, "ExampleText",
 CellID->136550100],
Cell[CellGroupData[{
Cell[191394, 4168, 182, 5, 70, "Input",
 CellID->30964636],
Cell[191579, 4175, 228, 8, 70, "Output",
 CellID->847376425]
}, Open  ]],
Cell[CellGroupData[{
Cell[191844, 4188, 125, 3, 70, "ExampleDelimiter",
 CellID->187551867],
Cell[191972, 4193, 122, 3, 70, "Input",
 CellID->121226319],
Cell[192097, 4198, 84, 1, 70, "ExampleText",
 CellID->98111338],
Cell[CellGroupData[{
Cell[192206, 4203, 214, 6, 70, "Input",
 CellID->316349048],
Cell[192423, 4211, 228, 8, 70, "Output",
 CellID->687628582]
}, Open  ]],
Cell[CellGroupData[{
Cell[192688, 4224, 240, 7, 70, "Input",
 CellID->228371998],
Cell[192931, 4233, 5904, 124, 70, "Output",
 CellID->555679964]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[198884, 4363, 125, 3, 70, "ExampleDelimiter",
 CellID->399604478],
Cell[199012, 4368, 122, 3, 70, "Input",
 CellID->129130089],
Cell[199137, 4373, 98, 1, 70, "ExampleText",
 CellID->271731252],
Cell[CellGroupData[{
Cell[199260, 4378, 213, 6, 70, "Input",
 CellID->431987857],
Cell[199476, 4386, 301, 9, 70, "Output",
 CellID->14437741]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[199826, 4401, 125, 3, 70, "ExampleDelimiter",
 CellID->310730134],
Cell[199954, 4406, 122, 3, 70, "Input",
 CellID->103845567],
Cell[200079, 4411, 498, 17, 70, "ExampleText",
 CellID->3187032],
Cell[CellGroupData[{
Cell[200602, 4432, 409, 9, 70, "Input",
 CellID->546560914],
Cell[201014, 4443, 5964, 126, 70, "Output",
 CellID->69303955]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[207039, 4576, 228, 7, 18, "ExampleSection",
 CellID->589267740],
Cell[207270, 4585, 121, 3, 70, "Input",
 CellID->80168887],
Cell[207394, 4590, 98, 1, 70, "ExampleText",
 CellID->307921457],
Cell[CellGroupData[{
Cell[207517, 4595, 1676, 50, 70, "Input",
 CellID->752732513],
Cell[209196, 4647, 33153, 622, 70, "Output",
 CellID->299179827],
Cell[242352, 5271, 15862, 350, 70, "Output",
 CellID->56014451]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[258275, 5628, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[258695, 5642, 2262, 78, 31, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[260994, 5725, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[261416, 5739, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[261587, 5744, 147, 3, 17, "MoreAbout",
 CellID->345908322],
Cell[261737, 5749, 146, 3, 17, "MoreAbout",
 CellID->698959272]
}, Open  ]],
Cell[261898, 5755, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

