(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     21294,        702]
NotebookOptionsPosition[     16821,        553]
NotebookOutlinePosition[     18519,        601]
CellTagsIndexPosition[     18434,        596]
WindowTitle->RandomWalkWeb - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"GetSource\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetSource"], "\<\"PerformRandomWalks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/PerformRandomWalks"], "\<\"Column\"\>":>
       Documentation`HelpLookup["paclet:ref/Column"], "\<\"GetHyperlinks\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/GetHyperlinks"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Random Number \
Generation\"\>":>Documentation`HelpLookup[
       "paclet:guide/RandomNumberGeneration"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/RandomWalkWeb\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/RandomWalkWeb"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/RandomWalkWeb.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/RandomWalkWeb", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["RandomWalkWeb", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RandomWalkWeb",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        StyleBox[
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["s", "TI"]], "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs a random walk on the Web originating from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     " and having at most ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["s", "TI"]]], "InlineFormula"],
     " steps."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->14765361],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "If a notebook-based front end is being used, ",
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 " displays the current step/URL in the window status area."
}], "Notes",
 CellID->919240060],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 " will attempt to backtrack at most one step if it reaches a URL with zero \
valid outgoing links."
}], "Notes",
 CellID->72134009],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 " returns a list of successfully visited URLs."
}], "Notes",
 CellID->365786975],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->223313794],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 " is not a fully qualified (i.e., absolute) URL."
}], "Notes",
 CellID->716797479],

Cell[TextData[{
 "The number of steps ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["s", "TI"]]], "InlineFormula"],
 " must be greater than or equal to 1."
}], "Notes",
 CellID->38767997]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223170760],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->54064940],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24369239],

Cell["Perform a random walk on the Web:", "ExampleText",
 CellID->138456881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomWalkWeb", "[", 
   RowBox[{"\"\<http://wolfram.com/\>\"", ",", "10"}], "]"}], "//", 
  "Column"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52597551],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"http://wolfram.com/\"\>"},
    {"\<\"http://products.wolframalpha.com/\"\>"},
    {"\<\"http://www.wolfram.com/mathematica/how-mathematica-made-\
wolframalpha-possible.html\"\>"},
    {"\<\"http://www.stephenwolfram.com/\"\>"},
    {"\<\"http://www.wolframalpha.com/\"\>"},
    {"\<\"http://www.wolframalpha.com/examples/\"\>"},
    {"\<\"http://www.wolframalpha.com/examples/Geochronology.html\"\>"},
    {"\<\"http://www.wolframalpha.com/input/?i=continental+map+for+the+Karoo+\
ice+age&amp;lk=3\"\>"},
    {"\<\"http://www.wolframscience.com/\"\>"},
    {"\<\"http://www.wolframalpha.com/\"\>"},
    {"\<\"http://www.wolfram.com/\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 ImageSize->{586, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185685068]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkWeb", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<http://wolfram.com/\>\"", ",", 
     "\"\<http://wolframscience.com/\>\""}], "}"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"http://wolfram.com/\"\>", 
     ",", "\<\"http://products.wolframalpha.com/\"\>", 
     ",", "\<\"http://www.wolfram.com/mathematica/how-mathematica-made-\
wolframalpha-possible.html\"\>", 
     ",", "\<\"http://www.stephenwolfram.com/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/examples/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/examples/Geochronology.html\"\>", 
     ",", "\<\"http://www.wolframalpha.com/input/?i=continental+map+for+the+\
Karoo+ice+age&amp;lk=3\"\>", ",", "\<\"http://www.wolframscience.com/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/\"\>", 
     ",", "\<\"http://www.wolfram.com/\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"http://wolframscience.com/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/examples/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/examples/ElectricalEngineering.\
html\"\>", 
     ",", "\<\"http://www.wolframalpha.com/examples/HealthAndMedicine.html\"\>\
", ",", "\<\"http://www.wolframalpha.com/participate/\"\>", 
     ",", "\<\"http://products.wolframalpha.com/business/\"\>", 
     ",", "\<\"http://www.wolframalpha.com/about.html\"\>", 
     ",", "\<\"http://www.wolfram.com/\"\>", 
     ",", "\<\"http://www.wolframscience.com/\"\>", 
     ",", "\<\"http://blog.stephenwolfram.com/2012/05/its-been-10-years-whats-\
happened-with-a-new-kind-of-science/\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{574, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->541022973]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322199913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RandomWalkWeb",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"]], "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->136550100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkWeb", "[", 
  RowBox[{"\"\<./page2.html\>\"", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153780350],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230761801]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->729390817],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->736373100],

Cell["The number of steps must be greater than or equal to 1:", "ExampleText",
 CellID->163080877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkWeb", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"-", "8"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43945404],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->368275392]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetSource",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetSource"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PerformRandomWalks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/PerformRandomWalks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetHyperlinks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "MoreAbout",
 CellID->89198991]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomWalkWeb - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 25.5831676}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "RandomWalkWeb[\"url\", n_s] performs a random walk on the Web \
originating from \"url\" and having at most n_s steps.", "synonyms" -> {}, 
    "title" -> "RandomWalkWeb", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/RandomWalkWeb"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8009, 246, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->223170760]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18291, 589}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[606, 21, 76, 1, 3, "SymbolColorBar"],
Cell[685, 24, 209, 5, 19, "LinkTrail"],
Cell[897, 31, 3117, 68, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4039, 103, 56, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4098, 106, 898, 27, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5033, 138, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->14765361],
Cell[5615, 157, 604, 19, 70, "Notes",
 CellID->1067943069],
Cell[6222, 178, 302, 8, 70, "Notes",
 CellID->919240060],
Cell[6527, 188, 291, 8, 70, "Notes",
 CellID->72134009],
Cell[6821, 198, 240, 7, 70, "Notes",
 CellID->365786975],
Cell[7064, 207, 229, 7, 70, "Notes",
 CellID->223313794],
Cell[7296, 216, 461, 15, 70, "Notes",
 CellID->716797479],
Cell[7760, 233, 212, 8, 70, "Notes",
 CellID->38767997]
}, Closed]],
Cell[CellGroupData[{
Cell[8009, 246, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223170760],
Cell[CellGroupData[{
Cell[8495, 263, 147, 5, 31, "ExampleSection",
 CellID->54064940],
Cell[8645, 270, 121, 3, 28, "Input",
 CellID->24369239],
Cell[8769, 275, 76, 1, 32, "ExampleText",
 CellID->138456881],
Cell[CellGroupData[{
Cell[8870, 280, 191, 6, 28, "Input",
 CellID->52597551],
Cell[9064, 288, 964, 23, 188, "Output",
 CellID->185685068]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10077, 317, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[10301, 326, 122, 3, 70, "Input",
 CellID->139972119],
Cell[10426, 331, 234, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[10685, 342, 255, 9, 70, "Input",
 CellID->475944353],
Cell[10943, 353, 1688, 34, 70, "Output",
 CellID->541022973]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12680, 393, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[12914, 402, 122, 3, 70, "Input",
 CellID->322199913],
Cell[13039, 407, 241, 7, 70, "ExampleText",
 CellID->136550100],
Cell[CellGroupData[{
Cell[13305, 418, 151, 4, 70, "Input",
 CellID->153780350],
Cell[13459, 424, 164, 5, 70, "Output",
 CellID->230761801]
}, Open  ]],
Cell[CellGroupData[{
Cell[13660, 434, 125, 3, 70, "ExampleDelimiter",
 CellID->729390817],
Cell[13788, 439, 122, 3, 70, "Input",
 CellID->736373100],
Cell[13913, 444, 98, 1, 70, "ExampleText",
 CellID->163080877],
Cell[CellGroupData[{
Cell[14036, 449, 176, 5, 70, "Input",
 CellID->43945404],
Cell[14215, 456, 164, 5, 70, "Output",
 CellID->368275392]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14452, 469, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[14872, 483, 1120, 38, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[16029, 526, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[16451, 540, 168, 3, 70, "MoreAbout",
 CellID->1665078683],
Cell[16622, 545, 157, 3, 70, "MoreAbout",
 CellID->89198991]
}, Open  ]],
Cell[16794, 551, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

