(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     41159,        950]
NotebookOptionsPosition[     38047,        851]
NotebookOutlinePosition[     39745,        899]
CellTagsIndexPosition[     39660,        894]
WindowTitle->RefreshIconCache - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"GetFavicon\"\>":>Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetFavicon"], "\<\"VertexIcon\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/VertexIcon"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Options \
Management\"\>":>Documentation`HelpLookup["paclet:guide/OptionsManagement"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/RefreshIconCache\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/RefreshIconCache"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/RefreshIconCache.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/RefreshIconCache", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["RefreshIconCache", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RefreshIconCache",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"]], 
      "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["RandomWalkGraph",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], 
      "InlineFormula"],
     " that specifies whether the icon cache should be refreshed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->56760502],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["RefreshIconCache",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RefreshIconCache",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"], " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " attempts to download icons regardless of whether they already exist in the \
local icon cache."
}], "Notes",
 CellID->26365346],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RefreshIconCache",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"], " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " does not attempt to refresh the icon cache."
}], "Notes",
 CellID->362121298]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->267869303],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->41115432],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362750520],

Cell["\<\
Download icons regardless of whether they already exist in the local icon \
cache:\
\>", "ExampleText",
 CellID->179344981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"RefreshIconCache", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexIcon", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->635038778],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}, {ImageSize -> 350, VertexShape -> {1 -> Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 4 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 6 -> 
           Image[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 5 -> 
           Image[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 3 -> 
           Image[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 2 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True]}, 
         VertexSize -> {Medium}}]], Typeset`boxes, Typeset`boxes$s2d = 
      GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {0., 
           0.49171600403719756`}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           0.9870549567799676, 0.4917023249955501}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$2"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.801899036431133, 0.49201733434184985`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$3"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.075223556437642, 0.9833469445744307}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$4"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.1782560923933993`, 0.49172094279313266`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$5"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.0760930698520648`, 0.}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{7.5, 341.7613065318021}, {-50.49999999999999, 
         46.88202046550722}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None,
    ImageSize->350], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], 
       ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"stephenwolfram.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframalpha.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram-media.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframscience.com\"\>"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85013625]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetFavicon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexIcon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->363792060]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RefreshIconCache - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 27.4831702}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "RefreshIconCache is an option to RandomWalkGraph that specifies whether \
the icon cache should be refreshed.", "synonyms" -> {}, "title" -> 
    "RefreshIconCache", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/RefreshIconCache"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6599, 196, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->267869303]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39517, 887}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[609, 21, 76, 1, 3, "SymbolColorBar"],
Cell[688, 24, 209, 5, 19, "LinkTrail"],
Cell[900, 31, 2914, 64, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3839, 99, 59, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[3901, 102, 658, 19, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4596, 126, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->56760502],
Cell[5178, 145, 610, 19, 70, "Notes",
 CellID->1067943069],
Cell[5791, 166, 408, 12, 70, "Notes",
 CellID->26365346],
Cell[6202, 180, 360, 11, 70, "Notes",
 CellID->362121298]
}, Closed]],
Cell[CellGroupData[{
Cell[6599, 196, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->267869303],
Cell[CellGroupData[{
Cell[7085, 213, 147, 5, 31, "ExampleSection",
 CellID->41115432],
Cell[7235, 220, 122, 3, 28, "Input",
 CellID->362750520],
Cell[7360, 225, 133, 4, 32, "ExampleText",
 CellID->179344981],
Cell[CellGroupData[{
Cell[7518, 233, 408, 9, 47, "Input",
 CellID->635038778],
Cell[7929, 244, 28292, 536, 202, "Output",
 CellID->85013625]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36282, 787, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[36702, 801, 526, 18, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[37265, 824, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[37687, 838, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[37858, 843, 147, 3, 17, "MoreAbout",
 CellID->363792060]
}, Open  ]],
Cell[38020, 849, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

