(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16813,        574]
NotebookOptionsPosition[     12986,        446]
NotebookOutlinePosition[     14600,        493]
CellTagsIndexPosition[     14515,        488]
WindowTitle->SiteRoot - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"AbsoluteLinkQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/AbsoluteLinkQ"], "\<\"Hostname\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/Hostname"], "\<\"DomainName\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/DomainName"], "\<\"BaseURL\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/BaseURL"], "\<\"ToAbsoluteLink\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/ToAbsoluteLink"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"String \
Manipulation\"\>":>Documentation`HelpLookup[
       "paclet:guide/StringManipulation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/SiteRoot\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/SiteRoot"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/SiteRoot.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/SiteRoot", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["SiteRoot", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SiteRoot",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the site root of ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->59029247],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["SiteRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The URL returned by ",
 Cell[BoxData[
  ButtonBox["SiteRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"]], "InlineFormula"],
 " does not include a trailing slash."
}], "Notes",
 CellID->154336435],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SiteRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SiteRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 " is not a fully qualified (i.e., absolute) URL."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->499197463],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->338571417],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92135248],

Cell["Return the site root of the specified URL:", "ExampleText",
 CellID->345941918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SiteRoot", "[", "\"\<http://www.example.net/dir1/page1.html\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70713187],

Cell[BoxData["\<\"http://www.example.net\"\>"], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->243434008]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SiteRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SiteRoot", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<http://www.example.net/dir1/page1.html\>\"", ",", 
    "\"\<http://www.example.net/dir1/subdir1/\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.example.net\"\>", 
   ",", "\<\"http://www.example.net\"\>"}], "}"}]], "Output",
 ImageSize->{337, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12005819]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->322199913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SiteRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"]], "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->136550100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SiteRoot", "[", "\"\<./page2.html\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153780350],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->770226496]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteLinkQ",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hostname",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/Hostname"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DomainName",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/DomainName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseURL",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/BaseURL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAbsoluteLink",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->333683230]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SiteRoot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 29.3731729}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "SiteRoot[\"url\"] gives the site root of \"url\".", "synonyms" -> {}, 
    "title" -> "SiteRoot", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/SiteRoot"}, "LinkTrails" -> "", "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6930, 211, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->499197463]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14372, 481}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[601, 21, 76, 1, 3, "SymbolColorBar"],
Cell[680, 24, 209, 5, 19, "LinkTrail"],
Cell[892, 31, 3213, 72, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4130, 107, 51, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4184, 110, 573, 17, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4794, 132, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->59029247],
Cell[5376, 151, 594, 19, 70, "Notes",
 CellID->1067943069],
Cell[5973, 172, 245, 8, 70, "Notes",
 CellID->154336435],
Cell[6221, 182, 218, 7, 70, "Notes",
 CellID->12607960],
Cell[6442, 191, 451, 15, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[6930, 211, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->499197463],
Cell[CellGroupData[{
Cell[7416, 228, 148, 5, 31, "ExampleSection",
 CellID->338571417],
Cell[7567, 235, 121, 3, 28, "Input",
 CellID->92135248],
Cell[7691, 240, 85, 1, 32, "ExampleText",
 CellID->345941918],
Cell[CellGroupData[{
Cell[7801, 245, 151, 4, 28, "Input",
 CellID->70713187],
Cell[7955, 251, 188, 5, 36, "Output",
 CellID->243434008]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8192, 262, 221, 7, 32, "ExampleSection",
 CellID->1293636265],
Cell[8416, 271, 122, 3, 70, "Input",
 CellID->139972119],
Cell[8541, 276, 224, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[8790, 287, 248, 7, 70, "Input",
 CellID->475944353],
Cell[9041, 296, 265, 8, 70, "Output",
 CellID->12005819]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9355, 310, 231, 7, 18, "ExampleSection",
 CellID->1305812373],
Cell[9589, 319, 122, 3, 70, "Input",
 CellID->322199913],
Cell[9714, 324, 231, 7, 70, "ExampleText",
 CellID->136550100],
Cell[CellGroupData[{
Cell[9970, 335, 123, 3, 70, "Input",
 CellID->153780350],
Cell[10096, 340, 164, 5, 70, "Output",
 CellID->770226496]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10321, 352, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[10741, 366, 1424, 48, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12202, 419, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[12624, 433, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[12795, 438, 149, 3, 17, "MoreAbout",
 CellID->333683230]
}, Open  ]],
Cell[12959, 444, 23, 0, 41, "FooterCell"]
}
]
*)

(* End of internal cache information *)

