(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     24314,        869]
NotebookOptionsPosition[     18310,        658]
NotebookOutlinePosition[     20000,        706]
CellTagsIndexPosition[     19915,        701]
WindowTitle->ToAbsoluteLink - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"GetHyperlinks\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/GetHyperlinks"], "\<\"BaseURL\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/BaseURL"], "\<\"AbsoluteLinkQ\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/AbsoluteLinkQ"], "\<\"SiteRoot\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/SiteRoot"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"String \
Manipulation\"\>":>Documentation`HelpLookup[
       "paclet:guide/StringManipulation"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/ToAbsoluteLink\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/ToAbsoluteLink"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/ToAbsoluteLink.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/ToAbsoluteLink", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["ToAbsoluteLink", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToAbsoluteLink",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"hyperlink\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"hyperlink\", \"TI\"]\)\>\""], "InlineFormula"],
     " to a fully qualified link based on ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->51475127],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["ToAbsoluteLink",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToAbsoluteLink",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->12607960],

Cell[TextData[{
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\""], "InlineFormula"],
 " must be a fully qualified (i.e., absolute) URL."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->429523496],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->498152382],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31333593],

Cell[TextData[{
 "If the specified hyperlink is already absolute, ",
 Cell[BoxData[
  ButtonBox["ToAbsoluteLink",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"]], "InlineFormula"],
 " simply returns the link:"
}], "ExampleText",
 CellID->41020577],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"url", "=", "\"\<http://www.example.net/dir1/page1.html\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<http://www.example.com/\>\""}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->46128617],

Cell[BoxData["\<\"http://www.example.com/\"\>"], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471391580]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348701043],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->545174056],

Cell["Assume that the following URL contains multiple hyperlinks:", \
"ExampleText",
 CellID->232236319],

Cell[BoxData[
 RowBox[{
  RowBox[{"url", "=", "\"\<http://www.example.net/dir1/page1.html\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96117474],

Cell["\<\
Convert the following relative hyperlinks to fully qualified form:\
\>", "ExampleText",
 CellID->773156817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<#\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->533208694],

Cell[BoxData["\<\"http://www.example.net/dir1/page1.html\"\>"], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->444350620]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<#anchor\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->39402016],

Cell[BoxData["\<\"http://www.example.net/dir1/page1.html#anchor\"\>"], \
"Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->408883296]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<./\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->323125979],

Cell[BoxData["\<\"http://www.example.net/dir1/\"\>"], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->153205217]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<./page2.html\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->8435225],

Cell[BoxData["\<\"http://www.example.net/dir1/page2.html\"\>"], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->641540893]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<../\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->82153189],

Cell[BoxData["\<\"http://www.example.net/\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->502795864]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<../dir2/\>\""}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->367903868],

Cell[BoxData["\<\"http://www.example.net/dir2/\"\>"], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->267570608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<../../../\>\""}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->696617634],

Cell[BoxData["\<\"http://www.example.net/\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->7009071]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\</\>\""}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->26485827],

Cell[BoxData["\<\"http://www.example.net/\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->39566566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\</dir3/\>\""}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->151144588],

Cell[BoxData["\<\"http://www.example.net/dir3/\"\>"], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->26187185]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<//www.example.org/\>\""}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->330282296],

Cell[BoxData["\<\"http://www.example.org/\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->323604651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<page3.html\>\""}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->330505181],

Cell[BoxData["\<\"http://www.example.net/dir1/page3.html\"\>"], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->814861927]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<subdir1/\>\""}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->221317004],

Cell[BoxData["\<\"http://www.example.net/dir1/subdir1/\"\>"], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->271612976]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139972119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToAbsoluteLink",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->892767892],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"url", "=", "\"\<http://www.example.net/dir1/page1.html\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<#\>\"", ",", "\"\<subdir1/\>\""}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->475944353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"http://www.example.net/dir1/page1.html\"\>", 
   ",", "\<\"http://www.example.net/dir1/subdir1/\"\>"}], "}"}]], "Output",
 ImageSize->{547, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142373825]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89847950],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToAbsoluteLink",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToAbsoluteLink"]], "InlineFormula"],
 " works only with explicit absolute URLs:"
}], "ExampleText",
 CellID->669722179],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"url", "=", "\"\<./page2.html\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"url", ",", "\"\<../dir2/\>\""}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->409701733],

Cell[BoxData[
 RowBox[{"ToAbsoluteLink", "[", 
  RowBox[{"\<\"./page2.html\"\>", ",", "\<\"../dir2/\"\>"}], "]"}]], "Output",
 ImageSize->{267, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60174435]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetHyperlinks",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetHyperlinks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseURL",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/BaseURL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteLinkQ",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/AbsoluteLinkQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SiteRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/SiteRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->333683230]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToAbsoluteLink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 31.2931756}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "ToAbsoluteLink[\"url\", \"hyperlink\"] converts \"hyperlink\" to a fully \
qualified link based on \"url\".", "synonyms" -> {}, "title" -> 
    "ToAbsoluteLink", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/ToAbsoluteLink"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6572, 194, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->429523496]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19772, 694}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[607, 21, 76, 1, 3, "SymbolColorBar"],
Cell[686, 24, 209, 5, 19, "LinkTrail"],
Cell[898, 31, 3132, 70, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4055, 105, 57, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4115, 108, 780, 22, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4932, 135, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->51475127],
Cell[5514, 154, 606, 19, 70, "Notes",
 CellID->1067943069],
Cell[6123, 175, 230, 7, 70, "Notes",
 CellID->12607960],
Cell[6356, 184, 179, 5, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[6572, 194, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->429523496],
Cell[CellGroupData[{
Cell[7058, 211, 148, 5, 31, "ExampleSection",
 CellID->498152382],
Cell[7209, 218, 121, 3, 28, "Input",
 CellID->31333593],
Cell[7333, 223, 280, 8, 34, "ExampleText",
 CellID->41020577],
Cell[CellGroupData[{
Cell[7638, 235, 284, 7, 47, "Input",
 CellID->46128617],
Cell[7925, 244, 189, 5, 36, "Output",
 CellID->471391580]
}, Open  ]],
Cell[CellGroupData[{
Cell[8151, 254, 125, 3, 8, "ExampleDelimiter",
 CellID->348701043],
Cell[8279, 259, 122, 3, 28, "Input",
 CellID->545174056],
Cell[8404, 264, 104, 2, 32, "ExampleText",
 CellID->232236319],
Cell[8511, 268, 159, 5, 28, "Input",
 CellID->96117474],
Cell[8673, 275, 117, 3, 32, "ExampleText",
 CellID->773156817],
Cell[CellGroupData[{
Cell[8815, 282, 143, 4, 28, "Input",
 CellID->533208694],
Cell[8961, 288, 204, 5, 36, "Output",
 CellID->444350620]
}, Open  ]],
Cell[CellGroupData[{
Cell[9202, 298, 148, 4, 28, "Input",
 CellID->39402016],
Cell[9353, 304, 213, 6, 36, "Output",
 CellID->408883296]
}, Open  ]],
Cell[CellGroupData[{
Cell[9603, 315, 144, 4, 70, "Input",
 CellID->323125979],
Cell[9750, 321, 194, 5, 70, "Output",
 CellID->153205217]
}, Open  ]],
Cell[CellGroupData[{
Cell[9981, 331, 152, 4, 70, "Input",
 CellID->8435225],
Cell[10136, 337, 204, 5, 70, "Output",
 CellID->641540893]
}, Open  ]],
Cell[CellGroupData[{
Cell[10377, 347, 144, 4, 70, "Input",
 CellID->82153189],
Cell[10524, 353, 189, 5, 70, "Output",
 CellID->502795864]
}, Open  ]],
Cell[CellGroupData[{
Cell[10750, 363, 150, 4, 70, "Input",
 CellID->367903868],
Cell[10903, 369, 194, 5, 70, "Output",
 CellID->267570608]
}, Open  ]],
Cell[CellGroupData[{
Cell[11134, 379, 151, 4, 70, "Input",
 CellID->696617634],
Cell[11288, 385, 187, 5, 70, "Output",
 CellID->7009071]
}, Open  ]],
Cell[CellGroupData[{
Cell[11512, 395, 143, 4, 70, "Input",
 CellID->26485827],
Cell[11658, 401, 189, 5, 70, "Output",
 CellID->39566566]
}, Open  ]],
Cell[CellGroupData[{
Cell[11884, 411, 149, 4, 70, "Input",
 CellID->151144588],
Cell[12036, 417, 194, 5, 70, "Output",
 CellID->26187185]
}, Open  ]],
Cell[CellGroupData[{
Cell[12267, 427, 161, 4, 70, "Input",
 CellID->330282296],
Cell[12431, 433, 190, 5, 70, "Output",
 CellID->323604651]
}, Open  ]],
Cell[CellGroupData[{
Cell[12658, 443, 153, 4, 70, "Input",
 CellID->330505181],
Cell[12814, 449, 205, 5, 70, "Output",
 CellID->814861927]
}, Open  ]],
Cell[CellGroupData[{
Cell[13056, 459, 151, 4, 70, "Input",
 CellID->221317004],
Cell[13210, 465, 203, 5, 70, "Output",
 CellID->271612976]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13474, 477, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[13698, 486, 122, 3, 70, "Input",
 CellID->139972119],
Cell[13823, 491, 236, 7, 70, "ExampleText",
 CellID->892767892],
Cell[CellGroupData[{
Cell[14084, 502, 327, 9, 70, "Input",
 CellID->475944353],
Cell[14414, 513, 296, 8, 70, "Output",
 CellID->142373825]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14759, 527, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[14993, 536, 121, 3, 70, "Input",
 CellID->89847950],
Cell[15117, 541, 243, 7, 70, "ExampleText",
 CellID->669722179],
Cell[CellGroupData[{
Cell[15385, 552, 241, 6, 70, "Input",
 CellID->409701733],
Cell[15629, 560, 255, 7, 70, "Output",
 CellID->60174435]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15945, 574, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16365, 588, 1124, 38, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[17526, 631, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[17948, 645, 168, 3, 70, "MoreAbout",
 CellID->1665078683],
Cell[18119, 650, 149, 3, 70, "MoreAbout",
 CellID->333683230]
}, Open  ]],
Cell[18283, 656, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

