(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16631,        543]
NotebookOptionsPosition[     13194,        431]
NotebookOutlinePosition[     14843,        478]
CellTagsIndexPosition[     14758,        473]
WindowTitle->ToGraphData - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkWeb"], "\<\"DirectedEdge\"\>":>
       Documentation`HelpLookup[
       "paclet:ref/DirectedEdge"], "\<\"RandomWalkGraph\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RandomWalkGraph"], "\<\"DomainName\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/DomainName"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Constructing \
Graphs\"\>":>Documentation`HelpLookup["paclet:guide/GraphConstruction"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/ToGraphData\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/ToGraphData"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/ToGraphData.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/ToGraphData", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["ToGraphData", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToGraphData",
        BaseStyle->"Link",
        ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"], "[", 
       StyleBox["stepData", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts the elements in ",
     Cell[BoxData[
      StyleBox["stepData", "TI"]], "InlineFormula"],
     " to directed graph data."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->233124873],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["ToGraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToGraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"]], "InlineFormula"],
 " accepts ",
 Cell[BoxData[
  StyleBox["stepData", "TI"]], "InlineFormula"],
 " returned by ",
 Cell[BoxData[
  ButtonBox["GetStepData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->96512434],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToGraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it is unable to convert the specified data."
}], "Notes",
 CellID->365786975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65259824],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->258660301],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554856619],

Cell["Convert the step data to directed graph data:", "ExampleText",
 CellID->527103828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToGraphData", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<wolfram.com\>\"", ",", "\"\<wolframalpha.com\>\""}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"\"\<wolframalpha.com\>\"", ",", "\"\<wolfram.com\>\""}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"\"\<wolfram.com\>\"", ",", "\"\<stephenwolfram.com\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<stephenwolfram.com\>\"", ",", "\"\<wolframalpha.com\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<wolframalpha.com\>\"", ",", "\"\<wolframscience.com\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<wolframscience.com\>\"", ",", "\"\<wolframalpha.com\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->536896402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"wolfram.com\"\>", 
    "\[DirectedEdge]", "\<\"wolframalpha.com\"\>"}], ",", 
   RowBox[{"\<\"wolframalpha.com\"\>", 
    "\[DirectedEdge]", "\<\"wolfram.com\"\>"}], ",", 
   RowBox[{"\<\"wolfram.com\"\>", 
    "\[DirectedEdge]", "\<\"stephenwolfram.com\"\>"}], ",", 
   RowBox[{"\<\"stephenwolfram.com\"\>", 
    "\[DirectedEdge]", "\<\"wolframalpha.com\"\>"}], ",", 
   RowBox[{"\<\"wolframalpha.com\"\>", 
    "\[DirectedEdge]", "\<\"wolframscience.com\"\>"}], ",", 
   RowBox[{"\<\"wolframscience.com\"\>", 
    "\[DirectedEdge]", "\<\"wolframalpha.com\"\>"}]}], "}"}]], "Output",
 ImageSize->{550, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->923371931]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48420584],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToGraphData",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/ToGraphData"]], "InlineFormula"],
 " may fail due to incomplete step data:"
}], "ExampleText",
 CellID->53218371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToGraphData", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<wolfram.com\>\"", ",", "\"\<wolframalpha.com\>\""}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"\"\<wolframalpha.com\>\"", ",", "\"\<wolfram.com\>\""}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"\"\<wolfram.com\>\"", ",", "\"\<stephenwolfram.com\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<stephenwolfram.com\>\"", ",", "\"\<wolframalpha.com\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<wolframalpha.com\>\"", ",", "\"\<wolframscience.com\>\""}], 
     "}"}], ",", 
    RowBox[{"{", "\"\<wolframscience.com\>\"", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->413781270],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->411876703]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkWeb",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkWeb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectedEdge",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdge"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomWalkGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DomainName",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/DomainName"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphConstruction"]], "MoreAbout",
 CellID->597507747]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToGraphData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 33.1731782}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "ToGraphData[stepData] converts the elements in stepData to directed \
graph data.", "synonyms" -> {}, "title" -> "ToGraphData", "type" -> "Symbol", 
    "uri" -> "RandomWalkWeb/ref/ToGraphData"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6733, 203, 460, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->65259824]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14616, 466}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[604, 21, 76, 1, 3, "SymbolColorBar"],
Cell[683, 24, 209, 5, 19, "LinkTrail"],
Cell[895, 31, 3115, 69, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[4035, 104, 54, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[4092, 107, 583, 17, 85, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4712, 129, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->233124873],
Cell[5295, 148, 600, 19, 70, "Notes",
 CellID->1067943069],
Cell[5898, 169, 426, 15, 70, "Notes",
 CellID->96512434],
Cell[6327, 186, 369, 12, 70, "Notes",
 CellID->365786975]
}, Closed]],
Cell[CellGroupData[{
Cell[6733, 203, 460, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65259824],
Cell[CellGroupData[{
Cell[7218, 220, 148, 5, 31, "ExampleSection",
 CellID->258660301],
Cell[7369, 227, 122, 3, 28, "Input",
 CellID->554856619],
Cell[7494, 232, 88, 1, 32, "ExampleText",
 CellID->527103828],
Cell[CellGroupData[{
Cell[7607, 237, 803, 23, 101, "Input",
 CellID->536896402],
Cell[8413, 262, 771, 19, 71, "Output",
 CellID->923371931]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9233, 287, 231, 7, 32, "ExampleSection",
 CellID->1305812373],
Cell[9467, 296, 121, 3, 70, "Input",
 CellID->48420584],
Cell[9591, 301, 234, 7, 70, "ExampleText",
 CellID->53218371],
Cell[CellGroupData[{
Cell[9850, 312, 748, 21, 70, "Input",
 CellID->413781270],
Cell[10601, 335, 164, 5, 70, "Output",
 CellID->411876703]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10826, 347, 417, 12, 45, "SeeAlsoSection",
 CellID->1255426704],
Cell[11246, 361, 1128, 38, 17, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12411, 404, 419, 12, 45, "MoreAboutSection",
 CellID->38303248],
Cell[12833, 418, 168, 3, 17, "MoreAbout",
 CellID->1665078683],
Cell[13004, 423, 148, 3, 70, "MoreAbout",
 CellID->597507747]
}, Open  ]],
Cell[13167, 429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

