(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     72130,       1551]
NotebookOptionsPosition[     68868,       1446]
NotebookOutlinePosition[     70557,       1494]
CellTagsIndexPosition[     70471,       1489]
WindowTitle->VertexIcon - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RefreshIconCache\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/ref/RefreshIconCache"], "\<\"GetFavicon\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/GetFavicon"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Options \
Management\"\>":>Documentation`HelpLookup["paclet:guide/OptionsManagement"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/VertexIcon\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/VertexIcon"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/VertexIcon.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/VertexIcon", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["VertexIcon", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["VertexIcon",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"]], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["RandomWalkGraph",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"]], 
      "InlineFormula"],
     " that specifies whether vertices should be rendered using favorite \
icons."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->178577625],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["VertexIcon",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexIcon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"], " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " renders vertices using their associated favorite icons."
}], "Notes",
 CellID->26365346],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexIcon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/VertexIcon"], " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " renders vertices using standard graphics primitives."
}], "Notes",
 CellID->362121298]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->918734349],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->894327182],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180104251],

Cell["Render vertices using their associated favorite icons:", "ExampleText",
 CellID->9511472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"VertexIcon", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3085760],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 4, 2, 3, 6, 
        5}, {{{1, 2}, {3, 4}, {4, 5}, {2, 1}, {2, 5}, {6, 3}, {5, 6}}, 
         Null}, {ImageSize -> 350, VertexShape -> {1 -> Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 4 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 6 -> 
           Image[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 5 -> 
           Image[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 3 -> 
           Image[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 2 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True]}, 
         VertexSize -> {Medium}}]], Typeset`boxes, Typeset`boxes$s2d = 
      GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {0., 
           0.49171600403719756`}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$1"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           0.9870549567799676, 0.4917023249955501}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$2"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.801899036431133, 0.49201733434184985`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$3"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.075223556437642, 0.9833469445744307}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$4"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.1782560923933993`, 0.49172094279313266`}, Automatic, {
           0.17537107611172775`, 0.17537107611172775`}], "DynamicName", BoxID -> 
          "VertexID$5"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.0760930698520648`, 0.}, Automatic, {0.17537107611172775`, 
           0.17537107611172775`}], "DynamicName", BoxID -> "VertexID$6"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.02613296105421413, 0.7}}], {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], {
            0.10424749008626001`, 0.5282010038910179}, {0.1308257041877517, 
            0.5367913691705889}, {0.15778618939574401`, 0.544093976774097}, {
            0.18506659101310816`, 0.5500919370987828}, {0.21260381443426546`, 
            0.5547713779536767}, {0.24033417107153116`, 0.5581214766434534}, {
            0.2681935256552299, 0.5601344849993558}, {0.2961174445669059, 
            0.5608057472993011}, {0.6909394272788927, 0.5608002756826421}, {
            0.7188633275745465, 0.5601282394190592}, {0.7467226263532342, 
            0.5581144588895564}, {0.7744528901255665, 0.5547635916021133}, {
            0.8019899838366482, 0.5500833875031136}, {0.8292702191987901, 
            0.5440846710531274}, {0.8562305019909315, 0.5367813161919047}, {
            0.882808477984095, 0.5281902142504762}, 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], {
            0.8828074666937077, 0.45521732514172986`}, {0.8562292525922162, 
            0.44662695986215895`}, {0.8292687673842237, 
            0.43932435225865074`}, {0.8019883657668596, 0.4333263919339648}, {
            0.7744511423457023, 0.4286469510790709}, {0.7467207857084366, 
            0.42529685238929427`}, {0.7188614311247379, 0.4232838440333919}, {
            0.6909375122130618, 0.4226125817334466}, {0.2961155295010749, 
            0.4226180533501055}, {0.26819162920542106`, 0.4232900896136884}, {
            0.24033233042673346`, 0.4253038701431914}, {0.21260206665440107`, 
            0.4286547374306344}, {0.1850649729433194, 0.43333494152963414`}, {
            0.1577847375811776, 0.4393336579796202}, {0.130824454789036, 
            0.4466370128408428}, {0.10424647879587261`, 0.45522811478227143`}, 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$2", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.02613296105421413], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$3", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{7.5, 341.7613065318021}, {-50.49999999999999, 
         46.88202046550722}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None,
    ImageSize->350], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], 
       ",", "\<\"mathematica-journal.com\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"stephenwolfram.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframalpha.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram-media.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframscience.com\"\>"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{445, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90432115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomWalkGraph", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", "8", ",", 
   RowBox[{"ImageSize", "\[Rule]", "350"}], ",", 
   RowBox[{"VertexIcon", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->59355296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 3, 4, 5, 6, 7, 
        1}, {{{1, 2}, {3, 4}, {4, 1}, {4, 3}, {4, 5}, {4, 6}, {5, 4}, {6, 7}},
          Null}, {ImageSize -> 350, VertexShape -> {1 -> Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 4 -> 
           Image[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 7 -> 
           Image[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 6 -> 
           Image[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 5 -> 
           Image[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 3 -> 
           Image[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True], 2 -> 
           Image[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
             "], "Byte", ColorSpace -> "RGB", Interleaving -> True]}, 
         VertexSize -> {Medium}}]], Typeset`boxes, Typeset`boxes$s2d = 
      GraphicsGroupBox[{{
         Directive[
          Hue[0.6, 0.2, 0.8], 
          EdgeForm[
           Directive[
            GrayLevel[0], 
            Opacity[0.7]]]], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           0.8140859052558821, 0.45714855912998636`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$1"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {0., 0.}, 
           Automatic, {0.18673196472494064`, 0.18673196472494064`}], 
          "DynamicName", BoxID -> "VertexID$2"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.3404289944058014`, 1.8324752840268963`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$3"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           1.8020559320938747`, 1.0515984511936183`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$4"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           1.2606626762505695`, 1.8297543645563343`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$5"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           2.79078236726949, 0.457620230872313}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$6"], 
         TagBox[
          InsetBox[
           BoxData[
            FormBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
                "], {{0, 16}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], BaseStyle -> "ImageGraphics", ImageSizeRaw -> {16, 16},
               PlotRange -> {{0, 16}, {0, 16}}], TraditionalForm]], {
           3.605538678138704, 0.0014283642127416174`}, Automatic, {
           0.18673196472494064`, 0.18673196472494064`}], "DynamicName", BoxID -> 
          "VertexID$7"]}, {
         Directive[
          Opacity[0.7], 
          Hue[0.6, 0.7, 0.5]], 
         Arrowheads[{{0.026751335043226663`, 0.7}}], {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$1", Automatic, Center], 
            DynamicLocation["VertexID$2", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$3", Automatic, Center], {
            2.312434252273612, 1.730102692474329}, {2.304733945907327, 
            1.704390610213496}, {2.2958063623115783`, 1.6790784759008108`}, {
            2.2856721493629495`, 1.6542248318976802`}, {2.274354745652184, 
            1.6298871601608427`}, {2.261880326274992, 1.6061217492970594`}, {
            2.2482777422938107`, 1.5829835643778094`}, {2.2335784540105523`, 
            1.5605261198150777`}, {2.0182292290857826`, 1.248175386681767}, {
            2.002467233279876, 1.226450622458948}, {1.985678984579902, 
            1.2055087840031122`}, {1.9679033111506707`, 
            1.1853983059764759`}, {1.94918132489074, 1.1661657002558394`}, {
            1.9295563263480737`, 1.147855448359078}, {1.9090737045737538`, 
            1.1305098985674844`}, {1.887780832145361, 1.1141691679818988`}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$1", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.8300506742260643`, 1.1539710427461853`}, {1.8377509805923493`, 
            1.1796831250070183`}, {1.8466785641880978`, 
            1.2049952593197037`}, {1.8568127771367267`, 
            1.2298489033228344`}, {1.8681301808474915`, 1.254186575059672}, {
            1.8806046002246843`, 1.2779519859234552`}, {1.8942071842058654`, 
            1.3010901708427052`}, {1.9089064724891234`, 
            1.3235476154054369`}, {2.124255697413894, 1.635898348538748}, {
            2.140017693219801, 1.657623112761567}, {2.1568059419197745`, 
            1.6785649512174028`}, {2.174581615349006, 1.6986754292440391`}, {
            2.193303601608937, 1.7179080349646756`}, {2.212928600151603, 
            1.736218286861437}, {2.233411221925923, 1.7535638366530306`}, {
            2.2547040943543153`, 1.7699045672386162`}, 
            DynamicLocation["VertexID$3", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], {
            1.7161126354990208`, 1.1137701590201041`}, {1.6947621205898316`, 
            1.1300113383763382`}, {1.67421713678277, 1.147260223387737}, {
            1.6545252008874536`, 1.1654769205215096`}, {1.6357318567688806`, 
            1.1846192978715093`}, {1.6178805700127605`, 
            1.2046430826016656`}, {1.6010126273975192`, 
            1.2255019633410005`}, {1.585167041405493, 1.2471476972934021`}, {
            1.3686097390681708`, 1.5584100626384882`}, {1.353823157656833, 
            1.5807925871595236`}, {1.3401297794987352`, 
            1.6038601355422235`}, {1.3275612748862016`, 
            1.6275593567440603`}, {1.3161467124837027`, 1.651835438778201}, {
            1.3059124920973242`, 1.6766322354836607`}, {1.2968822836168183`, 
            1.7018923963811583`}, {1.2890769722714555`, 1.72755749931434}, 
            DynamicLocation["VertexID$5", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$4", Automatic, Center], 
            DynamicLocation["VertexID$6", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$5", Automatic, Center], {
            1.346605972845424, 1.767582656729849}, {1.3679564877546129`, 
            1.751341477373615}, {1.3885014715616744`, 1.7340925923622161`}, {
            1.408193407456991, 1.7158758952284434`}, {1.4269867515755637`, 
            1.6967335178784437`}, {1.4448380383316837`, 
            1.6767097331482874`}, {1.461705980946925, 1.6558508524089526`}, {
            1.4775515669389516`, 1.634205118456551}, {1.6941088692762736`, 
            1.3229427531114648`}, {1.7088954506876115`, 
            1.3005602285904296`}, {1.7225888288457092`, 
            1.2774926802077295`}, {1.7351573334582429`, 
            1.2537934590058928`}, {1.7465718958607417`, 1.229517376971752}, {
            1.7568061162471202`, 1.2047205802662924`}, {1.765836324727626, 
            1.1794604193687948`}, {1.773641636072989, 1.153795316435613}, 
            DynamicLocation["VertexID$4", Automatic, Center]}]}, {
          Arrowheads[0.026751335043226663`], 
          ArrowBox[{
            DynamicLocation["VertexID$6", Automatic, Center], 
            DynamicLocation["VertexID$7", Automatic, Center]}]}}}], 
      Typeset`data}, 
      TagBox[
       DynamicBox[GraphComputation`NetworkGraphicsBox[
        2, Typeset`graph, Typeset`boxes], {
        CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
         SynchronousUpdating -> False, TrackedSymbols :> {}},
        ImageSizeCache->{{8., 340.62166047222087`}, {-91., 
         86.10552098418097}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False,
      UnsavedVariables:>{Typeset`data}]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    FrameTicks->None,
    ImageSize->350], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"complex-systems.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSBBIPhPHcyI
XZxPhErmE8Br34Mx4+qXqG6BijOsA2IGJtz6I2uQ1L5D9RfMbBCtbIDTDEag
WsZ1bxHqFfT+MzIyoroDhAmFIza1QHMYlz4h0gxkf39AEgf6H8l9OP0B0oNN
DV4/oPqTcS1SGEooobkHR1qB6c2bjhBbcBstDvH4F2g2SC8jLJ6R3Vu7hvpp
exhgAIOmYQ4=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], 
       ",", "\<\"computerbasedmath.org\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCEAxSDB////Dwr8
7vsvflzifcfvFtTtv9E47/zDBJgYunr/lWc2wuSRsf6swxcYppz5zzDtwn+G
iSf/Oyw4ul9+0r4H8y48TkJWZ7/t8SmQfMKG8/NhZp97/sGAYcnj/wxr3iHw
wvv/+de8+Hz+1RcnZP3zbn+uA8vPufFfoHvXO5A5+XtuTkHRC8Xrn/yoAOrh
QdbvsObaUbiala/A5jDMvIKhF4SBQATdn+ff/gjj3/DuMzb1yNhgz8fbOOKA
p+7yl/mEzJh350sjrjjc9+RzuP6Ot7cJ2C2BJx3wn3v7Myrg6OdD2PS+//nX
HlcaAYW3QMe2dwyde/8zzL+Nojf+9JdtUL3MOOwFiWucf/87oe7qt4UwPO/+
j857X/6Eg+Tw6EUJQyCWR8Igv7IPdN7ChwHj/uLp
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"twitter.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyN078vg0Ecx/GqlhISoUoE8WtCK4LJpJPFj7QWsWiTilgqRaSDwcok/gKG
RkiEsBMxSYhBImYRSR8inRqDPt73+LZ5+mjL8Hp+3N3n7rm75zrD0cCC3Waz
rbi4BELrY7FYKB508OKPr0bC5TzUCVWoDbdl2VGLMlOZeh6F31SWo+u6tWwJ
y5ayK4T+mQ/iU/pwIYA0JqW+EuNoMuVVmdvUxyl07Ms9gyPMYQ/X6DDl1Zy3
sI01baT9Kenz6Ml+t570NubulOvS36Ll+9W6TSCl2hiZIqi/oF1NkflHjHFp
l0l9/GL04fO80W4H05g15Z2IakOtpcennnZfeEdC8jO4Neb2v/wluuGQ/DHu
8KANtqRLfr/Xo8seF5p/Fc7+WD+VP5E9s+a78GjsgVrHvgbr/r1Qv4tnnKPZ
lFdjx+U/mceN7LXyKvcDaevFJnot69+Dank/lIz67wdk3HsZJ5upKPD/ZyVk
TZ3yXo8N7ecsljo/WVFMafln2SlnJS//DSV23rw=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframalpha.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJyNUgss1HEc/+9CKBIyz928OodzCOdxcU95njh5tIQbpvUgDrFKWtIDPaZk
tLTmIiJbWR6pbLVSlNSI0S0j4bS8tiZ9Oi1NFvluv99+n+++n31/3+/nYyxK
CIojEQSRrCy/gqLT2ElJ0elCBTngpItjRWvkD43fZz75v3ibne/1+uIF0ipK
iVviDPd37ADrBdyRdYz8zZYz9yozS3UhdyckeVPl+csq/+LnpR7hvqG4yUaZ
/AP9gf6uMgqtdZwgoY3ilFbtEqJ5gxaa+Zizp7CuVKK03B+K1OwBkgl+MM1m
RnjG6GQZo1tJD7V6HGkTwUMfK0Gw0gyZWvSJJ0r2GBP5Y6goBv054ai3scU5
goEhgosB3zjHpZyykL2pD0nMqadkZ9yj2qOSYOKBiRcaOf4oZ3CRqspAsaEH
oO8IaNFHe7lBZlLPMKMB7g7qPL+ktEStx0kgnTO1xEBwAHrpbIz7haNdKESN
JwtnTeho5nOByG2YJXQBQgdf6VvRHbsv/c+uoyPM4eeK4TA/TIYJgIJTmC6/
irbcFNzmuaEpKhgTp3fik54aBnU2fR7wFdAXz9DnI5S8NzLHc3MqZAejMFlx
Ed8bqyAryseL7d6otnBAX7wQI+SNaN3mJVnglSYeXfuAubuhTnGzfEcaqNI3
RWegN3pOijFYdAJIT4DU2Rk3FSwgUWOgS8UK/dpWaDicwZvnF0Ts55+nel/K
0bU9U2VocP1ZgLu8Hw/tgTxI4/0wEcDEoKMDWmy24Jy6BY4Tlrgm16fOjj9V
IT4kWqpFl4217EOoJx7RLdCqtwEfPe0AcTDAdsBLbTrynH3Tdhmz1TPN+I7F
nCCXv3SMiF9fS1DQTKZBomMwUUNoYZpCwwzVAF8IVYwquqAlu0B5Oe8UBsb4
FPPC48o8vDWvkC1Z9Spus8PrGLjLYf3ya6ey3VhHbnHESv5bHPVOYe0Ngkjf
Bdxs6aFy/2Q+bbX8mpScjCpRovZKNT8BKotUng==
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram.com\"\>"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJzFk89r02AYx+v0UHTWoeC87uL/oX/CxJMgrKhb6UGYglRFFJ3U4UFbcZ3C
dllP4pqJJw868ObJWnH9nTY/2jRpadqkTZqk+fqkWwXpSS974JM375P387x5
H5K54M35G1M+n++Wny7zC3cuLC8vRC4do8nFyO3rwaN0M3OAlzzsiEajT4k2
gX9EJh55rqkrsJQ8LOE7KmwOilID7O4+VodQgUEbjtGCa3cwpJzWkcY1VE3v
wzBMNJtNOM4QA9vGwHJg2UNYNA4HJuxeh3wdruPApjVttev5tdH+ponk1hbW
37zF7u4XQPqBoZSFF2whg2tXLqPGlcGXchAEARbV0zTN88Wxn2IY2l8Bs8NA
ZPMosRV47zXolpF4HgHLS+C4Kuoih75hTPibGxtIJpNYW0sgXyghnU5DVenc
dAaX1pYKWSKHSpWD67oTfpHl8OnzV/zMZJDN7lGNPAzKg3rR03sQOBZ1oUy9
lagv9oSvNYpQSt+gGw76FqBb+BO6ZiLPN5BlRfwq8mjpzl8+9z4MeTuIZuoq
lJ1FyB9CNIYgpQgmBPljGHVvPsotQdpeRPldeOyrhXt+8KtnIcbPQ3wxN4J/
7Eflrg/VB1MQnp0D9/AIhJVT4FcC9Ow49u4Hxr4mxE5Dfn0GcmJ2n1czkOOB
A05CfnmCcjTGpkfzRnwafGzW81vEqlfjP75fz31y2P/fb1ecZGI=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolfram-media.com\"\>"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", 
       GraphicsBox[
        TagBox[RasterBox[CompressedData["
1:eJwBMAPP/CFib1JmAgAAAHMIAAAAUmF3QXJyYXlTBAAAAEJ5dGViAwAAABAA
AAAQAAAAAwAAACEbDSoeCDQqEUYuElA4ElpDGmVEGXxYJJmLQG86BmswBGdM
HWNUK1UxDUg+Gj49ISseDTgYAUMgBFEpBlwtA2wyAHY4B8igQe7ZbIRNFINp
MH1+RHdwOWxiL15YKFM8GjYoDkIgBVApCF0wB2g4CHo+DJx2Nf3zgPvufL2k
SpePR5NnJopTE4BgJXRoNGdbKz8xFEooBVsxC2o1CXg/CoNzN9fRb/ujNfuC
Ge+eNa6ZRqlcDqFRDJmMRo97QHljJ0s5FVsrBWk2CXc/DoRrK6WgTvvmc/+I
GPeBE//ab9TFaL+FM7KgTrSkV6OMPJR8PllCGGctB3I9B4NxMZCPTN+aO/3Y
ZfmsOv/XaPn4evbfa9S9X9C9X8ZsFrZiDKR+N2RIGXM1BINsKZKKSbOkU/zc
ZfzhbvrgafnrcfyYKPt+EuudOOTJYtlkB8h7IbelT3NZJoBsLZGMSp1tI+N8
Ff2PHv2FFfqoOPrgaf+CFv+LIfvjdfDjeueiPdjSdMesUX93NpB4OpmQRb98
Jf5zDP1zCPaQIfnldf3zgv2uRf/hb/vqdP7aaPTQYujSbNqtUIxkJptWEaaV
R++cNPxzCf6kMvzncv/caP7JV/vQYPXvc/eWJft3Cvx+EPO3Sei/Vpx/OaeV
QcnIa/uXJf2MIv75gfz2fv2PHPxqA/uuOvvhcP+NI/9sBP+uQv3/ifHFWqSG
PbWLOfLSZfnKVv7cYPzTYf3cafyMIP+gMvz7h/vqeP+NG/iyQvrmc/vQYP/X
ZbNTB9R9IPncZvvQYP3ca/vCV/vob/rLVfvgbf3MZf7fa//OWPz8jP3sePvD
Sv7bY791IPbkdPj8gfzKUf3XavnOXv64RvvCUf7kdffET/vocv3OWvu7Tf23
SP3MVv3YZt3MYP7RXv2tOv61Qv3gavyNGfptAfuyQf7obv7KWvzkav2PHv1o
Afx5D/3GUvzcdfb6i/6fMf1qAv2mM/nibvuLJfyvOfz9iP32gv3KV/vmc/yU
Jf12CvvHWfj/jf/kbzBApaY=
          "], {{0, 16}, {16, 0}}, {0, 255},
          ColorFunction->RGBColor],
         BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
         Selectable->False],
        BaseStyle->"ImageGraphics",
        ImageSizeRaw->{16, 16},
        PlotRange->{{0, 16}, {0, 16}}], ",", "\<\"wolframscience.com\"\>"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{495, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21166485]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RefreshIconCache",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/RefreshIconCache"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetFavicon",
    BaseStyle->"Link",
    ButtonData->"paclet:RandomWalkWeb/ref/GetFavicon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->363792060]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexIcon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 35.0031808}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "VertexIcon is an option to RandomWalkGraph that specifies whether \
vertices should be rendered using favorite icons.", "synonyms" -> {}, "title" -> 
    "VertexIcon", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/VertexIcon"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6515, 196, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->918734349]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70328, 1482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[603, 21, 76, 1, 3, "SymbolColorBar"],
Cell[682, 24, 209, 5, 19, "LinkTrail"],
Cell[894, 31, 2910, 65, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3829, 100, 53, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[3885, 103, 655, 19, 99, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4577, 127, 580, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->178577625],
Cell[5160, 146, 598, 19, 70, "Notes",
 CellID->1067943069],
Cell[5761, 167, 357, 11, 70, "Notes",
 CellID->26365346],
Cell[6121, 180, 357, 11, 70, "Notes",
 CellID->362121298]
}, Closed]],
Cell[CellGroupData[{
Cell[6515, 196, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->918734349],
Cell[CellGroupData[{
Cell[7001, 213, 148, 5, 31, "ExampleSection",
 CellID->894327182],
Cell[7152, 220, 122, 3, 28, "Input",
 CellID->180104251],
Cell[7277, 225, 95, 1, 32, "ExampleText",
 CellID->9511472],
Cell[CellGroupData[{
Cell[7397, 230, 348, 8, 47, "Input",
 CellID->3085760],
Cell[7748, 240, 28292, 536, 202, "Output",
 CellID->90432115]
}, Open  ]],
Cell[CellGroupData[{
Cell[36077, 781, 374, 9, 47, "Input",
 CellID->59355296],
Cell[36454, 792, 30576, 583, 286, "Output",
 CellID->21166485]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67091, 1382, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[67511, 1396, 538, 18, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[68086, 1419, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[68508, 1433, 168, 3, 70, "MoreAbout",
 CellID->1665078683],
Cell[68679, 1438, 147, 3, 70, "MoreAbout",
 CellID->363792060]
}, Open  ]],
Cell[68841, 1444, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

