(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14585,        463]
NotebookOptionsPosition[     11256,        356]
NotebookOutlinePosition[     12953,        404]
CellTagsIndexPosition[     12868,        399]
WindowTitle->VertexType - Wolfram Mathematica
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar",
 CellMargins->{{Inherited, Inherited}, {-5, 0}}],

Cell[TextData[{
 ButtonBox["RandomWalkWeb Package",
  BaseStyle->{"Link", "LinkTrail"},
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 StyleBox[" > ", "LinkTrailSeparator"]
}], "LinkTrail"],

Cell[BoxData[GridBox[{
   {Cell["RANDOMWALKWEB PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkGraph\"\>":>
       Documentation`HelpLookup["paclet:RandomWalkWeb/ref/RandomWalkGraph"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"SeeAlsoSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb Package\"\>":>
       Documentation`HelpLookup[
       "paclet:RandomWalkWeb/guide/RandomWalkWebPackage"], "\<\"Options \
Management\"\>":>Documentation`HelpLookup["paclet:guide/OptionsManagement"]},
       Appearance->None,
       MenuAppearance->Automatic,
       MenuStyle->"MoreAboutSection"]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RandomWalkWeb/ref/VertexType\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["RandomWalkWeb/ref/VertexType"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.unrealizedrealities.com/mathematica/\
RandomWalkWeb/ref/VertexType.html"], StandardForm]], "Input", 
              TextClipboardType -> "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.unrealizedrealities.com/mathematica/", 
             "RandomWalkWeb/ref/VertexType", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["VertexType", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["VertexType",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/VertexType"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GetStepData",
       BaseStyle->"Link",
       ButtonData->"paclet:RandomWalkWeb/ref/GetStepData"]], "InlineFormula"],
     " and related functions that determines the type of vertices returned by \
the function."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  Appearance->{Automatic, None},
  BaseStyle->None,
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"], 
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], After, CellContents]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->49048690],

Cell[TextData[{
 "To use ",
 Cell[BoxData[
  ButtonBox["VertexType",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/VertexType"]], "InlineFormula"],
 ", you first need to load the ",
 StyleBox[ButtonBox["RandomWalkWeb",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"],
 " using ",
 Cell[BoxData[
  RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell["Possible settings include:", "Notes",
 CellID->13890002],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DomainName\>\"", Cell[
    "labels vertices using domain name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hostname\>\"", Cell[
    "labels vertices by hostname", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->629461856]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194437546],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->169700712],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<RandomWalkWeb`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160070784],

Cell["Label vertices using domain name:", "ExampleText",
 CellID->758379001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"VertexType", "\[Rule]", "\"\<DomainName\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->810720801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"mathematica-journal.com\"\>", ",", "\<\"wolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"stephenwolfram.com\"\>", ",", "\<\"wolframalpha.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframalpha.com\"\>", ",", "\<\"wolframscience.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"mathematica-journal.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", ",", "\<\"wolframscience.com\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram-media.com\"\>", ",", "\<\"stephenwolfram.com\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolframscience.com\"\>", ",", "\<\"wolfram-media.com\"\>"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{577, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->962014071]
}, Open  ]],

Cell["Label vertices by hostname:", "ExampleText",
 CellID->638222872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetStepData", "[", 
  RowBox[{"\"\<http://wolfram.com/\>\"", ",", 
   RowBox[{"{", "2", "}"}], ",", "7", ",", 
   RowBox[{"VertexType", "\[Rule]", "\"\<Hostname\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32718880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"blog.stephenwolfram.com\"\>", 
     ",", "\<\"www.wolframalpha.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"wolfram.com\"\>", 
     ",", "\<\"www.mathematica-journal.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.mathematica-journal.com\"\>", 
     ",", "\<\"www.wolfram.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolframalpha.com\"\>", 
     ",", "\<\"www.wolframscience.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolfram.com\"\>", 
     ",", "\<\"www.wolframscience.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolfram-media.com\"\>", 
     ",", "\<\"blog.stephenwolfram.com\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"www.wolframscience.com\"\>", 
     ",", "\<\"www.wolfram-media.com\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{356, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->999820705]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["RandomWalkGraph",
   BaseStyle->"Link",
   ButtonData->"paclet:RandomWalkWeb/ref/RandomWalkGraph"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Appearance->{Automatic, None},
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"], 
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], After, 
     CellContents]}]& )]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["RandomWalkWeb Package",
 BaseStyle->"Link",
 ButtonData->"paclet:RandomWalkWeb/guide/RandomWalkWebPackage"]], "MoreAbout",
 CellID->1665078683],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->363792060]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexType - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2012, 9, 30, 0, 27, 37.1931838}", "context" -> 
    "RandomWalkWeb`", 
    "keywords" -> {"random walk World Wide Web WWW visualization data"}, 
    "index" -> True, "label" -> "RandomWalkWeb Package Symbol", "language" -> 
    "en", "paclet" -> "RandomWalkWeb", "status" -> "None", "summary" -> 
    "VertexType is an option for GetStepData and related functions that \
determines the type of vertices returned by the function.", "synonyms" -> {}, 
    "title" -> "VertexType", "type" -> "Symbol", "uri" -> 
    "RandomWalkWeb/ref/VertexType"}, "LinkTrails" -> "", 
  "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "8.0 for Microsoft Windows (64-bit) (October 6, 2011)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6249, 183, 461, 13, 45, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->194437546]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12725, 392}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[603, 21, 76, 1, 3, "SymbolColorBar"],
Cell[682, 24, 209, 5, 19, "LinkTrail"],
Cell[894, 31, 2805, 63, 46, "AnchorBarGrid",
 CellID->1],
Cell[CellGroupData[{
Cell[3724, 98, 53, 1, 51, "ObjectName",
 CellID->1224892054],
Cell[3780, 101, 653, 18, 99, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4470, 124, 579, 17, 39, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->49048690],
Cell[5052, 143, 598, 19, 70, "Notes",
 CellID->1067943069],
Cell[5653, 164, 62, 1, 70, "Notes",
 CellID->13890002],
Cell[5718, 167, 494, 11, 70, "2ColumnTableMod",
 CellID->629461856]
}, Closed]],
Cell[CellGroupData[{
Cell[6249, 183, 461, 13, 45, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194437546],
Cell[CellGroupData[{
Cell[6735, 200, 148, 5, 31, "ExampleSection",
 CellID->169700712],
Cell[6886, 207, 122, 3, 28, "Input",
 CellID->160070784],
Cell[7011, 212, 76, 1, 32, "ExampleText",
 CellID->758379001],
Cell[CellGroupData[{
Cell[7112, 217, 256, 6, 28, "Input",
 CellID->810720801],
Cell[7371, 225, 964, 28, 88, "Output",
 CellID->962014071]
}, Open  ]],
Cell[8350, 256, 70, 1, 32, "ExampleText",
 CellID->638222872],
Cell[CellGroupData[{
Cell[8445, 261, 253, 6, 28, "Input",
 CellID->32718880],
Cell[8701, 269, 1027, 28, 139, "Output",
 CellID->999820705]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9789, 304, 417, 12, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10209, 318, 228, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10474, 329, 419, 12, 70, "MoreAboutSection",
 CellID->38303248],
Cell[10896, 343, 168, 3, 70, "MoreAbout",
 CellID->1665078683],
Cell[11067, 348, 147, 3, 70, "MoreAbout",
 CellID->363792060]
}, Open  ]],
Cell[11229, 354, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

